<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$monarch_sections = array(
							'sharing' => array(
											'title' => __( 'Social Sharing', 'Monarch' ),
											'contents' => array(
															'locations' => __( 'Locations', 'Monarch' ),
															'networks' =>  __( 'Networks', 'Monarch' ),
															'sidebar' => __( 'Sidebar', 'Monarch' ),
															'inline' => __( 'Inline', 'Monarch' ),
															'popup' => __( 'Pop Up', 'Monarch' ),
															'flyin' => __( 'Fly In', 'Monarch' ),
															'media' => __( 'On Media', 'Monarch' ),
														),
											),
							'follow' => array(
											'title' => __( 'Social Follow', 'Monarch' ),
											'contents' => array(
															'networks' => __( 'Networks', 'Monarch' ),
															'widget' => __( 'Widget', 'Monarch' ),
															'shortcode' => __( 'Shortcode', 'Monarch' ),
														),
										),
							'general' => array(
											'title' => __( 'General Settings', 'Monarch' ),
											'contents' => array(
															'main' => __( 'Main', 'Monarch' ),
														),
										),
							'header' => array(
											'contents' => array(
															'importexport'=>__( 'Import & Export','Monarch' ),
															'stats'=>__( 'Social Sharing Stats','Monarch' ),
														),
										),
						);
$monarch_options_all = array(
							'icon_style' => array(
												'type' => 'select_style',
												'title' => __( 'Choose icon style', 'Monarch' ),
												'name' => 'icon_style',
												'value' => array( 'flip', 'darken', 'slide', 'simple' ),
												'default' => 'slide',
												'default_media' => 'simple',
											),
							'icon_style_sidebar' => array(
												'type' => 'select_style',
												'title' => __( 'Choose icon style', 'Monarch' ),
												'name' => 'icon_style',
												'value' => array( 'flip', 'border', 'grow', 'slide', 'simple' ),
												'default' => 'flip',
											),
							'icon_shape' => array(
												'type' => 'select_shape',
												'title' => __( 'Choose icon shape', 'Monarch' ),
												'name' => 'icon_shape',
												'value' => array( 'rectangle', 'rounded', 'circle' ),
												'default' => 'rounded',
												'default_sidebar' => 'rectangle',
											),
							'title_text' => array(
												'section_start' => array(
																		'type' => 'section_start',
																		'title'=> __( 'Title', 'Monarch' ),
																	),
												'option' => array(
																'type' => 'text',
																'rows' => '1',
																'name' => 'title_text',
																'placeholder' => __( 'Share This', 'Monarch' ),
																'default' => __( 'Share This', 'Monarch' ),
																'is_wpml_string' => 'true',
															),
											),
							'message_text' => array(
												'section_start' => array(
																	'type' => 'section_start',
																	'title'=> __( 'Message', 'Monarch' ),
																	),
												'option' => array(
																'type' => 'text',
																'rows' => '2',
																'name' => 'message_text',
																'placeholder' => __( 'Insert Text', 'Monarch' ),
																'default' => __( 'Share this post with your friends!', 'Monarch' ),
																'is_wpml_string' => 'true',
															),
											),
							'api_settings' => array(
													'section_start' => array(
																			'type' => 'section_start',
																			'title' => __( 'API Settings', 'Monarch' ),
																			'name' => 'follow_api',
																			'display_if' => true,
																		),
													'section_start_general' => array(
																			'type' => 'section_start',
																			'title' => __( 'API Settings', 'Monarch' ),
																		),
													'sub_section_vimeo' => array(
																			'type' => 'section_start',
																			'sub_section' => true,
																			'title' => __( 'Vimeo', 'Monarch' ),
																			'class' => 'et_social_vimeo_api et_social_api_setting',
																	),
													'option_vimeo_1' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'vimeo_id',
																			'title' => __( 'Client ID', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_client_id',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#vimeo' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'option_vimeo_2' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'vimeo_secret',
																			'title' => __( 'Client Secret', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_client_secret',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#vimeo' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'sub_section_instagram' => array(
																				'type' => 'section_start',
																				'sub_section' => true,
																				'title'=> __( 'Instagram', 'Monarch' ),
																				'class' => 'et_social_instagram_api et_social_api_setting',
																			),
													'option_instagram_1' => array(
																				'type' => 'input_field',
																				'subtype' => 'text',
																				'name' => 'instagram_id',
																				'title' => __( 'Client ID', 'Monarch' ),
																				'default' => '',
																				'class' => 'api_option api_option_client_id',
																				'hide_contents' => true,
																				'hint_text' => sprintf(
																					'<a href="%2$s" target="_blank">%1$s</a>',
																					__( 'Click here for more information', 'Monarch' ),
																					esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#instagram' )
																				),
																				'hint_text_with_links' => 'on',
																			),
													'option_instagram_2' => array(
																				'type' => 'input_field',
																				'subtype' => 'text',
																				'name' => 'instagram_secret',
																				'title' => __( 'Client Secret', 'Monarch' ),
																				'default' => '',
																				'class' => 'api_option api_option_client_secret',
																				'hide_contents' => true,
																				'hint_text' => sprintf(
																					'<a href="%2$s" target="_blank">%1$s</a>',
																					__( 'Click here for more information', 'Monarch' ),
																					esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#instagram' )
																				),
																				'hint_text_with_links' => 'on',
																			),
													'sub_section_linkedin' => array(
																				'type' => 'section_start',
																				'sub_section' => true,
																				'title'=> __( 'LinkedIn', 'Monarch' ),
																				'class' => 'et_social_linkedin_api et_social_api_setting',
																			),
													'option_linkedin_1' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'linkedin_id',
																			'title' => __( 'API Key', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_client_id',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#linkedin' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'option_linkedin_2' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'linkedin_secret',
																			'title' => __( 'Secret Key', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_client_secret',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#linkedin' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'sub_section_twitter' => array(
																				'type' => 'section_start',
																				'sub_section' => true,
																				'title'=> __( 'Twitter', 'Monarch' ),
																				'class' => 'et_social_twitter_api et_social_api_setting',
																			),
													'option_twitter_1' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'twitter_api_key',
																			'title' => __( 'Consumer Key', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_api_key',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'option_twitter_2' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'twitter_api_secret',
																			'title' => __( 'Consumer Secret', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_api_secret',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'option_twitter_3' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'twitter_token',
																			'title' => __( 'Access Token', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_token',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'option_twitter_4' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'twitter_token_secret',
																			'title' => __( 'Access Token Secret', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_token_secret',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'sub_section_facebook' => array(
																			'type' => 'section_start',
																			'sub_section' => true,
																			'title' => __( 'Facebook', 'Monarch' ),
																			'class' => 'et_social_facebook_api',
																	),
													'option_facebook_1' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'facebook_id',
																			'title' => __( 'App ID', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_client_id',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#facebook' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'option_facebook_2' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'facebook_secret',
																			'title' => __( 'App Secret', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_client_secret',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#facebook' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'sub_section_youtube' => array(
																			'type' => 'section_start',
																			'sub_section' => true,
																			'title' => __( 'Youtube', 'Monarch' ),
																			'class' => 'et_social_youtube_api et_social_api_setting',
																	),
													'option_youtube_1' => array(
																			'type' => 'input_field',
																			'subtype' => 'text',
																			'name' => 'youtube_api_key',
																			'title' => __( 'API Key', 'Monarch' ),
																			'default' => '',
																			'class' => 'api_option api_option_api_key',
																			'hide_contents' => true,
																			'hint_text' => sprintf(
																				'<a href="%2$s" target="_blank">%1$s</a>',
																				__( 'Click here for more information', 'Monarch' ),
																				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#youtube' )
																			),
																			'hint_text_with_links' => 'on',
																		),
													'auth_button_vimeo' => array(
																			'type' => 'button',
																			'title' => __( 'Authorize', 'Monarch' ),
																			'link' => '#',
																			'class' => 'et_authorize_api',
																			'action' => 'vimeo'
																	),
													'auth_button_instagram' => array(
																				'type' => 'button',
																				'title' => __( 'Authorize', 'Monarch' ),
																				'link' => '#',
																				'class' => 'et_authorize_api',
																				'action' => 'instagram'
																	),
													'auth_button_linkedin' => array(
																				'type' => 'button',
																				'title' => __( 'Authorize', 'Monarch' ),
																				'link' => '#',
																				'class' => 'et_authorize_api',
																				'action' => 'linkedin'
																	),
													'auth_button_twitter' => array(
																				'type' => 'button',
																				'title' => __( 'Authorize', 'Monarch' ),
																				'link' => '#',
																				'class' => 'et_authorize_api et_authorize_twitter',
																				'action' => 'twitter'
																	),
													'auth_button_facebook' => array(
																			'type' => 'button',
																			'title' => __( 'Authorize', 'Monarch' ),
																			'link' => '#',
																			'class' => 'et_authorize_api',
																			'action' => 'facebook'
																	),
													'auth_button_youtube' => array(
																			'type' => 'button',
																			'title' => __( 'Authorize', 'Monarch' ),
																			'link' => '#',
																			'class' => 'et_authorize_api',
																			'action' => 'youtube'
																	),
												),
							'display_settings' => array(
													'section_start' => array(
																			'type' => 'section_start',
																			'title'=> __( 'Display Settings', 'Monarch' ),
																		),
													'icons_placement' => array(
																			'type' => 'select',
																			'title' => __( 'Icon Placement', 'Monarch' ),
																			'name' => 'icons_location',
																			'value' => array( 'top '=> __( 'Centered', 'Monarch' ),'left' => __( 'Left', 'Monarch' ) ),
																			'default' => 'top',
																		),
													'icons_location_2' => array(
																			'type' => 'select',
																			'title' => __( 'Choose Location', 'Monarch' ),
																			'name' => 'icons_location',
																			'value' => array( 'bottom_right' => __( 'Bottom Right', 'Monarch' ),'bottom_left' => __( 'Bottom Left', 'Monarch' ) ),
																			'default' => 'bottom_right',
																		),
													'icons_location_3' => array(
																			'type' => 'select',
																			'title' => __( 'Choose Location', 'Monarch' ),
																			'name' => 'icons_location',
																			'value' => array( 'above' => __( 'Above Content', 'Monarch' ),'below' => __( 'Below Content', 'Monarch' ),'above_below' => __( 'Above + Below', 'Monarch' ) ),
																			'default' => 'above'
																		),
													'icons_alignment' => array(
																			'type' => 'select',
																			'title' => __( 'Icon Alignment', 'Monarch' ),
																			'name' => 'icons_alignment',
																			'value' => array( 'left' => __( 'Left', 'Monarch' ),'top' => __( 'Centered', 'Monarch' ) ),
																			'default' => 'left',
																		),
													'col_number_3' => array(
																			'type' => 'select',
																			'title' => __( 'Number of Columns', 'Monarch' ),
																			'name' => 'col_number',
																			'value' => array( 'auto' => __( 'Auto Width', 'Monarch' ), '1' => '1', '2' => '2', '3' => '3' ),
																			'default' => '2',
																		),
													'col_number_4' => array(
																			'type' => 'select',
																			'title' => __( 'Choose Number of Columns', 'Monarch' ),
																			'name' => 'col_number',
																			'value' => array( 'auto' => __( 'Auto Width', 'Monarch' ), '1' => '1', '2' => '2', '3' => '3', '4' => '4' ),
																			'default' => '2',
																		),
													'col_number_6' => array(
																			'type' => 'select',
																			'title' => __( 'Number of Columns', 'Monarch' ),
																			'name' => 'col_number',
																			'value' => array( 'auto' => __( 'Auto Width', 'Monarch' ),'1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ),
																			'default' => 'auto',
																			'default_inline' => '4',
																			'default_popup' => '3',
																		),
													'sidebar_orientation' => array(
																			'type' => 'select',
																			'title' => __( 'Sidebar Orientation', 'Monarch' ),
																			'name' => 'sidebar_orientation',
																			'value' => array( 'left' => __( 'Left', 'Monarch' ),'right' => __( 'Right', 'Monarch' ) ),
																			'default' => 'left',
																		),
													'animation' => array(
																		'type' => 'select',
																		'title' => __( 'Intro Animation', 'Monarch' ),
																		'name' => 'animation',
																		'value' => array( 'no_animation' => __( 'No Animation', 'Monarch' ), 'fadein' => __( 'Fade In', 'Monarch' ),'slideright' => __( 'Slide Right', 'Monarch' ),'slideup' => __( 'Slide Up', 'Monarch' ),'slidedown' => __( 'Slide Down', 'Monarch' ),'slideup' => __( 'Slide Up', 'Monarch' ) ),
																		'value_popup' => array( 'no_animation' => __( 'No Animation', 'Monarch' ), 'fadein' => __( 'Fade In', 'Monarch' ),'slideright' => __( 'Slide Right', 'Monarch' ),'slideup' => __( 'Slide Up', 'Monarch' ),'slidedown' => __( 'Slide Down', 'Monarch' ),'slideup' => __( 'Slide Up', 'Monarch' ),'lightspeedin' => __( 'Light Speed', 'Monarch' ),'zoomin' => __( 'Zoom In', 'Monarch' ),'flipinx' => __( 'Flip', 'Monarch' ),'bounce' => __( 'Bounce', 'Monarch' ),'swing' => __( 'Swing', 'Monarch' ),'tada' => __( 'Tada!', 'Monarch' ) ),
																		'value_flyin' => array( 'no_animation' => __( 'No Animation', 'Monarch' ), 'fadein' => __( 'Fade In', 'Monarch' ),'slideright' => __( 'Slide Right', 'Monarch' ),'slideup' => __( 'Slide Up', 'Monarch' ),'slidedown' => __( 'Slide Down', 'Monarch' ),'slideup' => __( 'Slide Up', 'Monarch' ),'lightspeedin' => __( 'Light Speed', 'Monarch' ),'zoomin' => __( 'Zoom In', 'Monarch' ),'flipinx' => __( 'Flip', 'Monarch' ),'bounce' => __( 'Bounce', 'Monarch' ),'swing' => __( 'Swing', 'Monarch' ),'tada' => __( 'Tada!', 'Monarch' ) ),
																		'hint_text' => __( 'Define the animation that is used, when you load the page.', 'Monarch' ),
																		'default' => 'fadein',
																		'default_sidebar' => 'slideright',
																		'default_flyin' => 'slideup',
																		),
													'auto_popup' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Trigger After Time Delay', 'Monarch' ),
																		'name' => 'auto_popup',
																		'conditional' => 'popup_delay',
																		'default' => '1',
																		'default_flyin' => false,
																		),
													'popup_delay' => array(
																		'type' => 'input_field',
																		'subtype' => 'number',
																		'title' => __( 'Delay ( in seconds )', 'Monarch' ),
																		'name' => 'popup_delay',
																		'hint_text' => __( 'Define how many seconds you want to wait before the pop up appears on the screen.', 'Monarch' ),
																		'default' => '20',
																		'display_if' => true,
																	),
													'trigger_idle' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Trigger After Inactivity', 'Monarch' ),
																		'name' => 'trigger_idle',
																		'default' => false,
																		'conditional' => 'idle_timeout',
																		),
													'idle_timeout' => array(
																		'type' => 'input_field',
																		'subtype' => 'number',
																		'title' => __( 'Idle Timeout ( in seconds )', 'Monarch' ),
																		'name' => 'idle_timeout',
																		'hint_text' => __( 'Define how many seconds user should be inactive before the pop up appears on screen.', 'Monarch' ),
																		'default' => '15',
																		'display_if' => true,
																	),
													'trigger_bottom' => array(
																			'type' => 'checkbox',
																			'title' => __( 'Trigger At The Bottom Of Post', 'Monarch' ),
																			'name' => 'trigger_bottom',
																			'default' => false,
																			'default_flyin' => true,
																		),
													'trigger_comment' => array(
																			'type' => 'checkbox',
																			'title' => __( 'Trigger After Commenting', 'Monarch' ),
																			'name' => 'trigger_comment',
																		),
													'scroll_trigger' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Trigger After Scrolling', 'Monarch' ),
																		'name' => 'scroll_trigger',
																		'conditional' => 'scroll_pos',
																		'default' => false,
																		),
													'scroll_pos' => array(
																		'type' => 'input_field',
																		'subtype' => 'number',
																		'title' => __( 'Percentage Down The Page', 'Monarch' ),
																		'name' => 'scroll_pos',
																		'hint_text' => __( 'Define the % of the page to be scrolled before the pop up appears on the screen.', 'Monarch' ),
																		'default' => '50',
																		'display_if' => true,
																	),
													'trigger_purchase' => array(
																			'type' => 'checkbox',
																			'title' => __( 'Trigger After Purchasing', 'Monarch' ),
																			'name' => 'trigger_purchase',
																			'hint_text' => __( 'Display on "Thank you" page of WooCommerce after purchase', 'Monarch' ),
																			'default' => false,
																		),
													'counts' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Display Share Counts', 'Monarch' ),
																		'title_widget' => __( 'Display Follower Counts', 'Monarch' ),
																		'title_shortcode' => __( 'Display Follower Counts', 'Monarch' ),
																		'name' => 'counts',
																		'conditional' => 'counts_num',
																		'conditional_2' => 'outer_color',
																		'default' => false,
																		'default_inline' => '1',
																		'default_popup' => '1',
																		'default_widget' => '1',
																		'default_shortcode' => '1',
																	),
													'counts_num' => array(
																		'type' => 'input_field',
																		'subtype' => 'number',
																		'title' => __( 'Minimum Count Display', 'Monarch' ),
																		'name' => 'counts_num',
																		'hint_text' => __( 'Threshold that must be reached for each network before a number is displayed.', 'Monarch' ),
																		'default' => '0',
																		'display_if' => true,
																	),
													'total' => array(
																	'type' => 'checkbox',
																	'title' => __( 'Display Total Shares', 'Monarch' ),
																	'title_widget' => __( 'Display Total Followers', 'Monarch' ),
																	'title_shortcode' => __( 'Display Total Followers', 'Monarch' ),
																	'name' => 'total',
																	'conditional' => 'total_color',
																	'conditional_2' => 'outer_color',
																	'default' => false,
																	'default_widget' => '1',
																	'default_shortcode' => '1',
																),
													'total_color' => array(
																		'type' => 'select',
																		'title' => __( 'Total Shares Text Color', 'Monarch' ),
																		'name' => 'total_color',
																		'value' => array( 'dark' => __( 'Dark', 'Monarch' ), 'light' => __( 'Light', 'Monarch' ) ),
																		'hint_text' => __( 'Choose what color the Total Shares Text should be, depending on the background color of your website.' ),
																		'default' => 'dark',
																		'display_if' => true,
																	),
													'outer_color' => array(
																		'type' => 'select',
																		'title' => __( 'Outer Text Color', 'Monarch' ),
																		'name' => 'outer_color',
																		'value' => array( 'dark' => __( 'Dark', 'Monarch' ), 'light' => __( 'Light', 'Monarch' ) ),
																		'hint_text' => 'This color setting only applies to the total count, and network names/counts ( when circle buttons are used )',
																		'default' => 'dark',
																		'display_if' => true,
																	),
													'network_names' => array(
																			'type' => 'checkbox',
																			'title' => __( 'Display Network Names', 'Monarch' ),
																			'name' => 'network_names',
																			'default' => '1',
																			'conditional' => 'outer_color',
																		),
													'display_all' => array(
																			'type' => 'checkbox',
																			'title' => __( "Display 'All Networks' Button" , 'Monarch' ),
																			'name' => 'display_all',
																			'hint_text' => 'This button allows users to select and share from all available social networks.',
																			'default' => false
																		),
													'spacing' => array(
																	'type' => 'checkbox',
																	'title' => __( 'Add Icon Spacing', 'Monarch' ),
																	'name' => 'spacing',
																	'default' => false,
																),
													'no_spacing' => array(
																	'type' => 'checkbox',
																	'title' => __( 'Remove Icon Spacing', 'Monarch' ),
																	'name' => 'spacing',
																	'default' => false,
																),
													'mobile' => array(
																	'type' => 'checkbox',
																	'title' => __( 'Hide On Mobile Devices', 'Monarch' ),
																	'name' => 'mobile',
																	'default' => false,
																),
													'cookies' => array(
																	'type' => 'checkbox',
																	'title' => __( 'Display Once Per Session', 'Monarch' ),
																	'name' => 'cookies',
																	'conditional' => 'cookie_duration',
																	'default' => false,
																),
													'cookie_duration' => array(
																			'type' => 'input_field',
																			'subtype' => 'number',
																			'title' => __( 'Session Duration (in days)', 'Monarch' ),
																			'name' => 'cookie_duration',
																			'hint_text' => __( "Define the length of time (in days) that a session lasts for. For example, if you input 2 a user will only see a popup on your site every two days.", 'Monarch' ),
																			'default' => '1',
																			'display_if' => true,
																		),
													'use_api' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Get counts via API', 'Monarch' ),
																		'name' => 'use_api',
																		'hint_text' => __( 'if disabled, then manually specified values will be displayed', 'Monarch' ),
																		'conditional' => 'follow_api',
																		'default' => false,
																		'class' => 'et_social_api_trigger',
																),
													'new_window' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Open link in new window', 'Monarch' ),
																		'name' => 'new_window',
																		'hint_text' => __( 'Disable this option if you do not want to open Follow links in new window', 'Monarch' ),
																		'default' => '1',
																),
											),
									'general_settings' => array(
															'section_start' => array(
																					'type' => 'section_start',
																				),
															'update_freq' => array(
																				'type' => 'input_field',
																				'subtype' => 'number',
																				'title' => __( 'Frequency of count updates (in hours)', 'Monarch' ),
																				'name' => 'update_freq',
																				'hint_text' => __( "Adjust how often the plugin grabs and caches the counts from social networks that support APIs. Set to 0 if you don't want to use cache.", 'Monarch' ),
																				'default' => '3',
																				),
															'reset_postdata' =>  array(
																					'type' => 'checkbox',
																					'title' => __( 'Reset WordPress loops', 'Monarch' ),
																					'name' => 'reset_postdata',
																					'hint_text' => __( 'Enable the option if the plugin does not detect permalinks properly', 'Monarch' ),
																					'default' => false,
																			),
														),
								'custom_css' => array(
												'section_start' => array(
																	'type' => 'section_start',
																	'title'=>__( 'Custom CSS', 'Monarch' ),
																	),
												'option' => array(
																'type' => 'text',
																'rows' => '7',
																'name' => 'custom_css',
																'placeholder' => __( 'insert your custom CSS code', 'Monarch' ),
																'default' => '',
															),
											),
							'color_settings' =>array(
												'section_start' => array(
																		'type' => 'section_start',
																		'title'=>__( 'Color Settings', 'Monarch' ),
																		'subtitle' => __( 'If Background or Hover Background is not defined below, the default network colors will be used for that element.', 'Monarch' ),
																	),
												'custom_colors' => array(
																		'type' => 'checkbox',
																		'title' => __( 'Use Custom Colors', 'Monarch' ),
																		'name' => 'custom_colors',
																		'default' => false,
																	),
												'bg_color' => array(
																	'type' => 'color_picker',
																	'title' =>  __( 'Background Color', 'Monarch' ),
																	'name' => 'bg_color',
																	'placeholder' => __( 'Hex Value', 'Monarch' ),
																	'default' => '',
																),
												'bg_color_hover' => array(
																		'type' => 'color_picker',
																		'title' =>  __( 'Hover Background Color', 'Monarch' ),
																		'name' => 'bg_color_hover',
																		'placeholder' => __( 'Hex Value', 'Monarch' ),
																		'default' => '',
																	),
												'icon_color' => array(
																	'type' => 'color_picker',
																	'title' =>  __( 'Icon Color', 'Monarch' ),
																	'name' => 'icon_color',
																	'placeholder' => __( 'Hex Value', 'Monarch' ),
																	'default' => '',
																),
												'icon_color_hover' => array(
																		'type' => 'color_picker',
																		'title' =>  __( 'Hover Icon Color', 'Monarch' ),
																		'name' => 'icon_color_hover',
																		'placeholder' => __( 'Hex Value', 'Monarch' ),
																		'default' => '',
																	),
											),
							'post_types' => array(
												array(
													'type' => 'section_start',
													'title'=> __( 'Post Type Settings', 'Monarch' ),
												),
												array(
													'type' => 'checkbox_posts',
													'title' => __( 'Post Type Settings', 'Monarch' ),
													'name' => 'post_types',
													'include_home' => true,
													'default' => array( 'post' ),
													'default_sidebar' => array( 'post', 'page' ),
												),
												array(
													'type' => 'checkbox_posts',
													'title' => __( 'Post Type Settings', 'Monarch' ),
													'name' => 'post_types',
													'include_home' => false,
													'value' => array( 'post', 'product' ),
													'default' => array( 'post' ),
												),
											),
							'sorting_share' => array(
											'type' => 'sorting',
											'name' => 'networks_sorting',
											'value' => array( 'facebook' => __( 'Facebook', 'Monarch' ), 'twitter' => __( 'Twitter', 'Monarch' ), 'googleplus' => __( 'Google+', 'Monarch' ), 'buffer' => __( 'Buffer', 'Monarch' ), 'digg' =>  __( 'Digg', 'Monarch' ), 'evernote' =>  __( 'Evernote', 'Monarch' ), 'pinterest' =>  __( 'Pinterest', 'Monarch' ), 'friendfeed' =>  __( 'FriendFeed', 'Monarch' ), 'hackernews' =>  __( 'Hacker News', 'Monarch' ), 'livejournal' =>  __( 'LiveJournal', 'Monarch' ), 'newsvine' =>  __( 'Newsvine', 'Monarch' ), 'aol' =>  __( 'AOL', 'Monarch' ), 'gmail' =>  __( 'Gmail', 'Monarch' ), 'printfriendly' =>  __( 'Print Friendly', 'Monarch' ), 'yahoomail' =>  __( 'Yahoo Mail', 'Monarch' ), 'amazon' =>  __( 'Amazon', 'Monarch' ), 'delicious' =>  __( 'Delicious', 'Monarch' ), 'reddit' =>  __( 'reddit', 'Monarch' ), 'vkontakte' =>  __( 'VKontakte', 'Monarch' ), 'linkedin' =>  __( 'LinkedIn', 'Monarch' ), 'myspace' =>  __( 'Myspace', 'Monarch' ), 'blogger' =>  __( 'Blogger', 'Monarch' ), 'stumbleupon' =>  __( 'StumbleUpon', 'Monarch' ), 'tumblr' =>  __( 'Tumblr', 'Monarch' ), 'like' =>  __( 'Like', 'Monarch' ) ),
											'placeholder' => __( 'username', 'Monarch' ),
											'default' => array(),
										),
							'sorting_follow' => array(
											'type' => 'sorting',
											'name' => 'networks_sorting',
											'value' => array( 'facebook' => __( 'Facebook', 'Monarch' ), 'twitter' => __( 'Twitter', 'Monarch' ), 'googleplus' => __( 'Google+', 'Monarch' ), 'buffer' => __( 'Buffer', 'Monarch' ), 'pinterest' =>  __( 'Pinterest', 'Monarch' ), 'rss' => __( 'RSS', 'Monarch' ), 'behance' =>  __( 'Behance', 'Monarch' ), 'aweber' =>  __( 'AWeber', 'Monarch' ), 'blinklist' =>  __( 'BlinkList', 'Monarch' ), 'github' =>  __( 'GitHub', 'Monarch' ), 'mailchimp' =>  __( 'MailChimp', 'Monarch' ), 'outlook' =>  __( 'Outlook', 'Monarch' ), 'soundcloud' =>  __( 'SoundCloud', 'Monarch' ), 'baidu' =>  __( 'Baidu', 'Monarch' ), 'box' =>  __( 'Box', 'Monarch' ), 'digg' =>  __( 'Digg', 'Monarch' ), 'evernote' =>  __( 'Evernote', 'Monarch' ), 'friendfeed' =>  __( 'FriendFeed', 'Monarch' ), 'hackernews' =>  __( 'Hacker News', 'Monarch' ), 'livejournal' =>  __( 'LiveJournal', 'Monarch' ), 'newsvine' =>  __( 'Newsvine', 'Monarch' ), 'reddit' =>  __( 'reddit', 'Monarch' ), 'vkontakte' =>  __( 'VKontakte', 'Monarch' ), 'youtube' =>  __( 'YouTube', 'Monarch' ), 'amazon' =>  __( 'Amazon', 'Monarch' ), 'delicious' =>  __( 'Delicious', 'Monarch' ), 'instagram' =>  __( 'Instagram', 'Monarch' ), 'linkedin' =>  __( 'LinkedIn', 'Monarch' ), 'myspace' =>  __( 'Myspace', 'Monarch' ), 'picassa' =>  __( 'Picasa', 'Monarch' ), 'spotify' =>  __( 'Spotify', 'Monarch' ), 'yahoo' =>  __( 'Yahoo', 'Monarch' ), 'deviantart' =>  __( 'deviantART', 'Monarch' ), 'dribbble' =>  __( 'Dribbble', 'Monarch' ), 'flickr' =>  __( 'Flickr', 'Monarch' ), 'stumbleupon' =>  __( 'StumbleUpon', 'Monarch' ), 'tumblr' =>  __( 'Tumblr', 'Monarch' ), 'vimeo' =>  __( 'Vimeo', 'Monarch' ), 'like' =>  __( 'Like', 'Monarch' ) ),
											'placeholder' => 'http://',
											'default' => array(),
										),
							'manage_locations' => array(
													'type' => 'multi_select',
													'name' => 'manage_locations',
													'value' => array( 'sidebar' => __( 'Sidebar', 'Monarch' ), 'inline' => __( 'Inline', 'Monarch' ), 'popup' => __( 'Pop Up', 'Monarch' ), 'flyin' => __( 'Fly In', 'Monarch' ), 'media' => __( 'Media', 'Monarch' ) ),
													'default' => array( 'sidebar' ),
												),
							'shortcode_option' => array(
													'type' => 'shortcode',
													'button_text' => __( 'Generate Shortcode', 'Monarch' ),
													'name' => 'shortcode',
													'placeholder' => __( 'Click the button above to generate your shortcode here', 'Monarch' ),
													'default' => '',
												),
							'end_of_section' => array(
													'type' => 'section_end',
												),
							'end_of_sub_section' => array(
													'type' => 'section_end',
													'sub_section' => 'true',
												),
							'locations_title' => array(
													'type' => 'main_title',
													'title' => __( 'Manage Locations', 'Monarch' ),
													'subtitle' => __( 'You can select any combination of the five placements below.', 'Monarch' ),
												),
							'networks_title' => array(
													'type' => 'main_title',
													'title' => __( 'Manage Networks', 'Monarch' ),
													'subtitle' => __( 'Add and rearrange any combination of social networks below. You can define the Network Label and Username to the right of each.', 'Monarch' ),
												),
							'sidebar_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure sidebar share icons', 'Monarch' ),
												),
							'inline_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure inline share icons', 'Monarch' ),
												),
							'popup_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure social sharing pop up', 'Monarch' ),
												),
							'flyin_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure social sharing flyin', 'Monarch' ),
												),
							'media_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure media sharing icons', 'Monarch' ),
													'subtitle' => __( 'Media sharing is only applied to blog post content.', 'Monarch' ),
												),
							'widget_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure social follow widget', 'Monarch' ),
													'subtitle' => __( 'Any Monarch widget added to a widget area will use the following settings.', 'Monarch' ),
												),
							'shortcode_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure social follow shortcode', 'Monarch' ),
													'subtitle' => __( 'Define settings and generate a unique shortcode below', 'Monarch' ),
												),
							'general_title' => array(
													'type' => 'main_title',
													'title' => __( 'Configure general settings', 'Monarch' ),
												),
							'locations_note' => array(
													'type' => 'note',
													'text' => __( 'Selected locations will use the display settings defined from the menu on the left.', 'Monarch' ),
												),
							'networks_note' => array(
													'type' => 'note',
													'text' => __( 'Selected networks apply to all selected locations in "Locations" Settings.', 'Monarch' ),
												),
							'follow_location_note' => array(
													'type' => 'note',
													'text' => __( 'Selected networks apply to all widgets and shortcodes defined in the menu on the left.', 'Monarch' ),
												),
							'import_export' => array(
													'type' => 'import_export',
													'title' => __( 'Import/Export', 'Monarch' ),
													),
							'stats' => array(
											'type' => 'stats',
											'title' => __( 'Social Sharing Stats', 'Monarch' ),
											),
						);
$sharing_locations_options = array(
								$monarch_options_all[ 'locations_title' ],
								$monarch_options_all[ 'manage_locations' ],
								$monarch_options_all[ 'locations_note' ],

								);
$sharing_networks_options = array(
								$monarch_options_all[ 'networks_title' ],
								$monarch_options_all[ 'sorting_share' ],
								$monarch_options_all[ 'networks_note' ],
								);
$sharing_sidebar_options = array(
								$monarch_options_all[ 'sidebar_title' ],
								$monarch_options_all[ 'icon_style_sidebar' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'sidebar_orientation' ],
									$monarch_options_all[ 'display_settings' ][ 'animation' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'total_color' ],
									$monarch_options_all[ 'display_settings' ][ 'display_all' ],
									$monarch_options_all[ 'display_settings' ][ 'spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'post_types' ][ 0 ],
									$monarch_options_all[ 'post_types' ][ 1 ],
									$monarch_options_all[ 'end_of_section' ],
								);
$sharing_inline_options = array(
								$monarch_options_all[ 'inline_title' ],
								$monarch_options_all[ 'icon_style' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_location_3' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
									$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'network_names' ],
									$monarch_options_all[ 'display_settings' ][ 'display_all' ],
									$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
									$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'post_types' ][ 0 ],
									$monarch_options_all[ 'post_types' ][ 1 ],
									$monarch_options_all[ 'end_of_section' ],
							  );
$sharing_popup_options = array(
								$monarch_options_all[ 'popup_title' ],
								$monarch_options_all[ 'icon_style' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'title_text' ][ 'section_start' ],
									$monarch_options_all[ 'title_text' ][ 'option' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'message_text' ][ 'section_start' ],
									$monarch_options_all[ 'message_text' ][ 'option' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
									$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
									$monarch_options_all[ 'display_settings' ][ 'animation' ],
									$monarch_options_all[ 'display_settings' ][ 'auto_popup' ],
									$monarch_options_all[ 'display_settings' ][ 'popup_delay' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_idle' ],
									$monarch_options_all[ 'display_settings' ][ 'idle_timeout' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_bottom' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_comment' ],
									$monarch_options_all[ 'display_settings' ][ 'scroll_trigger' ],
									$monarch_options_all[ 'display_settings' ][ 'scroll_pos' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_purchase' ],
									$monarch_options_all[ 'display_settings' ][ 'cookies' ],
									$monarch_options_all[ 'display_settings' ][ 'cookie_duration' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'network_names' ],
									$monarch_options_all[ 'display_settings' ][ 'display_all' ],
									$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'post_types' ][ 0 ],
									$monarch_options_all[ 'post_types' ][ 1 ],
									$monarch_options_all[ 'end_of_section' ],
								);
$sharing_flyin_options = array(
								$monarch_options_all[ 'flyin_title' ],
								$monarch_options_all[ 'icon_style' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'title_text' ][ 'section_start' ],
									$monarch_options_all[ 'title_text' ][ 'option' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'message_text' ][ 'section_start' ],
									$monarch_options_all[ 'message_text' ][ 'option' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_location_2' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
									$monarch_options_all[ 'display_settings' ][ 'col_number_3' ],
									$monarch_options_all[ 'display_settings' ][ 'animation' ],
									$monarch_options_all[ 'display_settings' ][ 'auto_popup' ],
									$monarch_options_all[ 'display_settings' ][ 'popup_delay' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_idle' ],
									$monarch_options_all[ 'display_settings' ][ 'idle_timeout' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_bottom' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_comment' ],
									$monarch_options_all[ 'display_settings' ][ 'scroll_trigger' ],
									$monarch_options_all[ 'display_settings' ][ 'scroll_pos' ],
									$monarch_options_all[ 'display_settings' ][ 'trigger_purchase' ],
									$monarch_options_all[ 'display_settings' ][ 'cookies' ],
									$monarch_options_all[ 'display_settings' ][ 'cookie_duration' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'network_names' ],
									$monarch_options_all[ 'display_settings' ][ 'display_all' ],
									$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'post_types' ][ 0 ],
									$monarch_options_all[ 'post_types' ][ 1 ],
									$monarch_options_all[ 'end_of_section' ],
								);
$sharing_media_options = array(
								$monarch_options_all[ 'media_title' ],
								$monarch_options_all[ 'icon_style' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
									$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'network_names' ],
									$monarch_options_all[ 'display_settings' ][ 'display_all' ],
									$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
									$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'post_types' ][ 0 ],
									$monarch_options_all[ 'post_types' ][ 2 ],
									$monarch_options_all[ 'end_of_section' ],
								);
$follow_networks_options = array(
								$monarch_options_all[ 'networks_title' ],
								$monarch_options_all[ 'sorting_follow' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'new_window' ],
									$monarch_options_all[ 'display_settings' ][ 'use_api' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'api_settings' ][ 'section_start' ],
									$monarch_options_all[ 'api_settings' ][ 'sub_section_vimeo' ],
										$monarch_options_all[ 'api_settings' ][ 'option_vimeo_1' ],
										$monarch_options_all[ 'api_settings' ][ 'option_vimeo_2' ],
										$monarch_options_all[ 'api_settings' ][ 'auth_button_vimeo' ],
									$monarch_options_all[ 'end_of_sub_section' ],
									$monarch_options_all[ 'api_settings' ][ 'sub_section_instagram' ],
										$monarch_options_all[ 'api_settings' ][ 'option_instagram_1' ],
										$monarch_options_all[ 'api_settings' ][ 'option_instagram_2' ],
										$monarch_options_all[ 'api_settings' ][ 'auth_button_instagram' ],
									$monarch_options_all[ 'end_of_sub_section' ],
									$monarch_options_all[ 'api_settings' ][ 'sub_section_linkedin' ],
										$monarch_options_all[ 'api_settings' ][ 'option_linkedin_1' ],
										$monarch_options_all[ 'api_settings' ][ 'option_linkedin_2' ],
										$monarch_options_all[ 'api_settings' ][ 'auth_button_linkedin' ],
									$monarch_options_all[ 'end_of_sub_section' ],
									$monarch_options_all[ 'api_settings' ][ 'sub_section_twitter' ],
										$monarch_options_all[ 'api_settings' ][ 'option_twitter_1' ],
										$monarch_options_all[ 'api_settings' ][ 'option_twitter_2' ],
										$monarch_options_all[ 'api_settings' ][ 'option_twitter_3' ],
										$monarch_options_all[ 'api_settings' ][ 'option_twitter_4' ],
										$monarch_options_all[ 'api_settings' ][ 'auth_button_twitter' ],
									$monarch_options_all[ 'end_of_sub_section' ],
									$monarch_options_all[ 'api_settings' ][ 'sub_section_youtube' ],
										$monarch_options_all[ 'api_settings' ][ 'option_youtube_1' ],
										$monarch_options_all[ 'api_settings' ][ 'auth_button_youtube' ],
									$monarch_options_all[ 'end_of_sub_section' ],
								$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'follow_location_note' ],
								);
$follow_widget_options = array(
								$monarch_options_all[ 'widget_title' ],
								$monarch_options_all[ 'icon_style' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_placement' ],
									$monarch_options_all[ 'display_settings' ][ 'col_number_4' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'network_names' ],
									$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
									$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								);
$follow_shortcode_options = array(
								$monarch_options_all[ 'shortcode_title' ],
								$monarch_options_all[ 'icon_style' ],
								$monarch_options_all[ 'icon_shape' ],
								$monarch_options_all[ 'display_settings' ][ 'section_start' ],
									$monarch_options_all[ 'display_settings' ][ 'icons_placement' ],
									$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
									$monarch_options_all[ 'display_settings' ][ 'counts' ],
									$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
									$monarch_options_all[ 'display_settings' ][ 'total' ],
									$monarch_options_all[ 'display_settings' ][ 'network_names' ],
									$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
									$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
									$monarch_options_all[ 'display_settings' ][ 'mobile' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'color_settings' ][ 'section_start' ],
									$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
									$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
									$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
									$monarch_options_all[ 'end_of_section' ],
								$monarch_options_all[ 'shortcode_option' ],
								);
$general_main_options = array(
							$monarch_options_all[ 'general_title' ],
							$monarch_options_all[ 'general_settings' ][ 'section_start' ],
									$monarch_options_all[ 'general_settings' ][ 'update_freq' ],
									$monarch_options_all[ 'general_settings' ][ 'reset_postdata' ],
									$monarch_options_all[ 'end_of_section' ],
							$monarch_options_all[ 'api_settings' ][ 'section_start_general' ],
								$monarch_options_all[ 'api_settings' ][ 'sub_section_facebook' ],
										$monarch_options_all[ 'api_settings' ][ 'option_facebook_1' ],
										$monarch_options_all[ 'api_settings' ][ 'option_facebook_2' ],
										$monarch_options_all[ 'api_settings' ][ 'auth_button_facebook' ],
									$monarch_options_all[ 'end_of_sub_section' ],
								$monarch_options_all[ 'end_of_section' ],
							$monarch_options_all[ 'custom_css' ][ 'section_start' ],
									$monarch_options_all[ 'custom_css' ][ 'option' ],
									$monarch_options_all[ 'end_of_section' ],
								);
$header_importexport_options = array(
									$monarch_options_all[ 'import_export' ]
								);
$header_stats_options = array(
							$monarch_options_all[ 'stats' ]
							);