"use strict";

/**
 * Code-Port: "Hello {0}".format("World"); returns "Hello World"
 */
if (!String.prototype.format) {
  String.prototype.format = function() {
    var args = arguments;
    return this.replace(/{(\d+)}/g, function(match, number) { 
      return typeof args[number] != 'undefined'
        ? args[number]
        : match
      ;
    });
  };
} 

/**
 * Code-Port: Check if a string starts with a other string
 */
if (typeof String.prototype.startsWith != 'function') {
  String.prototype.startsWith = function (str){
    return this.indexOf(str) === 0;
  };
}

/**
 * Value not undefined
 */
function RMLisDefined(attr) {
    if (typeof attr !== typeof undefined && attr !== false && attr !== null) {
        return true;
    }
    return false;
}

window.rml = {};


var RML_HOOK = {
  hooks: [],
  
  register: function ( name, callback ) {
    if( 'undefined' == typeof( RML_HOOK.hooks[name] ) )
      RML_HOOK.hooks[name] = [];
    RML_HOOK.hooks[name].push( callback );
  },

  call: function ( name, args ) {
    if( 'undefined' != typeof( RML_HOOK.hooks[name] ) )
      for(var i = 0; i < RML_HOOK.hooks[name].length; ++i )
        if( false == RML_HOOK.hooks[name][i]( RML_HOOK, args ) ) { break; }
  },
  
  exists: function(name) {
      return 'undefined' != typeof( RML_HOOK.hooks[name]);
  }
};

window.rml.hooks = RML_HOOK;

/* TESTING NOT INTERESTING!
jQuery(document).ready(function($) {
  var holding = false, cnt = 0, secs = 350;
  
  function mrmlfasd() {
    var items = $("#__attachments-view-40 > li");
    $(items[Math.floor(Math.random()*items.length)]).clone().prependTo("#__attachments-view-40");
    
    if (cnt > 30) {
      secs = 25;
    }else if (cnt > 21) {
      secs = 100;
    }else if (cnt > 15) {
      secs = 170;
    }else if (cnt > 7) {
      secs = 250;
    }
    
    setTimeout(function() {
      mrmlfasd();
    }, secs);
    
    cnt++;
  }
  
  $(document).on("keydown",function(e) {
      if (holding) {
        return;
      }
      holding = true;
      mrmlfasd();
  });
});
*/