<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class RML_Backend {
	private static $me = null;
        
    private function __construct() {
        
    }
    
    /**
     * Data for the wp localize script.
     * 
     * @return array
     */
    private function localize_js() {
        $additional = array();

        return array_merge($additional, array(
            'lang' => array(
                "uploadingCollection"  => __('A collection can not contain files. Upload moved to root...', RML_TD),
                "uploadingGallery"     => __('A gallery can contain only images. Upload moved to root...', RML_TD),
                "deleteFailed"         => __('In this folder are sub directories, please delete them first!', RML_TD),
                "deleteRoot"           => __('Do not delete root. :(', RML_TD),
                "deleteConfirm"        => __('Would you like to delete this folder? Note: All files in this folder will be deleted.', RML_TD),
                "deleteConfirmTitle"   => __('Are you sure?', RML_TD),
                "deleteConfirmSubmit"  => __("Yes, delete it!", RML_TD),
                "deleteConfirmCancel"  => __("Cancel"),
                "renameRoot"           => __('Do not rename root. :(', RML_TD),
                "renamePrompt"         => __('Tell me the new name', RML_TD),
                "renamePromptTitle"         => __('Rename folder', RML_TD),
                "wipe"                  => __('Are you sure?', RML_TD),
                
                'mceButtonTooltip' => __('Gallery from Media Folder', RML_TD),
                'mceListBoxDirsTooltip' => __('Note: You can only select galleries. Folders and collections are grayed.', RML_TD),
                'mceBodyGallery' => __('Folder', RML_TD),
                'mceBodyLinkTo' => __('Link to'),
                'mceBodyColumns' => __('Columns'),
                'mceBodyRandomOrder' => __('Random Order'),
                'mceBodySize' => __('Size'),
                'mceBodyLinkToValues' => array(
                    array("value" => "post", "text" => __('Attachment File')),
                    array("value" => "file", "text" => __('Media File')),
                    array("value" => "none", "text" => __('None'))
                ),
                'mceBodySizeValues' => array(
                    array("value" => "thumbnail", "text" => __('Thumbnail')),
                    array("value" => "medium", "text" => __('Medium')),
                    array("value" => "large", "text" => __('Large')),
                    array("value" => "full", "text" => __('Full Size'))
                )
            )
        ));
    }
    
    public function admin_enqueue_scripts($hook) {
    	// Scripts
    	wp_enqueue_script('jquery');
    	wp_enqueue_script('rml-general', plugins_url( 'assets/js/general.js', RML_FILE ), array('jquery'), RML_VERSION);
    	wp_localize_script('rml-general', 'rmlOpts', apply_filters('RML/Backend/JS_Localize', $this->localize_js()));
    	wp_enqueue_script('rml-library', plugins_url( 'assets/js/library.js', RML_FILE ), array('jquery'), RML_VERSION);
    	wp_enqueue_script('rml-uploader', plugins_url( 'assets/js/uploader.js', RML_FILE ), array('jquery'), RML_VERSION);
    	wp_enqueue_script('rml-main', plugins_url( 'assets/js/main.js', RML_FILE ), array('jquery'), RML_VERSION);
    	
    	// Styles
    	wp_enqueue_style('font-awesome-fa',  'https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css');
    	wp_enqueue_style('rml-font',  plugins_url( 'assets/minifyfont/css/minifyfont.css', RML_FILE ), array(), RML_VERSION);
    	wp_enqueue_style('rml-main-style',  plugins_url( 'assets/css/main.css', RML_FILE ), array(), RML_VERSION);
    	wp_enqueue_style('rml-sweetalert',  plugins_url( 'assets/css/sweetalert.css', RML_FILE ), array(), RML_VERSION);
    }
    
    public function admin_footer() {
        $pathes = array(
            "inc/admin_footer/sidebar.dummy.php",
            );
        
        for ($i = 0; $i < count($pathes); $i++) {
            require_once(RML_PATH . '/' . $pathes[$i]);
        }
        
        // Render thickbox create folder gallery @deprecated
        //RML_Filter::getInstance()->add_media_display();
    }
    
    public static function getInstance() {
        if (self::$me == null) {
            self::$me = new RML_Backend();
        }
        return self::$me;
    }
}

?>