<?php
/**
 * Handles the shortcode for folder gallery.
 * 
 * @author MatthiasWeb
 * @since 2.2.3
 * @singleton
 * @link https://generatewp.com/take-shortcodes-ultimate-level/
 */
 
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
class RML_Folder_Shortcode {
    private static $me = null;
    public $shortcode_tag = 'folder_gallery';
    
    function __construct($args = array()){
        //add_shortcode( $this->shortcode_tag, array( $this, 'shortcode_handler' ) );
 
        if ( is_admin() ){
            add_action('admin_head', array( $this, 'admin_head') );
            add_action('admin_enqueue_scripts', array($this , 'admin_enqueue_scripts' ));
            add_filter('RML/Backend/JS_Localize', array($this, 'localize'));
        }
    }
    
    /**
     * Shortcode handler for FID attribute
     */
    public function shortcode_atts_gallery($out, $pairs, $atts) {
        $atts = shortcode_atts( array(
                'fid' => -2,
                'order' => 'DESC',
                'orderby' => 'date'
        ), $atts );
        
        if ($atts["fid"] > -2) {
            if ($atts["fid"] > -1) {
                $folder = RML_Structure::getInstance()->getFolderByID($atts["fid"]);
                if ($folder != null) {
                        $out["include"] .= ',' . implode(',', $folder->fetchFileIds($atts["order"], $atts["orderby"]));
                }
            }else{
                $out["include"] .= ',' . implode(',', RML_Folder::sFetchFileIds(-1, $atts["order"], $atts["orderby"]));
            }
            $out["include"] = ltrim($out["include"], ',');
            $out["include"] = rtrim($out["include"], ',');
        }
        
        // Overwrite the default order by this shortcode
        if (isset($out["orderby"]) && $out["orderby"] == "menu_order ID") {
            $out["orderby"] = "post__in";
        }
        
        return $out;
    }
    
    /**
     * Prepares the array of names slug array for the tinyMCE editor
     * button to add the shortcode.
     * 
     * @param $namesSlug Result of RML_View::namesSlugArray()
     * @return array
     */
    private function prepareDirsForMCE($namesSlug) {
        $result = array(
            array("text" => __('Select'), "value" => "")
        );
        
        if (is_array($namesSlug) && count($namesSlug) > 0) {
            $allowAllFolders = get_option('rml_all_folders_gallery', '');
            for ($i = 0; $i < count($namesSlug["names"]); $i++) {
                $disabled = false;
                
                if ($allowAllFolders != "1" && $namesSlug["types"][$i] != "2") {
                    $disabled = true;
                }
                
                $result[] = array(
                    "text" => $namesSlug["names"][$i],
                    "value" => $namesSlug["slugs"][$i],
                    "disabled" => $disabled
                );
            }
        }
        
        return $result;
    }
    
    /**
     * Localized variables for TinyMCE shortcode generator.
     */
    public function localize($arr) {
        $arr["mce"] = array(
            "dirs" => $this->prepareDirsForMCE(RML_Structure::getInstance()->getView()->namesSlugArray())
        );
        
        return $arr;
    }
 
    /**
     * shortcode_handler
     * @param  array  $atts shortcode attributes
     * @param  string $content shortcode content
     * @return string
     */
    function shortcode_handler($atts , $content = null){
        return "test";
    }
 
    /**
     * admin_head
     * calls your functions into the correct filters
     * @return void
     */
    function admin_head() {
        // check user permissions
        if ( !current_user_can( 'edit_posts' ) && !current_user_can( 'edit_pages' ) ) {
            return;
        }
 
        // check if WYSIWYG is enabled
        if ( 'true' == get_user_option( 'rich_editing' ) ) {
            add_filter( 'mce_external_plugins', array( $this ,'mce_external_plugins' ) );
            add_filter( 'mce_buttons', array($this, 'mce_buttons' ) );
        }
    }
 
    /**
     * mce_external_plugins
     * Adds our tinymce plugin
     * @param  array $plugin_array
     * @return array
     */
    function mce_external_plugins( $plugin_array ) {
        $plugin_array[$this->shortcode_tag] = plugins_url( 'assets/js/mce-buttons.js' , RML_FILE );
        return $plugin_array;
    }
 
    /**
     * mce_buttons
     * Adds our tinymce button
     * @param  array $buttons
     * @return array
     */
    function mce_buttons( $buttons ) {
        array_push( $buttons, $this->shortcode_tag );
        return $buttons;
    }
 
    /**
     * admin_enqueue_scripts
     * Used to enqueue custom styles
     * @return void
     */
    function admin_enqueue_scripts(){
         wp_enqueue_style('folder_gallery_panel_shortcode', plugins_url( 'assets/css/mce-buttons.css' , RML_FILE ) );
    }
    
    public static function getInstance() {
        if (self::$me == null) {
                self::$me = new RML_Folder_Shortcode();
        }
        return self::$me;
    }
}