<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file is responsible for the header of
	every page in the theme.
*/
?>
<!DOCTYPE html>
<!--[if IE 8]>
	<html class="no-js lt-ie9" lang="en">
<![endif]-->
<!--[if gt IE 8]><!--> <html class="nojs" lang="en" <?php language_attributes(); ?>> <!--<![endif]-->
<?php // 1. Head Section ?>
<head>

	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
	<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Expires" content="0" />
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<link rel="author" href="<?php echo get_template_directory_uri() ?>/humans.txt" />

	<link rel="icon" type="image/png" href="<?php echo get_theme_mod( 'favicon' ) ?>">

	<title>
		<?php /*
			global $page, $paged;
			wp_title( '|', true, 'right' );
			bloginfo( 'name' );
			$site_description = get_bloginfo( 'description', 'display' );
			if ( $site_description && ( is_home() || is_front_page() ) ) {
				echo " | $site_description";
			}
			if ( $paged >= 2 || $page >= 2 ) {
				echo ' | Page ' . max( $paged, $page );
			}

		*/?>
        <?php wp_title(''); ?>
	</title>

	<meta property="og:title" content="<?php echo bsh_page_title() ?>"/>
	<meta property="og:url" content="<?php echo bsh_canonical_url() ?>"/>
	<meta property="og:site_name" content="<?php bloginfo( 'name' ) ?>"/>
	<meta property="og:image" content="<?php echo bsh_page_image() ?>"/>

	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
    <script src="<?php echo get_stylesheet_directory_uri() ?>/js/classie.js"></script>
	<?php wp_head() ?>

	<!--[if gte IE 9]>
	  <style type="text/css">
	    .gradient {
	       filter: none;
	    }
	  </style>
	<![endif]-->

</head>
<?php $bodyClass = ( get_theme_mod( 'albumplayer' ) == 'no' ) ? 'noplayer' : '' ?>
<body <?php body_class( $bodyClass ); ?>>
<div id='musicoSiteContentContainerLoader'></div>
<div id="fb-root"></div>
<div id='load'></div>
<div class='load-inline hidden'></div>

<?php if( get_theme_mod( 'albumplayer' ) != 'no' ) : ?>
<div id='launchPlayerContainer'>
	<?php
		$link = get_theme_mod( 'albumplayer_custom_link' );
		$launch_text = get_theme_mod( 'albumplayer_launch_text' );
		$close_text = get_theme_mod( 'albumplayer_close_text' );
		if( !empty( $link ) ) :
	?>
		<a href='<?php echo $link ?>' target='_blank' id='launchPlayerLink'><?php echo $launch_text ?></a>
	<?php else : ?>
		<a href='#' id='launchPlayer' data-open_text='<?php echo $launch_text ?>' data-close_text='<?php echo $close_text ?>'><?php echo $launch_text ?></a>
	<?php endif ?>
</div>
<?php endif ?>
    <!-- Sidebar for social media icons -->
    <?php if ( is_active_sidebar( 'sidebar-7' ) ) : ?>
        <div class="row">
        	<div class="columns twelve">
                <div id="sidebar-7">
                    <?php dynamic_sidebar( 'sidebar-7' ); ?>
                </div>
    		</div>
        </div>
	<?php endif; ?>
    <!-- END Sidebar for social media icons -->

<div id='musicoSiteContentContainer'>

<div id='siteHeader'>
	<div class='row'>
	    <div id="mobileMenu"><i class="fa fa-bars"></i> <a href="#mobileMenu"></a>Menu</div>
		<div class='twelve columns'>			
            <div id="siteBarWrap">
            <div id='siteBar' class='primary-background'>
				<div id='headerLogo'>
					<?php
						$logo = get_theme_mod( 'logo_image' );
						$logoHide = ( empty( $logo ) ) ? 'style="display:none"' : '';
						$headingHide = ( empty( $logo ) ) ? '' : 'style="display:none"';
					?>
						<a href="<?php echo site_url() ?>" title="<?php bloginfo() ?>"><img <?php echo $logoHide ?> src='<?php echo $logo ?>'></a>

						<?php $fontClass = ( get_theme_mod( 'logo_font' ) === 'Calligraffitti' ) ? 'calligraffitti' : '' ?>
						<h1 <?php echo $headingHide ?> class='logo-font <?php echo $fontClass ?>'><a href='<?php echo site_url() ?>'><?php bloginfo() ?></a></h1>
				</div>				
                <div id='headerMenu' class='menu-font'>
					<?php
						wp_nav_menu( array(
							'theme_location' => 'header_menu',
							'items_wrap'     => '<ul id="%1$s" class="%2$s menu-normal">%3$s</ul>',
							'fallback_cb'    => 'bsh_default_menu'
						))
					?>
					<?php /*
						wp_nav_menu( array(
							'theme_location' => 'header_menu',
							'walker'         => new Walker_Nav_Menu_Dropdown,
							'container'      => 'false',
							'items_wrap'     => '<select id="%1$s" style="display:none" class="%2$s menu-select">%3$s</select>',
							'fallback_cb'    => 'bsh_default_dropdown'
						))
					*/?>
				</div>
			</div>
            </div>
            
            <script>
				function init() {
					window.addEventListener('scroll', function(e){
						var distanceY = window.pageYOffset || document.documentElement.scrollTop,
							//shrinkOn = 77,
							shrinkOn = 107,
							header = document.querySelector("#siteBarWrap");
						if (distanceY > shrinkOn) {
							classie.add(header,"stickyMenu");
						} else {
							if (classie.has(header,"stickyMenu")) {
								classie.remove(header,"stickyMenu");
							}
						}
					});
				}
				window.onload = init();
            </script>
			<div id='headerBackground'>
				<?php
					if( get_post_meta( $post->ID, '_mus_header_image', true ) === 'header') {
						$thumbnail_id = get_post_thumbnail_id( $post->ID );
						$image = wp_get_attachment_image_src( $thumbnail_id, 'mus_large' );
						echo "<img src='" . $image[0] . "'>";										
					//code used to tie page featured image to corresponding post category
					} elseif ( in_category( 'sasaki-speaks' )) {
						$featCatImg = wp_get_attachment_url( get_post_thumbnail_id('572') );
						echo "<img src='" . $featCatImg . "'>";
					} elseif ( in_category( 'marketing' )) {
						$featCatImg = wp_get_attachment_url( get_post_thumbnail_id('1532') );
						echo "<img src='" . $featCatImg . "'>";
					} elseif ( in_category( 'purple-room' )) {
						$featCatImg = wp_get_attachment_url( get_post_thumbnail_id('966') );
						echo "<img src='" . $featCatImg . "'>";
					} elseif ( in_category( 'featured-artists' )) {
						$featCatImg = wp_get_attachment_url( get_post_thumbnail_id('831') );
						echo "<img src='" . $featCatImg . "'>";
					} elseif ( in_category( 'blog' )) {
						$featCatImg = wp_get_attachment_url( get_post_thumbnail_id('1829') );
						echo "<img src='" . $featCatImg . "'>";
					} else {
						echo "<img src='" . get_theme_mod('header_image') . "'>";
					}

				?>
                
				<?php
					$calloutLink = get_theme_mod( 'header_callout_link' );
					$calloutJs= ( !empty( $calloutLink ) ) ? 'onclick="window.location=\'' . esc_url( $calloutLink ) . '\'"' : '';
					$linkClass = ( !empty( $calloutLink ) ) ? 'link' : '';
					$calloutText = get_theme_mod( 'header_callout_text' );
				?>
				<?php if( !empty( $calloutText ) ) : ?>
				<div id='headerCallout' class='gradient menu-font <?php echo $linkClass ?>' <?php echo $calloutJs ?>>
					<?php echo $calloutText ?>
				</div>
				<?php endif ?>
			</div>
		</div>
	</div>
</div>

<div class='row'>
	<div class='twelve columns'>
<div id='siteContainer'>