<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file contains the code for the
	WordPress theme customizer.
*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*

	1. The Customizer Class
		1.1  Sections
		1.2  Settings
			1.2.1  General Settings
			1.2.2  Header Settings
			1.2.3  API Settings
		1.3  Controls
			1.2.1  General Controls
			1.2.2  Header Controls
			1.2.3  API Controls
		1.4  CSS Output
			1.2.1  General CSS Output
			1.2.2  Header CSS Output
		1.5 Live Preview Script
		1.6 CSS Helper
		1.7 Set Defaults
		1.8 Font Functions
			1.8.1 Get Font List
			1.8.2 Get Font Data
			1.8.3 Retrieve Font List
			1.8.4 Save Font Data
		1.9 JS Output

	2. Class Setup

	3. Custom Controls
		3.1 Custom Textarea
*/

/***********************************************/
/*          1. The Customizer Class            */
/***********************************************/

class MusicoCustomize {


	public static function register ( $wp_customize ) {

		/*********************************/
		/*         1.1 Sections          */
		/*********************************/

		$wp_customize->add_section( 'general_options' , array(
			'title'      => __( 'General Options', THEMENAME ),
			'priority'   => 10,
		));

		$wp_customize->add_section( 'albumplayer_options' , array(
			'title'      => __( 'Album Player Options', THEMENAME ),
			'priority'   => 14,
		));

		$wp_customize->add_section( 'sidebar_options' , array(
			'title'      => __( 'Sidebar Options', THEMENAME ),
			'priority'   => 15,
		));

		$wp_customize->add_section( 'header_options' , array(
			'title'      => __( 'Header Options', THEMENAME ),
			'priority'   => 20,
		));

		$wp_customize->add_section( 'api_keys' , array(
			'title'      => __( 'API Keys', THEMENAME ),
			'priority'   => 30,
		));

		$wp_customize->add_section( 'error_options' , array(
			'title'      => __( 'Error Display Options', THEMENAME ),
			'priority'   => 40,
		));


		$wp_customize->add_section( 'audioplayer_options' , array(
			'title'      => __( 'Audio Player Options', THEMENAME ),
			'priority'   => 60,
		));


		/*********************************/
		/*         1.2 Settings          */
		/*********************************/

		// 1.2.1 General Settings

		$wp_customize->add_setting( 'body_text_color',
			array(
				'default' => '#666666',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'heading_text_color',
			array(
				'default' => '#444444',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'site_background_color',
			array(
				'default' => '#282828',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'background_image',
			array(
				'default' => get_template_directory_uri() . '/images/defaults/bg.png',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'favicon',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( 'background_tiling',
			array(
				'default' => 'yes',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'content_background',
			array(
				'default' => '#ffffff',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'primary_color',
			array(
				'default' => '#781b0f',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'primary_text_color',
			array(
				'default' => '#ffffff',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'secondary_color',
			array(
				'default' => '#fccc6d',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'secondary_text_color',
			array(
				'default' => '#986638',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( 'body_font',
			array(
				'default' => 'Chivo',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'heading_font',
			array(
				'default' => 'Bitter',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( 'layout',
			array(
				'default' => '2col_right',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'sidebars',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'albumplayer',
			array(
				'default' => 'yes',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( 'albumplayer_custom_link',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'albumplayer_launch_text',
			array(
				'default' => 'launch player',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( 'albumplayer_close_text',
			array(
				'default' => 'close player',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( 'albumplayer_custom_link',
			array(
				'default' => '',
			)
		);

		$wp_customize->add_setting( 'sidebar',
			array(
				'default' => 'Sidebar',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'read_more_text',
			array(
				'default' => 'read more',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'list_content_type',
			array(
				'default' => 'excerpt',
			)
		);


		$wp_customize->add_setting( 'analytics',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);


		// Sidebar Settings
		$wp_customize->add_setting( 'sidebar_background_color',
			array(
				'default' => '#ffffff',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'sidebar_text_color',
			array(
				'default' => '#666666',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'sidebar_heading_color',
			array(
				'default' => '#444444',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'sidebar_link_color',
			array(
				'default' => '#ba143b',
				'transport' => 'postMessage',
			)
		);


		// 1.2.2 Header Settings


		$wp_customize->add_setting( 'header_image',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'logo_image',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'logo_position_left',
			array(
				'default' => '22px',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'logo_position_top',
			array(
				'default' => '0px',
				'transport' => 'postMessage',
			)
		);



		$wp_customize->add_setting( 'logo_font',
			array(
				'default' => 'Calligraffitti',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'logo_font_size',
			array(
				'default' => '36px',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'menu_font',
			array(
				'default' => 'Helvetica Neue',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'header_callout_text',
			array(
				'default' => '<strong>Next Performance</strong><br>Royal Albert Hall<br>London, UK<br>Jan 15, 2013',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'header_callout_link',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		// 1.2.3 API Settings
		$wp_customize->add_setting( 'google_maps_api_key',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'facebook_api_key',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'twitter_consumer_key',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'twitter_consumer_secret',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'twitter_access_token',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'twitter_access_secret',
			array(
				'default' => '',
				'transport' => 'postMessage',
			)
		);


		// Error Options

		$wp_customize->add_setting( '404_title',
			array(
				'default' => 'Oh No, a page is missing!',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( '404_message',
			array(
				'default' => 'It seems that you have stumbled on to some missing content. Try going back to the <a href="' . home_url() . '">main page</a> and give it another go.',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( '404_color',
			array(
				'default' => '#ffffff',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( '404_background',
			array(
				'default' => '#000000',
				'transport' => 'postMessage',
			)
		);


		$wp_customize->add_setting( '404_opacity',
			array(
				'default' => '0.4',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'no_posts_title',
			array(
				'default' => 'There is no content here!',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'no_posts_message',
			array(
				'default' => 'The page you are on exists, but there is no content added to it yet!',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'no_search_title',
			array(
				'default' => 'Your search yielded no results :(',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'no_search_message',
			array(
				'default' => 'Go back to try your search again',
				'transport' => 'postMessage',
			)
		);


		// Audioplayer options

		$wp_customize->add_setting( 'buytext',
			array(
				'default' => 'Buy',
				'transport' => 'postMessage',
			)
		);

		$wp_customize->add_setting( 'audioplayer_background',
			array(
				'default' => '#222222',
				'transport' => 'postMessage',
			)
		);



		/*********************************/
		/*         1.3 Controls          */
		/*********************************/

		// 1.3.1 General Controls

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'body_text_color',
			array(
				'label' => __( 'Body Text Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'body_text_color',
				'priority' => 1,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'heading_text_color',
			array(
				'label' => __( 'Heading Text Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'heading_text_color',
				'priority' => 2,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'site_background_color',
			array(
				'label' => __( 'Background Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'site_background_color',
				'priority' => 3,
			)
		));

		$wp_customize->add_control( new WP_Customize_Image_Control(
			$wp_customize,
			'background_image',
			array(
				'label' => __( 'Background Image', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'background_image',
				'priority' => 4,
			)
		));

		$wp_customize->add_control( new WP_Customize_Image_Control(
			$wp_customize,
			'favicon',
			array(
				'label' => __( 'Favicon', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'favicon',
				'priority' => 4,
			)
		));


		$wp_customize->add_control(
			'background_tiling',
			array(
				'label' => __( 'Tile Background?', THEMENAME ),
				'section' => 'general_options',
				'priority' => 5,
				'settings' => 'background_tiling',
				'type' => 'radio',
				'choices' => array(
					'repeat'    => 'Yes',
					'no-repeat' => 'No',
				),
			)
		);

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'content_background',
			array(
				'label' => __( 'Content Area Background', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'content_background',
				'priority' => 6,
			)
		));


		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'primary_color',
			array(
				'label' => __( 'Primary Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'primary_color',
				'priority' => 10,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'primary_text_color',
			array(
				'label' => __( 'Primary Text Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'primary_text_color',
				'priority' => 20,
			)
		));


		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'secondary_color',
			array(
				'label' => __( 'Secondary Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'secondary_color',
				'priority' => 22,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'secondary_text_color',
			array(
				'label' => __( 'Secondary Text Color', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'secondary_text_color',
				'priority' => 24,
			)
		));


		$wp_customize->add_control(
			'body_font',
			array(
				'label' => __( 'Body Font (needs refresh)', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'body_font',
				'type' => 'select',
				'priority' => 33,
				'choices' => self::get_font_list()
			)
		);

		$wp_customize->add_control(
			'heading_font',
			array(
				'label' => __( 'Heading Font (needs refresh)', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'heading_font',
				'type' => 'select',
				'priority' => 36,
				'choices' => self::get_font_list()
			)
		);



		$wp_customize->add_control(
			'layout',
			array(
				'label' => __( 'Default Layout', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'layout',
				'type' => 'radio',
				'priority' => 40,
				'choices' => array(
					'2col_right' => '2 Columns - Sidebar on the Right',
					'2col_left' => '2 Columns - Sidebar on the Left',
					'1col' => '1 Column - No Sidebar',
				),
			)
		);

		$wp_customize->add_control( new WP_Customize_Textarea_Control(
			$wp_customize,
			'sidebars',
			array(
				'label'	=> __( 'Sidebars', THEMENAME ),
				'priority' => 50,
				'section' => 'general_options',
				'settings' => 'sidebars',
				'description' => 'Add custom sidebars, separated by commas. Once added, please reload this page to be able to select in the default sidebar list below'
			)
		));


		$wp_customize->add_control(
			'read_more_text',
			 array(
			 	'priority' => 60,
				'label' => __( 'Read More Link Text', THEMENAME ),
			 	'section'	=> 'general_options',
			 )
		);

		$wp_customize->add_control(
			'list_content_type',
			array(
				'label' => __( 'Excerpt Or Full Content', THEMENAME ),
				'section' => 'general_options',
				'settings' => 'list_content_type',
				'type' => 'radio',
				'priority' => 70,
				'choices' => array(
					'excerpt' => 'When listing items show the excerpt',
					'content' => 'When listing items show the full content',
				),
			)
		);



		$wp_customize->add_control( new WP_Customize_Textarea_Control(
			$wp_customize,
			'analytics',
			array(
				'label'	=> __( 'Analytics', THEMENAME ),
				'priority' => 80,
				'section' => 'general_options',
				'settings' => 'analytics',
				'description' => 'Add analytics code here. If you use more than one service paste each code block one under the other'
			)
		));


		$choices = explode(',', get_theme_mod( 'sidebars' ) );
		$sidebars['Sidebar'] = 'Sidebar';
		foreach( $choices as $choice ) {
			$choice = trim( $choice );
			if( !empty( $choice ) ) {
				$sidebars[$choice] = $choice;
			}
		}

		$wp_customize->add_control( 'sidebar', array(
			'label' => 'Default Sidebar:',
			'section' => 'general_options',
			'priority' => 50,
			'type' => 'select',
			'choices' => $sidebars
		));


		// Album Player Controls

		$wp_customize->add_control(
			'albumplayer',
			array(
				'label' => __( 'Show Album Player?', THEMENAME ),
				'section' => 'albumplayer_options',
				'priority' => 25,
				'settings' => 'albumplayer',
				'type' => 'radio',
				'choices' => array(
					'yes'    => 'Yes',
					'no' => 'No',
				),
			)
		);

		$wp_customize->add_control(
			'albumplayer_custom_link',
			 array(
			 	'priority' => 25,
				'label' => __( 'Custom Album Player Link', THEMENAME ),
			 	'section'	=> 'albumplayer_options',
			 	'setting'   => 'albumplayer_custom_link'
			 )
		);



		$wp_customize->add_control(
			'albumplayer_launch_text',
			 array(
			 	'priority' => 26,
				'label' => __( 'Launch Button Text', THEMENAME ),
			 	'section'	=> 'albumplayer_options',
			 	'setting'   => 'albumplayer_launch_text'
			 )
		);

		$wp_customize->add_control(
			'albumplayer_close_text',
			 array(
			 	'priority' => 27,
				'label' => __( 'Close Button Text', THEMENAME ),
			 	'section'	=> 'albumplayer_options',
			 	'setting'   => 'albumplayer_close_text'
			 )
		);

		$wp_customize->add_control(
			'albumplayer_custom_link',
			 array(
			 	'priority' => 28,
				'label' => __( 'Album Player Custom Link', THEMENAME ),
			 	'section'	=> 'albumplayer_options',
			 	'setting'   => 'albumplayer_custom_link'
			 )
		);



		// Sidebar Controls

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'sidebar_background_color',
			array(
				'label' => __( 'Sidebar Background Color', THEMENAME ),
				'section' => 'sidebar_options',
				'settings' => 'sidebar_background_color',
				'priority' => 10,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'sidebar_heading_color',
			array(
				'label' => __( 'Sidebar Heading Text Color', THEMENAME ),
				'section' => 'sidebar_options',
				'settings' => 'sidebar_heading_color',
				'priority' => 15,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'sidebar_text_color',
			array(
				'label' => __( 'Sidebar Body Text Color', THEMENAME ),
				'section' => 'sidebar_options',
				'settings' => 'sidebar_text_color',
				'priority' => 20,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'sidebar_link_color',
			array(
				'label' => __( 'Sidebar Link Color', THEMENAME ),
				'section' => 'sidebar_options',
				'settings' => 'sidebar_link_color',
				'priority' => 30,
			)
		));




		// 1.3.2 Header Controls

		$wp_customize->add_control( new WP_Customize_Image_Control(
			$wp_customize,
			'header_image',
			array(
				'label' => __( 'Header Image', THEMENAME ),
				'section' => 'header_options',
				'settings' => 'header_image',
				'priority' => 10,
			)
		));

		$wp_customize->add_control( new WP_Customize_Image_Control(
			$wp_customize,
			'logo_image',
			array(
				'label' => __( 'Logo Image', THEMENAME ),
				'section' => 'header_options',
				'settings' => 'logo_image',
				'priority' => 15,
			)
		));


		$wp_customize->add_control(
			'logo_position_left',
			 array(
				'label' => __( 'Logo Offset Left', THEMENAME ),
			 	'section'	=> 'header_options',
				'priority' => 16,
			 )
		);

		$wp_customize->add_control(
			'logo_position_top',
			 array(
				'label' => __( 'Logo Offset Top', THEMENAME ),
			 	'section'	=> 'header_options',
				'priority' => 17,
			 )
		);


		$wp_customize->add_control(
			'logo_font',
			array(
				'label' => __( 'Logo Font (needs refresh)', THEMENAME ),
				'section' => 'header_options',
				'settings' => 'logo_font',
				'type' => 'select',
				'priority' => 20,
				'choices' => self::get_font_list()
			)
		);


		$wp_customize->add_control(
			'logo_font_size',
			 array(
				'label' => __( 'Logo Font Size', THEMENAME ),
			 	'section'	=> 'header_options',
				'priority' => 25,
			 )
		);

		$wp_customize->add_control(
			'menu_font',
			array(
				'label' => __( 'Menu Font (needs refresh)', THEMENAME ),
				'section' => 'header_options',
				'settings' => 'menu_font',
				'type' => 'select',
				'priority' => 30,
				'choices' => self::get_font_list()
			)
		);


		$wp_customize->add_control( new WP_Customize_Textarea_Control(
			$wp_customize,
			'header_callout_text',
			array(
				'label'	=> __( 'Header Callout Text', THEMENAME ),
				'priority' => 40,
				'section' => 'header_options',
				'settings' => 'header_callout_text'
			)
		));

		$wp_customize->add_control(
			'header_callout_link',
			 array(
			 	'priority' => 50,
				'label' => __( 'Header Callout Link', THEMENAME ),
			 	'section'	=> 'header_options',
			 )
		);


		// 1.3.3 API Controls
		$wp_customize->add_control(
			'google_maps_api_key',
			 array(
				'label' => __( 'Google Maps API Key', THEMENAME ),
			 	'section'	=> 'api_keys',
			 )
		);

		$wp_customize->add_control(
			'facebook_api_key',
			 array(
				'label' => __( 'Facebook API Key', THEMENAME ),
			 	'section'	=> 'api_keys',
			 )
		);

		$wp_customize->add_control(
			'twitter_consumer_key',
			 array(
				'label' => __( 'Twitter Consumer Key', THEMENAME ),
			 	'section'	=> 'api_keys',
			 )
		);

		$wp_customize->add_control(
			'twitter_consumer_secret',
			 array(
				'label' => __( 'Twitter Consumer Secret', THEMENAME ),
			 	'section'	=> 'api_keys',
			 )
		);


		$wp_customize->add_control(
			'twitter_access_token',
			 array(
				'label' => __( 'Twitter Access Token', THEMENAME ),
			 	'section'	=> 'api_keys',
			 )
		);


		$wp_customize->add_control(
			'twitter_access_secret',
			 array(
				'label' => __( 'Twitter Access Secret', THEMENAME ),
			 	'section'	=> 'api_keys',
			 )
		);


		// Error Controls

		$wp_customize->add_control(
			'404_title',
			 array(
				'label' => __( '404 Error Title', THEMENAME ),
			 	'section'	=> 'error_options',
				'priority' => 10,
			 )
		);

		$wp_customize->add_control( new WP_Customize_Textarea_Control(
			$wp_customize,
			'404_message',
			array(
				'label'	=> __( '404 Error Message', THEMENAME ),
				'priority' => 20,
				'section' => 'error_options',
				'settings' => '404_message'
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'404_color',
			array(
				'label' => __( '404 Error Color', THEMENAME ),
				'section' => 'error_options',
				'settings' => '404_color',
				'priority' => 30,
			)
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'404_background',
			array(
				'label' => __( '404 Error Background', THEMENAME ),
				'section' => 'error_options',
				'settings' => '404_background',
				'priority' => 40,
			)
		));

		$wp_customize->add_control(
			'404_opacity',
			 array(
				'label' => __( '404 Error Background Opacity (0-1)', THEMENAME ),
			 	'section'	=> 'error_options',
				'settings' => '404_opacity',
				'priority' => 50,
			 )
		);



		$wp_customize->add_control(
			'no_posts_title',
			 array(
				'label' => __( 'No Content Title', THEMENAME ),
			 	'section'	=> 'error_options',
				'priority' => 60,
				'settings' => 'no_posts_title',
			 )
		);

		$wp_customize->add_control( new WP_Customize_Textarea_Control(
			$wp_customize,
			'no_posts_message',
			array(
				'label'	=> __( 'No Content Message', THEMENAME ),
				'priority' => 70,
				'section' => 'error_options',
				'settings' => 'no_posts_message',
			)
		));



		$wp_customize->add_control(
			'no_search_title',
			 array(
				'label' => __( 'No Search Results Title', THEMENAME ),
			 	'section'	=> 'error_options',
				'priority' => 80,
				'settings' => 'no_search_title',
			 )
		);

		$wp_customize->add_control( new WP_Customize_Textarea_Control(
			$wp_customize,
			'no_search_message',
			array(
				'label'	=> __( 'No Search Results Message', THEMENAME ),
				'priority' => 90,
				'section' => 'error_options',
				'settings' => 'no_search_message',
			)
		));



	   // Audioplayer Controls

		$wp_customize->add_control( 'buytext', array(
			'label' => __( 'Buy Link Text', THEMENAME ),
			'section'	=> 'audioplayer_options',
			'type'	 => 'text',
			'priority' => 20,
		));

		$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize,
			'audioplayer_background',
			array(
				'label' => __( 'Audio Player Background', THEMENAME ),
				'section' => 'audioplayer_options',
				'settings' => 'audioplayer_background',
				'priority' => 20,
			)
		));

   }


	/*********************************/
	/*        1.4 CSS Output         */
	/*********************************/
	public static function header_css_output() {
		?>
			<style type="text/css">

				<?php // 1.4.1 General CSS Output ?>


				<?php
					// Body Text Color
					self::generate_css_color(
						'html, body, p, a, .body-text-color, table tbody tr td, .content a.body-text-color',
						'color',
						'body_text_color'
					);
					self::generate_css_color(
						'.body-text-lighter, .widget_rss h1 a',
						'color',
						'body_text_color',
						+20
					);

					// Heading Text Color
					self::generate_css_color(
						'h1,h2,h3,h4,h5,h6, .heading-text-color, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, .widget_rss li > a, h1.widget-title a, .content h1.layout-title a',
						'color',
						'heading_text_color'
					);

					// Primary Colors
					self::generate_css_color(
						'.primary, .primary-links a, a:hover, .content a, .widget_calendar a, .content a.body-text-color:hover',
						'color',
						'primary_color'
					);
					self::generate_css_color(
						'.primary-background, #launchPlayer, #launchPlayerLink, .button, .button.primary',
						'background-color',
						'primary_color'
					);
					self::generate_css_color(
						'.button, .button.primary',
						'text-shadow',
						'primary_color',
						-6,
						1,
						'-1px -1px 0 '
					);
					self::generate_css_color(
						'#siteBar',
						'background-color',
						'primary_color',
						0,
						0.9
					);
					self::generate_css_color(
						'#headerMenu li:hover > a, #headerMenu > div > ul ul',
						'background-color',
						'primary_color',
						3,
						0.9
					);
					self::generate_css_color(
						'#headerMenu li.current_page_item > a, #headerMenu  li.current_page_parent > a, #headerMenu  li.current_page_ancestor > a, #headerMenu  li.current-menu-item > a, #headerMenu  li.current-menu-ancestor > a, #headerMenu  li.current-menu-parent > a, #headerMenu > div > ul li.current_page_item ul, #headerMenu > div > ul li.current-menu-item ul, #headerMenu > div > ul li.current-menu-parent ul, #headerMenu > div > ul li.current-menu-ancestor ul, #headerMenu > div > ul li.current_page_item ul, #headerMenu > div > ul li.current_page_parent ul, #headerMenu > div > ul li.current_page_ancestor ul',
						'background-color',
						'primary_color',
						+10,
						0.9
					);
					self::generate_css_color(
						'#headerMenu > div > ul ul li.current_page_item > a, #headerMenu > div > ul ul   li.current_page_parent > a, #headerMenu > div > ul ul   li.current_page_ancestor > a, #headerMenu > div > ul ul   li.current-menu-item > a, #headerMenu > div > ul ul   li.current-menu-ancestor > a, #headerMenu > div > ul ul li.current-menu-parent > a, .layout-event .metas .meta.time, .layout-event-item .metas .meta.time, span.wpcf7-not-valid-tip, .wpcf7-response-output, #siteFooter, .pagination .page-numbers.current, .bonsaiPlayer .player .playlist li.current, .bonsaiPlayer .player .play-bar, .bonsaiPlayer .player .volume, .single-pagination span.current',
						'background-color',
						'primary_color',
						0
					);
					self::generate_css_color(
						'#headerCallout, .tabs dd.active, .tabs li.active, ul.accordion > li.active ',
						'border-color',
						'primary_color'
					);
					self::generate_css_color(
						'.button, .button.primary, span.wpcf7-not-valid-tip, div.wpcf7-response-output',
						'border-color',
						'primary_color',
						-12
					);

					self::generate_css_color(
						'#headerMenu .customSelect, #footerMenu .customSelect',
						'background-color',
						'primary_color',
						-12
					);





					// Primary Text Color
					self::generate_css_color(
						'.primary-background, .primary-background a, .primary-background h1, .primary-background h2, .primary-background h3, .primary-background h4, .primary-background h5, .primary-background h6, .layout-event .metas .meta.time, .layout-event-item .metas .meta.time, .button, .button.primary, span.wpcf7-not-valid-tip, .wpcf7-response-output, #siteFooter, #siteFooter a, #siteFooter h1, .pagination .page-numbers.current, #launchPlayer, #launchPlayerLink, .single-pagination span.current',
						'color',
						'primary_text_color'
					);

					// Secondary Color

					self::generate_css_color(
						'.secondary, .secondary-links a',
						'color',
						'secondary_color'
					);
					self::generate_css_color(
						'.secondary-background',
						'background-color',
						'secondary_color'
					);
					self::generate_css_gradient(
						'.button.secondary',
						'background-color',
						'secondary_color'
					);
					self::generate_css_color(
						'.button.secondary',
						'border-color',
						'secondary_color',
						-12
					);
					self::generate_css_color(
						'.button.secondary',
						'text-shadow',
						'secondary_color',
						+10,
						1,
						'1px 1px 0 '
					);

					// Secondary Text Color
					self::generate_css_color(
						'.secondary-background, .secondary-background a, .secondary-background h1, .secondary-background h2, .secondary-background h3, .secondary-background h4, .secondary-background h5, .secondary-background h6, .button.secondary',
						'color',
						'secondary_text_color'
					);

					// 404 Color
					self::generate_css_color(
						'#error-404 h1, #error-404 h2, #error-404 h3, #error-404 h4, #error-404 h5, #error-404 h6, #error-404, #error-404 p, #error-404 a',
						'color',
						'404_color'
					);

					self::generate_css_color(
						'#error-404',
						'background-color',
						'404_background',
						0,
						get_theme_mod( '404_opacity' )
					);


					// Body Font
					self::generate_css(
						'p, body, html, .body-font',
						'font-family',
						'body_font'
					);

					// Heading Font
					self::generate_css(
						'h1,h2,h3,h4,h5,h6,.heading-font, .widget_rss li > a, h1.widget-title a',
						'font-family',
						'heading_font'
					);

					// Logo Font
					self::generate_css(
						'.logo-font, .logo-font h1, .logo-font h2, .logo-font h3, .logo-font h4, .logo-font h5, .logo-font h6',
						'font-family',
						'logo_font',
						''
					);

					// Logo Font Size
					self::generate_css(
						'#headerLogo h1',
						'font-size',
						'logo_font_size'
					);


					// Logo Position Left
					self::generate_css(
						'#headerLogo img',
						'left',
						'logo_position_left',
						''
					);

					// Logo Position Right
					self::generate_css(
						'#headerLogo img',
						'top',
						'logo_position_top',
						''
					);


					// Menu Font
					self::generate_css(
						'.menu-font, .menu-font h1, .menu-font h2, .menu-font h3, .menu-font h4, .menu-font h5, .menu-font h6',
						'font-family',
						'menu_font'
					);

					// Background Color
					self::generate_css(
						'html',
						'background-color',
						'site_background_color'
					);

					// Background Image

					self::generate_css(
						'html',
						'background-image',
						'background_image',
						'url(',
						')'
					);

					self::generate_css(
						'html',
						'background-repeat',
						'background_tiling'
					);

					// Content Area Background
					self::generate_css(
						'#siteContainer, .line a',
						'background-color',
						'content_background'
					);

					self::generate_css_color(
						'#siteContainer .panel',
						'background-color',
						'content_background',
						-5
					);

					self::generate_css_color(
						'#siteContainer, .widget ul li, .single-pagination, .widget ul ul li:first-child',
						'border-color',
						'content_background',
						-12
					);
					self::generate_css_color(
						'.layout-event .metas .meta, .layout-event-item .metas .meta, .pagination .page-numbers, .single-pagination a:hover',
						'background-color',
						'content_background',
						-5
					);
					self::generate_css_color(
						'.commentlist .bypostauthor > article,
						input[type="text"], input[type="password"], input[type="date"], input[type="datetime"], input[type="email"], input[type="number"], input[type="search"], input[type="tel"], input[type="time"], input[type="url"], textarea, .customSelect, .sticky
						',
						'background-color',
						'content_background',
						-3
					);
					self::generate_css_color(
						'.layout-event .map-canvas',
						'border-color',
						'content_background',
						-5
					);
					self::generate_css_color(
						'img, a img, .list-item',
						'border-color',
						'content_background',
						-10
					);

					// audioplayer background

					self::generate_css_color(
						'.ttw-music-player',
						'background-color',
						'audioplayer_background'
					);

					// Sidebar Background
					self::generate_css_color(
						'#siteSidebar',
						'background-color',
						'sidebar_background_color'
					);


					// Sidebar Text Color
					self::generate_css_color(
						'#siteSidebar, #siteSidebar abbr, #siteSidebar acronym',
						'color',
						'sidebar_text_color'
					);

					// Sidebar Heading Color
					self::generate_css_color(
						'#siteSidebar h1,#siteSidebar h2,#siteSidebar h3,#siteSidebar h4,#siteSidebar h5,#siteSidebar h6',
						'color',
						'sidebar_heading_color'
					);

					// Sidebar Link Color
					self::generate_css_color(
						'#siteSidebar a',
						'color',
						'sidebar_link_color'
					);



				?>


			</style>

		<?php
	}

	/*********************************/
	/*    1.5 Live Preview Script    */
	/*********************************/
	public static function live_preview() {
		wp_enqueue_script(
			'customizer',
			get_template_directory_uri().'/framework/customizer/customizer.js',
			array( 'jquery','customize-preview' ),
			time(),
			true
		);

		wp_localize_script( 'customizer', 'mus', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );

	}

	/*********************************/
	/*        1.6 CSS Helper         */
	/*********************************/
	public static function generate_css( $selector, $style, $mod_name, $prefix='', $postfix='', $echo=true) {

		$return = '';
		$mod = get_theme_mod($mod_name);
		if ( ! empty( $mod ) ) {
			$return = sprintf('%s { %s:%s; }',
				$selector,
				$style,
				$prefix.$mod.$postfix
			);
			if ( $echo ) {
				echo $return;
			}
		}

		return $return;
	}

	public static function generate_css_color( $selector, $style, $mod_name, $color_offset = 0, $opacity = 1, $before = '', $after = '' ) {
		$mod = get_theme_mod($mod_name);

		if ( ! empty( $mod ) ) {
			$value = $mod;
			if( substr( $value, 0, 1 ) != '#' ) {
				$value = '#' . $value;
			}

			$color = new Color( $value );

			if( $color_offset > 0 ) {
				$value = '#' . $color->lighten( abs( $color_offset ) );
			}
			elseif( $color_offset < 0 ) {
				$value = '#' . $color->darken( abs( $color_offset ) );
			}

			if( abs( $opacity ) < 1 ) {
				$rgb = new Color( $value );
				$rgb = $rgb->getRgb();
				$value = 'rgba( ' . $rgb['R'] . ', ' . $rgb['G'] . ', ' . $rgb['B'] . ', ' . $opacity . ' )';
			}

			echo $selector . '{ ' . $style . ': ' . $before . ' ' . $value . ' ' . $after . ' }';
		}
	}

	public static function generate_css_gradient( $selector, $style, $mod_name ) {
		$mod = get_theme_mod($mod_name);
		if ( ! empty( $mod ) ) {
			$color = new Color( $mod );
			$gradient = $color->makeGradient();
			echo $selector . "{
				background: #" . $gradient['light'] . ";
				background: -moz-linear-gradient(top,  #" . $gradient['light'] . " 0%, #" . $gradient['dark'] . " 100%);
				background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#" . $gradient['light'] . "), color-stop(100%,#" . $gradient['dark'] . "));
				background: -webkit-linear-gradient(top,  #" . $gradient['light'] . " 0%,#" . $gradient['dark'] . " 100%);
				background: -o-linear-gradient(top,  #" . $gradient['light'] . " 0%,#" . $gradient['dark'] . " 100%);
				background: -ms-linear-gradient(top,  #" . $gradient['light'] . " 0%,#" . $gradient['dark'] . " 100%);
				background: linear-gradient(to bottom,  #" . $gradient['light'] . " 0%,#" . $gradient['dark'] . " 100%);
				filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#" . $gradient['light'] . "', endColorstr='#" . $gradient['dark'] . "',GradientType=0 );
			}";
		}
	}

	/*********************************/
	/*       1.7 Set Defaults        */
	/*********************************/
	public static function set_defaults() {

		$primary = get_theme_mod( 'primary_color' );
		if( empty( $primary ) ) {
			// General Settings
			set_theme_mod( 'primary_color', '#BA143B' );
			set_theme_mod( 'primary_text_color', '#ffffff' );
			set_theme_mod( 'secondary_color', '#fccc6d' );
			set_theme_mod( 'secondary_text_color', '#986638' );
			set_theme_mod( 'heading_font', 'Bitter' );
			set_theme_mod( 'body_font', 'Chivo' );
			set_theme_mod( 'body_text_color', '#666666' );
			set_theme_mod( 'heading_text_color', '#444444' );
			set_theme_mod( 'site_background_color', '#282828' );
			set_theme_mod( 'read_more_text', 'read more' );
			set_theme_mod( 'content_background', '#ffffff' );
			set_theme_mod( 'list_content_type', 'excerpt' );
			// Album Player Settings
			set_theme_mod( 'albumplayer', 'yes' );
			set_theme_mod( 'albumplayer_launch_text', 'launch player' );
			set_theme_mod( 'albumplayer_close_text', 'close player' );
			// Sidebar Settings
			set_theme_mod( 'sidebar_background_color', '#ffffff' );
			set_theme_mod( 'sidebar_heading_color', '#444444' );
			set_theme_mod( 'sidebar_text_color', '#666666' );
			set_theme_mod( 'sidebar_link_color', '#ba143b' );
			// Header Settings
			set_theme_mod( 'header_image', get_template_directory_uri() . '/images/defaults/header_background.jpg' );
			set_theme_mod( 'logo_position_left', '22px' );
			set_theme_mod( 'logo_position_right', '0px' );
			set_theme_mod( 'logo_font', 'Calligraffitti' );
			set_theme_mod( 'logo_font_size', '36px' );
			set_theme_mod( 'menu_font', 'Helvetica Neue' );
			set_theme_mod( 'header_callout_text', '<strong>Next Performance</strong><br>Royal Albert Hall<br>London, UK<br>Jan 15, 2013' );
			set_theme_mod( 'header_callout_link', '' );

			// Error Options
			set_theme_mod( '404_title', 'Oh No, a page is missing' );
			set_theme_mod( '404_message', 'It seems that you have stumbled on to some missing content. Try going back to the <a href="' . home_url() . '">main page</a> and give it another go.' );
			set_theme_mod( '404_color', '#ffffff' );
			set_theme_mod( '404_background', '#000000' );
			set_theme_mod( '404_opacity', '0.4' );
			set_theme_mod( 'no_posts_title', 'There is no content here!' );
			set_theme_mod( 'no_posts_message', 'The page you are on exists, but there is no content added to it yet.' );
			set_theme_mod( 'no_search_title', 'Your search yielded no results :(' );
			set_theme_mod( 'no_search_message', 'Go back to try another search' );

			// Audioplayer Options
			set_theme_mod( 'buytext', 'Buy' );

		}

	}


	/*********************************/
	/*      1.8 Font Functions       */
	/*********************************/


	// Fonts

	// 1.8.1 Get Font List
	function get_font_list( $builtin = true ) {
		$font_data = self::get_font_data();
		$font_list = array();

		if( $builtin == true ) {
			$font_list = array(
				'Helvetica Neue'    => 'Helvetica Neue',
				'Helvetica'         => 'Helvetica',
				'Arial'             => 'Arial',
				'Times New Roman'   => 'Times New Roman',
				'Verdana'           => 'Verdana',
				'Georgia'           => 'Georgia',
			);
		}
		if( count( $font_list ) < 7 ) {
			$additional_fonts = unserialize( include( 'font_list.php' ) );
			$font_list = $additional_fonts ;
		}
		else {
			foreach( $font_data['font_list'] as $font ) {
				$font_list[$font['name']] = $font['name'];
			}
		}


		return $font_list;
	}

	// 1.8.2 Get Font Data
	function get_font_data() {
		$font_data = get_option( 'mus_font_data' );
		if( ( !empty( $font_data['time'] ) AND ( ( $font_data['time'] + ( 60 * 60 * 24 * 3 ) ) < time() ) ) OR empty( $font_data ) OR empty( $font_data['font_list'] ) ) {
			$font_data = self::save_font_data();
		}
		return $font_data;
	}

	// 1.8.3 Retrieve Font List
	function retrieve_font_list() {
		$request = 'https://www.googleapis.com/webfonts/v1/webfonts?key=AIzaSyBMuUz8oeTCH94o0SsI_swMxV6nzffSVco';
		if( !function_exists( 'curl_init' ) ) {
			$fonts = json_decode( @file_get_contents( $request ) );
		}
		else {
		    $curl = curl_init();
		    curl_setopt( $curl, CURLOPT_URL, $request );
		    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
		    $fonts = curl_exec( $curl );
		    curl_close( $curl );
		    $fonts = json_decode( $fonts );
		}

		$font_list = array();

		if( !empty( $fonts ) ) {
			foreach( $fonts->items as $font ) {
				$font_list[$font->family] = array(
					'name'   => $font->family,
				);

				$request = str_replace( ' ', '+', $font->family );
				if( array_search( '700', $font->variants ) ) {
					$request .= ':400,700';
				}
				$font_list[$font->family]['request'] = $request;
			}
		}

		return $font_list;

	}

	// 1.8.4 Save Font Data
	function save_font_data() {
		$font_list = self::retrieve_font_list();

		$font_data = array(
			'time'      => time(),
			'font_list' => $font_list
		);

		update_option( 'mus_font_data', $font_data );

		return $font_data;

	}

	/*********************************/
	/*         1.9 JS Output         */
	/*********************************/
	public static function header_js_output() {
		$fonts['body']    = get_theme_mod( 'body_font' );
		$fonts['heading'] = get_theme_mod( 'heading_font' );
		$fonts['logo_font'] = get_theme_mod( 'logo_font' );
		$fonts['menu_font'] = get_theme_mod( 'menu_font' );

		$font_list = self::get_font_list( false );
		$font_data = self::get_font_data();
		$request = array();

		$builtin = array(
			'Helvetica Neue'    => 'Helvetica Neue',
			'Helvetica'         => 'Helvetica',
			'Arial'             => 'Arial',
			'Times New Roman'   => 'Times New Roman',
			'Verdana'           => 'Verdana',
			'Georgia'           => 'Georgia',
		);

		foreach( $fonts as $font ) {
			if( !in_array( $font, $builtin ) ) {
				$font_name = str_replace( '+', ' ', $font );
				if( in_array( $font_name, array_values( $font_list ) ) ){
					$request[] = "'" . $font . "'";
				}
			}
		}

		$request = implode( ', ', $request );

		?>

		<script type="text/javascript">
		  WebFontConfig = {
		    google: { families: [ <?php echo $request ?> ] }
		  };
		  (function() {
		    var wf = document.createElement('script');
		    wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
		      '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
		    wf.type = 'text/javascript';
		    wf.async = 'true';
		    var s = document.getElementsByTagName('script')[0];
		    s.parentNode.insertBefore(wf, s);
		  })();
		</script>


		<?php
	}

}

/***********************************************/
/*               2. Class Setup                */
/***********************************************/

add_action( 'init' , array( 'MusicoCustomize' , 'set_defaults' ) );
add_action( 'customize_register' , array( 'MusicoCustomize' , 'register' ) );
add_action( 'wp_head' , array( 'MusicoCustomize' , 'header_css_output' ) );
add_action( 'wp_head' , array( 'MusicoCustomize' , 'header_js_output' ) );
add_action( 'customize_preview_init' , array( 'MusicoCustomize' , 'live_preview' ) );


/***********************************************/
/*             3. Custom Controls              */
/***********************************************/

// 3.1 Custom Textarea

if( class_exists( 'WP_Customize_Control' ) ):
	class WP_Customize_Textarea_Control extends WP_Customize_Control {
		public $type = 'textarea';
		public $args = '';

		public function __construct( $manager, $id, $args ) {
			$this->args = $args;
        	parent::__construct( $manager, $id, $args );
		}

		public function render_content() {
			?>
		<label>
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<textarea rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
			<?php if( !empty( $this->args['description'] ) ) : ?>
			<p class='description'><?php echo esc_html( $this->args['description'] ) ?></p>
			<?php endif ?>
		</label>
		<?php
		}
	}
endif;


/***********************************************/
/*           4. Preview AJAX Actions           */
/***********************************************/

add_action( 'wp_ajax_customizer_get_sidebar', 'customizer_get_sidebar' );
function customizer_get_sidebar() {
	$sidebar = ( $_POST['sidebar'] == 'mus_default' ) ? get_theme_mod( 'sidebar' ) : $_POST['sidebar'];

	dynamic_sidebar( $sidebar );
	die();

}

?>