<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file generates the options needed for
	the album posts.
*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*

	1. Default Page Options Class
		1.1 Constructor
		1.2 Options Box Content

	2. Instantiating The Options

*/

/***********************************************/
/*       1. Default Page Options Class         */
/***********************************************/

class bshAlbumOptions extends bshOptions {

	// 1.1 Constructor
	function __construct() {
		$args = array(
			'title'     => __( 'Album Options', THEMENAME ),
			'post_type' => 'album',
			'template'  => 'album',
			'context'   => 'normal',
			'priority'  => 'high'
		);
        parent::__construct( $args );
        $this->setup_options();
	}

	// 1.2 Options Box Content
    public function options_box_content( $post ) {
        ?>
        	<div id='bshLogo'></div>
        	<div id='optionsContainer'>
        		<div id='menuBackground'></div>
	        	<ul id='bshMenu'>
	        		<li class='active'><?php _e( 'Help', THEMENAME) ?></l1>
	        		<li><?php _e( 'Shortcode Guide', THEMENAME) ?></l1>
	        		<li><?php _e( 'Get Support', THEMENAME) ?></l1>
	        	</ul>
	        	<div id='bshOptions'>
		        	<input id='bshSaveTop' name="save" type="submit" class="button button-primary button-large" id="publish" accesskey="p" value="Update">


	        		<section class='helpSection active'>
	        			<?php
	        			_e('
							<p>Musico allows you to create albums to showcase your music to viewers. Your albums show up in album lists, on single album pages and the full screen music player. Let\'s take a look at how to add and manage albums.</p>
							<p><iframe src="http://player.vimeo.com/video/60758067?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff" height="356" width="475" allowfullscreen="" frameborder="0"></iframe></p>
							<h2>Where are albums shown</h2>
							<p>Albums can be seen in three places.</p>
							<ul>
							<li><span style="line-height: 12.997159004211426px;">Album Lists</span></li>
							<li>Album Pages</li>
							<li>The Album Player</li>
							</ul>
							<p>Album lists can be seen by going to yourdomain.com/album/ They can also be created on arbitrary pages by using the <a title="The List Page Template" href="http://bonsaished.com/blog/kb/the-list-page-template/">List Page Template</a>.</p>
							<p>When clicking on the album in the list you will be taken to the album\'s dedicated page. Here you\'ll see more information about the album, and the audio player.</p>
							<p>The <a title="The Album Player" href="http://bonsaished.com/blog/kb/the-album-player/">Album Player</a> can be accessed (if enabled and you have added albums) by clicking on the link on top of every page. This will show all your albums and allow users to listen to them.</p>
							<h2>Creating an Album</h2>
							<p>To create an album you will need to click on the "Add New" link in the albums section in the WordPress backend. Fill out the title and the description. Remember that you can use any <a href="http://bonsaished.com/blog/topics/musico/shortcodes/">Shortcodes</a> in the content to make it look great.</p>
							<p>To attach the album art you will need to upload it in the Add Media section. Choose your album art and make it the featured image for the post. If you\'re not sure how to do this, refer to our article on <a href="http://bonsaished.com/blog/kb/uploading-and-using-media/">Uploading and Using Media</a>.</p>
							<p>If you would like users to be able to listen to your album you will need to upload the mp3 files for the songs. You can do this in the same was as you upload media. Once you have uploaded your music files you will need to edit their details. This is easily done in the Add Media window.</p>
							<p>You can fill out the track length, buy link url, artist and track number. The buy link will be shown next to the song on the album\'s page.</p>

	        			', THEMENAME );
	        			?>
	        		</section>

	        		<section class='helpSection'>
	        			<?php echo bsh_docs_shortcodes() ?>
		        	</section>
		        	<section class='helpSection'>
			        	<?php echo bsh_docs_get_support() ?>
			   		</section>

	        	</div>
	        	<div class='clear'></div>
	        </div>

        <?php
    }


}


/***********************************************/
/*       2. Instantiating The Options          */
/***********************************************/

if ( is_admin() ) {
    add_action( 'load-post.php', 'call_bshAlbumOptions' );
    add_action( 'load-post-new.php', 'call_bshAlbumOptions' );
}
function call_bshAlbumOptions() {
	global $bshPostOptions;
	if( $bshPostOptions->get_page_template() == 'album' ) {
    	return new bshAlbumOptions();
    }
}




?>