<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file generates the options needed for
	the blog page template.
*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*

	1. Default Page Options Class
		1.1 Constructor
		1.2 Options Box Content

	2. Instantiating The Options

*/

/***********************************************/
/*       1. Default Page Options Class         */
/***********************************************/

class bshEventOptions extends bshOptions {

	// 1.1 Constructor
	function __construct() {
		$args = array(
			'title'     => __( 'Event Options', THEMENAME ),
			'post_type' => 'event',
			'template'  => 'event',
			'context'   => 'normal',
			'priority'  => 'high'
		);
        parent::__construct( $args );
        $this->setup_options();
	}

	// 1.2 Options Box Content
    public function options_box_content( $post ) {
        ?>
        	<div id='bshLogo'></div>
        	<div id='optionsContainer'>
        		<div id='menuBackground'></div>
	        	<ul id='bshMenu'>
	        		<li class='active'><?php _e( 'Event Structure', THEMENAME ) ?></li>
	        		<li><?php _e( 'Event Details', THEMENAME ) ?></li>
	        		<li><?php _e( 'Event Participants', THEMENAME ) ?></li>
	        		<li><?php _e( 'Help', THEMENAME) ?></l1>
	        		<li><?php _e( 'Shortcode Guide', THEMENAME) ?></l1>
	        		<li><?php _e( 'Get Support', THEMENAME) ?></l1>
	        	</ul>
	        	<div id='bshOptions'>
		        	<input id='bshSaveTop' name="save" type="submit" class="button button-primary button-large" id="publish" accesskey="p" value="Update">

	        		<section class='active'>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php echo  __( 'The featured image can be placed into two different locations in an event. You can place it above the content where it will span all the way to the edges of the site. You can also place it inside the content where it will be below the map, as wide as the left side of the event details', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_thumbnail_position' class='sectionTitle'><?php _e( 'Featured Image Position', THEMENAME ) ?></label>
	        				<?php
	        					$choices = array(
	        						'Above the event, full width' => 'outside',
	        						'In the event contents' => 'inside',
	        					)
	        				?>
	        				<ul class='choices'>
		        				<?php
		        					$current = get_post_meta( $post->ID,  '_mus_thumbnail_position', true );

		        					$i=1; foreach( $choices as $choice => $value ) :
		        					$checked = ( $current == $value OR ( empty( $current ) AND $value == 'outside' ) ) ? 'checked="checked"' : '';
		        				?>
		        				<li>
		        				<input <?php echo $checked ?> type='radio' id='_mus_thumbnail_position-<?php echo $i ?>' name='_mus_thumbnail_position' value='<?php echo $value ?>'><label for='_mus_thumbnail_position-<?php echo $i ?>'><?php echo $choice ?></label><br>
		        				</li>
		        				<?php $i++; endforeach ?>
	        				</ul>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php echo  __( 'If the address is given, by default a wide map will be shown above the event details. You have the option to switch it off here.', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_show_map' class='sectionTitle'><?php _e( 'Show Map', THEMENAME ) ?></label>
	        				<?php
	        					$choices = array(
	        						'Yes' => 'yes',
	        						'No' => 'no',
	        					)
	        				?>
	        				<ul class='choices'>
		        				<?php
		        					$current = get_post_meta( $post->ID,  '_mus_show_map', true );

		        					$i=1; foreach( $choices as $choice => $value ) :
		        					$checked = ( $current == $value OR ( empty( $current ) AND $value == 'yes' ) ) ? 'checked="checked"' : '';
		        				?>
		        				<li>
		        				<input <?php echo $checked ?> type='radio' id='_mus_show_map-<?php echo $i ?>' name='_mus_show_map' value='<?php echo $value ?>'><label for='_mus_show_map-<?php echo $i ?>'><?php echo $choice ?></label><br>
		        				</li>
		        				<?php $i++; endforeach ?>
	        				</ul>
	        			</div>

	        		</section>


	        		<section>
	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php echo sprintf( __( 'You can specify the date and the time of your event here. For consistency\'s sake, make sure that the timezone of your website is the same as the time zone your are giving your event dates. Go to the <a href="%s">General Settings</a> in WordPress to modify the timezone', THEMENAME ), esc_url( admin_url( 'options-general.php' ) ) ) ?>
        						</div>
        					</div>

        					<?php
        						$value = get_post_meta( $post->ID, '_mus_time', true );
        						$date = ( !empty( $value ) ) ? date( 'd F, Y H:i ', strtotime( $value ) ) : $value;
        					?>
	        				<label for='_mus_time_picker' class='sectionTitle'><?php _e( 'Date &amp; Time', THEMENAME ) ?></label>
		        				<input type='text' class='widefat datetimepicker' id='_mus_time_picker' value='<?php echo $date ?>' placeholder='Click here for a date selector' data-id='_mus_time'>
		        				<input class='hidden' type='text' id='_mus_time' name='_mus_time' value='<?php echo $value ?>'>

	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'If you don\'t know the date for this event yet, use this field to customize the placeholder message. It will be shown on the event where the date usually is. Once a date is filled in, the actual date will be used', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='bsh_sidebar' class='sectionTitle'><?php _e( 'Date Placeholder', THEMENAME ) ?></label>

        					<?php
        						$value = get_post_meta( $post->ID, '_mus_date_placeholder', true );
        						$value = ( empty( $value ) ) ? 'Date not set yet' : $value;
        					?>
		        			<input class='widefat' type='text' id='_mus_date_placeholder' name='_mus_date_placeholder' value='<?php echo $value ?>'>
	        			</div>


	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Type the city and the country you will be playing at. This will be displayed next to each event, usually as the most prominent information. If you are in the US you can type the state instead of the country.', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='bsh_sidebar' class='sectionTitle'><?php _e( 'City &amp; Country', THEMENAME ) ?></label>

        					<?php $value = get_post_meta( $post->ID, '_mus_location', true ) ?>
		        			<input class='widefat' type='text' id='_mus_location' name='_mus_location' value='<?php echo $value ?>'>
	        			</div>


	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Type the name of the venue you will be playing at', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php $value = get_post_meta( $post->ID, '_mus_venue', true ) ?>
	        				<label for='_mus_venue' class='sectionTitle'><?php _e( 'Venue', THEMENAME ) ?></label>
		        			<input class='widefat' type='text' id='_mus_venue' name='_mus_venue' value='<?php echo $value ?>'>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Type the complete address of the venue. If given, this information will be used to display a Google Map of the location', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php $value = get_post_meta( $post->ID, '_mus_address', true ) ?>
	        				<label for='_mus_address' class='sectionTitle'><?php _e( 'Venue Address', THEMENAME ) ?></label>
		        			<input class='widefat'  type='text' id='_mus_address' name='_mus_address' value='<?php echo $value ?>'>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'If the venue has a website where tickets can be purchased, enter the URL here. A button will be generated which will direct the user to the ticket store', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php $value = get_post_meta( $post->ID, '_mus_ticket_url', true ) ?>
	        				<label for='_mus_ticket_url' class='sectionTitle'><?php _e( 'Buy Tickets URL', THEMENAME ) ?></label>
		        			<input class='widefat' type='text' id='_mus_ticket_url' name='_mus_ticket_url' value='<?php echo $value ?>'>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Change the default "Buy Tickets" button text to anything you would like', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php
        						$value = get_post_meta( $post->ID, '_mus_ticket_text', true );
        						$value = ( empty( $value ) ) ? 'Buy Tickets' : $value;
        					?>
	        				<label for='_mus_ticket_text' class='sectionTitle'><?php _e( 'Buy Tickets Button Text', THEMENAME ) ?></label>
		        			<input class='widefat' type='text' id='_mus_ticket_text' name='_mus_ticket_text' value='<?php echo $value ?>'>
	        			</div>


	        		</section>

	        		<section>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Details filled out on this page are shown under a heading which says "On Stage". If you would like to change this text you can do so here. ', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php $value = get_post_meta( $post->ID, '_mus_onstage_title', true ) ?>
	        				<label for='_mus_onstage_title' class='sectionTitle'><?php _e( 'On Stage Title', THEMENAME ) ?></label>
		        				<input class='widefat'  type='text' id='_mus_onstage_title' name='_mus_onstage_title' value='<?php echo $value ?>'>

	        			</div>


	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'If you are playing with an orchestra, add their name here. It will be displayed in the event\'s page.', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php $value = get_post_meta( $post->ID, '_mus_orchestra', true ) ?>
	        				<label for='_mus_orchestra' class='sectionTitle'><?php _e( 'Orchestra', THEMENAME ) ?></label>
		        				<input class='widefat'  type='text' id='_mus_orchestra' name='_mus_orchestra' value='<?php echo $value ?>'>

	        			</div>


	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'If a conductor is present on stage, enter his or her name here. It will be displayed in the event\'s page', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php $value = get_post_meta( $post->ID, '_mus_conductor', true ) ?>
	        				<label for='_mus_conductor' class='sectionTitle'><?php _e( 'Conductor', THEMENAME ) ?></label>
		        				<input class='widefat'  type='text' id='_mus_conductor' name='_mus_conductor' value='<?php echo $value ?>'>

	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'If you would like to name some of the people on stage specifically, enter their name and instrument here. You can add more people by clicking on the "add someone else" button. Each person and their instruments will be listed in the event page', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php
        						$value = get_post_meta( $post->ID, '_mus_people', true );
        						$value = ( empty( $value ) ) ? array( 0 => array( 'name' => '', 'instrument' => '' ) ) : $value;
        					?>

	        				<label class='sectionTitle'><?php _e( 'Specific People', THEMENAME ) ?></label>

       						<div class='event-people'>

        					<?php
        						$i=1; foreach( $value as $person ) :
        					?>
        						<div class='event-person'>
	        						<label for='_mus_people_name_<?php echo $i ?>'><?php _e( 'Name', THEMENAME ) ?></label>
	        						<input id='_mus_people_name_<?php echo $i ?>' type='text' name='_mus_people[<?php echo $i ?>][name]' value='<?php echo $person['name'] ?>'>
	        						<br>
	        						<label for='_mus_people_instrument_<?php echo $i ?>'><?php _e( 'Instrument', THEMENAME ) ?></label>
	        						<input id='_mus_people_instrument_<?php echo $i ?>' type='text' name='_mus_people[<?php echo $i ?>][instrument]' value='<?php echo $person['instrument'] ?>'>
	        						<br>
	        						<a href='#' class='remove-event-person'><?php _e( 'x remove person', THEMENAME ) ?></a>
	        					</div>
        					<?php $i++; endforeach ?>

        					</div>

        					<a href='#' class='primary button' id='add-event-person'><?php _e( '+ add someone else', THEMENAME ) ?></a>

	        			</div>



	        		</section>

	        		<section class='helpSection'>
	        			<?php
	        			_e('
		        			<p>
							Musico allows you to create events to make sure your followers know where you are performing and when. Your events show up in event lists and on single event pages. Let\'s take a look at how to add and manage albums.
							</p>
							<iframe src="http://player.vimeo.com/video/60760147?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff" width="475" height="356" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>							<h2>Where events are shown</h2>

							<p>
							Events can be seen in two places.
							</p>
							<ul>
								<li>Event Lists</li>
								<li>Event Pages</li>
							</ul>

							<p>
							Event lists can be seen by going to yourdomain.com/event/ They can also be created on arbitrary pages by using the <a title="The List Page Template" href="http://bonsaished.com/blog/kb/the-list-page-template/">List Page Template</a>.
							</p>
							<p>

							When clicking on an event in the list you will be taken to the event\'s dedicated page. A large featured image or Google Map can be added, user\'s have the option to share the even on social sites, add it to their calendar, and so on.
							</p>

							<h2>Creating an Event</h2>
							<p>
							To create an event you will need to click on the "Add New" link in the events section in the WordPress backend. Fill out the title and the description. Remember that you can use any <a href="http://bonsaished.com/blog/topics/musico/shortcodes/">Shortcodes</a> in the content to make it look great.
							</p>
							<p>

							If you want to add additional info you should fill out the options provided in the Musico options area. Here is a list of the options you have:</p>

							<ul>
								<li>Event Structure
							<ul>
								<li><span style="line-height: 12.997159004211426px;"><strong>Featured Image Position</strong>: You can choose to show the image outside of the content or inside it. If "<strong>Above the event, full width</strong>" is chosen, the image will span all the way across the top of the page, right to the edge of the site, above the content. If "<strong>In the event contents</strong>" is chosen it will be constrained to the left side of the event, above the content.</span></li>
								<li><strong>Show Map</strong>: If an address to the venue is specified a full width map is shown above the content, stretching all the way across the screen. You have the option to switch this off. If you would like a map inside the post content instead you can use our <a title="Map Shortcode" href="http://bonsaished.com/blog/kb/map-shortcode/">Map Shortcode</a>.</li>
							</ul>
							</li>
								<li>Event Details
							<ul>
								<li><strong>Date &amp; Time</strong>: Use the date selector to choose the date and time of the event.</li>
								<li><strong>Date Placeholder</strong>: In some cases you might not know the exact date of the event. You can add it anyway, just leave the Date &amp; Time field blank. In this case the date placeholder will be used instead of the date</li>
								<li><strong>City and Country</strong>: Usually people are most interested in the where and when of an event. Due to this we recommend adding the city and country (or city and US State) separately. Something like London, UK or Nashville, TN looks much nicer than having the full address in large type.</li>
								<li><strong>Venue</strong>: Enter the name of the venue you are playing at</li>
								<li><strong>Venue Address</strong>: Enter the full address of the venue. This will be used to generate the Google Map</li>
								<li><strong>Buy Tickets URL</strong>: Enter the URL of the website where users can buy tickets. We recommend using the "closest" link possible. If you are performing at Red Rocks, don\'t just add the main site of the Red Rocks Ampitheater, find the specific page where you can buy tickets for your show. This will enable users to buy tickets a lot more easily.</li>
								<li><strong>Buy Tickets Button Text</strong>: Customize the text of the buy button</li>
							</ul>
							</li>
								<li>Event Participants
							<ul>
								<li><strong>Orchestra</strong>: Mostly for classical musicians. If you are playing with an orchestra or as a member of an orchestra, enter their name here.</li>
								<li><strong>Conductor</strong>: Mostly for classical musicians. If there is a conductor on stage, enter his or her name here.</li>
								<li><strong>Specific People</strong>: This section allows you to specifically name people who you share the stage with. You can add any name-instrument pair you\'d like, they will all be listed in the event\'s page.</li>
							</ul>
							</li>
							</ul>

							<p>Don\'t forget that there is inline help available for each specific option next to the option itself. Simply hover over the help link. In addition, this text is available in the documentation you received with the theme and it can be read online in the <a href="http://bonsaished.com/blog/kb/adding-and-displaying-events/">Knowledgebase</a></p>
							<p>If you have any further questions we are at your service in the <a href="http://bonsaished.com/support/theme/musico/">Support Forum</a>.


	        			', THEMENAME );
	        			?>
	        		</section>

	        		<section class='helpSection'>
	        			<?php echo bsh_docs_shortcodes() ?>
		        	</section>
		        	<section class='helpSection'>
			        	<?php echo bsh_docs_get_support() ?>
			   		</section>

	        	</div>
	        	<div class='clear'></div>
	        </div>

        <?php
    }


}


/***********************************************/
/*       2. Instantiating The Options          */
/***********************************************/

if ( is_admin() ) {
    add_action( 'load-post.php', 'call_bshEventOptions' );
    add_action( 'load-post-new.php', 'call_bshEventOptions' );
}
function call_bshEventOptions() {
	global $bshPostOptions;
	if( $bshPostOptions->get_page_template() == 'event' ) {
    	return new bshEventOptions();
    }
}




?>