<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file contains the upcoming events
	widget. This is a special widget for events
	which can display details of events and a
	buy tickets button.
*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*
	1. Upcoming Events Widget Class
		1.1 Constructor
		1.2 Backend Form
		1.3 Save Widget Options
		1.4 Frontend Widget Display

	2. Widget Registration

*/

/***********************************************/
/*      1. Upcoming Events Widget Class        */
/***********************************************/

class bshUpcomingEventsWidget extends WP_Widget {

	// 1.1 Constructor
	function bshUpcomingEventsWidget() {
        //parent::WP_Widget(
		parent::__construct(
        	false,
        	__( 'Musico: Upcoming Events', THEMENAME ),
        	array(
        		'description' => __( 'This widget allows you to list your upcoming events in the sidebar', THEMENAME )
        	)
        );
    }

	// 1.2 Backend Form
	function form( $instance ) {
		$defaults = array(
			'title'               => '',
			'show_thumbnails'     => 'yes',
			'show_excerpt'        => 'no',
			'show_link'           => 'no',
			'post_count'          => 3,
			'show_title'          => 'no'
		);
		$values = wp_parse_args( $instance, $defaults );
		?>
        <p>
        	<label for='<?php echo $this->get_field_id( 'title' ); ?>'>
        		<?php _e( 'Title:', THEMENAME ); ?>
        		<input class='widefat' id='<?php echo $this->get_field_id( 'title' ); ?>' name='<?php echo $this->get_field_name( 'title' ); ?>' type='text' value='<?php echo $values['title']; ?>' />
        	</label>
        </p>


        <p>
        	<label for='<?php echo $this->get_field_id( 'post_count' ); ?>'>
        		<?php _e( 'Number of events to show:', THEMENAME ); ?>
        		<input class='widefat' id='<?php echo $this->get_field_id( 'post_count' ); ?>' name='<?php echo $this->get_field_name( 'post_count' ); ?>' type='text' value='<?php echo $values['post_count']; ?>' />
        	</label>
        </p>

        <p>
        	<?php $checked = ( $values['show_thumbnails'] == 'yes' ) ? 'checked="checked"' : '' ?>
			<input class='checkbox' <?php echo $checked ?> type='checkbox' value='yes' id='<?php echo $this->get_field_id( 'show_thumbnails' ); ?>' name='<?php echo $this->get_field_name( 'show_thumbnails' ); ?>'>
			<label for='<?php echo $this->get_field_id( 'show_thumbnails' ); ?>'><?php _e( 'show featured images', THEMENAME ) ?></label>
		</p>

        <p>
        	<?php $checked = ( $values['show_title'] == 'yes' ) ? 'checked="checked"' : '' ?>
			<input class='checkbox' <?php echo $checked ?> type='checkbox' value='yes' id='<?php echo $this->get_field_id( 'show_title' ); ?>' name='<?php echo $this->get_field_name( 'show_title' ); ?>'>
			<label for='<?php echo $this->get_field_id( 'show_title' ); ?>'><?php _e( 'show title', THEMENAME ) ?></label>
		</p>


        <p>
        	<?php $checked = ( $values['show_excerpt'] == 'yes' ) ? 'checked="checked"' : '' ?>
			<input class='checkbox' <?php echo $checked ?> type='checkbox' value='yes' id='<?php echo $this->get_field_id( 'show_excerpt' ); ?>' name='<?php echo $this->get_field_name( 'show_excerpt' ); ?>'>
			<label for='<?php echo $this->get_field_id( 'show_excerpt' ); ?>'><?php _e( 'show excerpt', THEMENAME ) ?></label>
		</p>

        <p>
        	<?php $checked = ( $values['show_link'] == 'yes' ) ? 'checked="checked"' : '' ?>
			<input class='checkbox' <?php echo $checked ?> type='checkbox' value='yes' id='<?php echo $this->get_field_id( 'show_link' ); ?>' name='<?php echo $this->get_field_name( 'show_link' ); ?>'>
			<label for='<?php echo $this->get_field_id( 'show_link' ); ?>'><?php _e( 'show read more links', THEMENAME ) ?></label>
		</p>


        <?php
    }

	// 1.3 Save Widget Options
	function update( $new_instance, $old_instance ) {

		$new_instance['show_thumbnails']      = ( isset( $new_instance['show_thumbnails'] ) AND $new_instance['show_thumbnails'] == 'yes' ) ? 'yes' : 'no';
		$new_instance['show_excerpt']         = ( isset( $new_instance['show_excerpt'] ) AND $new_instance['show_excerpt'] == 'yes' ) ? 'yes' : 'no';
		$new_instance['show_link']            = ( isset( $new_instance['show_link'] ) AND $new_instance['show_link'] == 'yes' ) ? 'yes' : 'no';
		$new_instance['show_title']            = ( isset( $new_instance['show_title'] ) AND $new_instance['show_title'] == 'yes' ) ? 'yes' : 'no';
        return $new_instance;
    }

	// 1.4 Frontend Widget Display
	function widget( $args, $instance ) {
		global $post, $wpdb, $wp_query;

		$atts = array(
			'post_status'      => 'publish',
			'posts_per_page'   => $instance['post_count'],
			'orderby'          => 'meta_value',
			'meta_key'         => '_mus_time',
			'order'            => 'DESC',
			'post_type'        => 'event'
		);

	   $atts['meta_query'] = array(
	       array(
	           'key' => '_mus_time',
	           'value' => date('Y-m-d H:i:s'),
	           'compare' => '>=',
	       )
	   );


		$temp_query = $wp_query;
		$wp_query = null;

		$wp_query = new WP_Query( $atts );
		if( have_posts() ) {

			echo $args['before_widget'];
			echo $args['before_title'] . $instance['title'] .  $args['after_title'];

			echo '<ul>';
			while( have_posts() ) {
				the_post();
				$location = get_post_meta( $post->ID, '_mus_location', true );
				$time = get_post_meta( $post->ID, '_mus_time', true );
				$ticket_url = get_post_meta( $post->ID, '_mus_ticket_url', true );
				$ticket_text = get_post_meta( $post->ID, '_mus_ticket_text', true );
				$ticket_text = ( empty( $ticket_text ) ) ? 'tickets' : $ticket_text;

				echo '<li class="layout-widget-upcoming-events">';
				if( !empty( $instance['show_thumbnails'] ) AND $instance['show_thumbnails'] == 'yes' AND has_post_thumbnail() ) {
					echo '<a href="' . get_permalink() . '" class="hoverlink">';
					the_post_thumbnail( 'sidebar' );
					echo '</a>';
					echo '<div class="clear"></div>';
				}




				if( !empty( $time ) ) {
					echo '<h3>
						<span class="date"><a href="' . get_permalink() . '">' . date( 'F d, Y', strtotime( $time ) ) . '</a></span>
						<span class="time"><a href="' . get_permalink() . '">' . date( 'H:i', strtotime( $time ) ) . '</a></span>
						</h3>';
				}


				if( !empty( $location ) ) {
					echo '<h2><a href="' . get_permalink() . '">' . $location . '</a></h2>';
				}

				if( !empty( $ticket_url ) ) {
					echo '<a class="secondary button small" href="' . $ticket_url . '">' . $ticket_text . '</a><br>';
				}

				if( !empty( $instance['show_title'] ) AND $instance['show_title'] == 'yes' ) {
					the_title( '<h1><a href="' . get_permalink() . '">', '</a></h1>' );
				}

				if( !empty( $instance['show_excerpt'] ) AND $instance['show_excerpt'] == 'yes' ) {
					echo '<div class="content">';
					the_excerpt();
					echo '</div>';
				}

				if( !empty( $instance['show_link'] ) AND $instance['show_link'] == 'yes' ) {
					echo '<a class="read-more primary" href="' . get_permalink() . '">' . get_theme_mod( 'read_more_text' ) . '</a>';
				}

				echo '</li>';
			}
			echo '</ul>';
		echo $args['after_widget'];

		}

		$wp_query = $temp_query;
	    wp_reset_postdata();
    }
}


/***********************************************/
/*          2. Widget Registration             */
/***********************************************/

register_widget('bshUpcomingEventsWidget');

?>