<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This is theme index file. It is a fallback
	for many unspecified templates. It shows
	a list of posts according to different
	criteria.

*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*
	1. Get Header
	2. Page Title
	3. Get Posts
	4. Pagination
	5. Sidebar
	6. No Posts Fallback
	7. Get Footer
*/

// 1. Get Header
get_header();
global $wp_query;
if( is_home() ) {
	query_posts( array_merge(
		$wp_query->query_vars,
		array( 'post_type' => array( 'post', 'event', 'album' ) )
	));
}
?>

<?php // 2. Page Title ?>
<?php if( is_search() OR is_archive() ) : ?>
<div class='row'>
	<div class='twelve columns'>
		<?php if( is_search() AND have_posts() ) : ?>
		<h1 class='page-title'>
			<?php _e( 'Searched For: ', THEMENAME ) ?>
			<?php echo get_search_query() ?>
		</h1>
		<?php else : ?>
		<h1 class='page-title'><?php
			if ( is_day() ) :
				printf( __( 'Daily Archives: %s', THEMENAME ), '<span>' . get_the_date() . '</span>' );
			elseif ( is_month() ) :
				printf( __( 'Monthly Archives: %s', THEMENAME ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', THEMENAME ) ) . '</span>' );
			elseif ( is_year() ) :
				printf( __( 'Yearly Archives: %s', THEMENAME ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', THEMENAME ) ) . '</span>' );
			elseif ( is_category() ) :
				printf( __( 'Category: %s', THEMENAME ), '<span>' . single_cat_title( '', false ) . '</span>' );
			elseif ( is_tag() ) :
				printf( __( 'Tags: %s', THEMENAME ), '<span>' . single_cat_title( '', false ) . '</span>' );
			elseif( is_post_type_archive( 'event' ) ) :
				_e( 'Events', THEMENAME );
			elseif( is_post_type_archive( 'album' ) ) :
				_e( 'Albums', THEMENAME );
			elseif( have_posts() ) :
				_e( 'Archives', THEMENAME );
			endif;
		?></h1>
		<?php endif ?>
	</div>
</div>
<?php endif ?>


<?php if( have_posts() ) { ?>

	<div class='row'>
		<div id='siteContent' class='columns <?php echo bsh_content_classes() ?>'>
			<?php
				// 3. Get Posts
				while( have_posts() ) {
					the_post();
					get_template_part( 'layouts/layout', $post->post_type . '-item' );
				}

				// 4. Pagination
				echo '<div class="pagination m44">';
				bsh_pagination();
				echo '</div>';
			?>
		</div>

		<?php // 5. Sidebar ?>
		<?php if( bsh_has_sidebar() ) : ?>
			<div id='siteSidebar' class='four columns <?php echo bsh_sidebar_classes() ?>'>
				<?php dynamic_sidebar( bsh_get_sidebar() ) ?>
			</div>
		<?php endif ?>
	</div>

<?php
}
// 6. No Posts Fallback
else {
	if( is_search() ) {
		bsh_no_posts( get_theme_mod( 'no_search_title' ), get_theme_mod( 'no_search_message' ) );
	}
	else {
		bsh_no_posts();
	}
}

// 7. Get Footer
get_footer();

?>