<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file is responsible for displaying
	the list form of albums

*/

$has_image = ( has_post_thumbnail() ) ? 'has-image' : 'no-image';
?>
<article <?php post_class( 'layout-album-item list-item ' . $has_image ) ?>>
	<div class='row'>

	<?php if( has_post_thumbnail() ) : ?>
		<div class='columns four'>
			<div class='album-image'>
				<a class='hoverlink' title='<?php _e( 'Click here to go to this album', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php the_post_thumbnail( 'gallery' ) ?></a>
			</div>
		</div>
	<?php endif ?>

	<div class='columns eight'>
		<div class='album-content'>
			<h1 class='layout-title'><a title='<?php _e( 'Click here to go to this album', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php the_title() ?></a></h1>

			<div class='metas primary-links'>

				<span class='meta date'><span class='icon date'></span> <?php the_time( 'F j, Y' ) ?></span>

			</div>

			<div class='content'>
				<?php
					$content_type = get_theme_mod( 'list_content_type' );
					if( $content_type === 'content' ) {
						the_content();
					}
					else {
						the_excerpt();
						?>
						<a title='<?php _e( 'Click here to go to this album', THEMENAME ) ?>' class='primary' href='<?php the_permalink() ?>'><?php echo get_theme_mod( 'read_more_text' ) ?></a>
						<?php
					}
				?>
			</div>

		</div>
	</div>

	</div>
</article>