<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file displays the contents of a single
	album page. It shows the title and contents
	and if there are media items uploaded it
	displays a music player.
*/

?>
<div <?php post_class('layout-album single') ?>>

	<div class='audioplayer'>

		<?php

			$audio = array();
			$tracks = $wpdb->get_results( "SELECT ID, post_title, guid FROM $wpdb->posts WHERE post_parent = $post->ID AND post_type = 'attachment' AND post_mime_type LIKE '%audio%' ORDER BY menu_order ASC" );

			$thumbnail_id = get_post_thumbnail_id( $post->ID );
			$cover = wp_get_attachment_image_src( $thumbnail_id, 'musico_album_thumb' );

			$i=1;
			foreach( $tracks as $track ) {

				$buy      = get_post_meta( $track->ID, '_mus_buylink', true );
				$duration = get_post_meta( $track->ID, '_mus_duration', true );
				$artist   = get_post_meta( $track->ID, '_mus_artist', true );

				$duration = empty( $duration ) ? '0:00' : $duration;
				$artist = empty( $artist ) ? get_bloginfo() : $artist;

				$tracknumber = get_post_meta( $track->ID, '_mus_tracknumber', true );
				$tracknumber = empty( $tracknumber ) ? $i*100 : $tracknumber;

				$audio[$tracknumber] = array(
					'ID'       => $track->ID,
					'mp3'      => $track->guid,
					'rating'   => 5,
					'title'    => $track->post_title,
					'buy'      => $buy,
					'duration' => $duration,
					'artist'   => $artist,
					'cover'	   => $cover[0],
				);

				$i++;
			}

			ksort( $audio );

			$buytext = get_theme_mod( 'buytext' );
			$buytext = ( empty( $buytext ) ) ? 'Buy' : $buytext;
		?>

		<div id='audioplayer-<?php the_ID() ?>'></div>

		<script type='text/javascript'>

		options = {
		    buyText:'<?php echo $buytext ?>',
		    tracksToShow:999,
		    autoplay:false,
	        jPlayer:{
	            swfPath:'<?php echo get_template_directory_uri() ?>/javascripts/source/external/Jplayer.swf',
	            solution: 'flash, html'
	        }
		};

		playlist = [

			<?php foreach( $audio as $track ) : ?>
			{
				mp3:'<?php echo $track['mp3'] ?>',
				rating:<?php echo $track['rating'] ?>,
				title:'<?php echo addslashes( $track['title'] ) ?>',
				<?php if( !empty( $track['buy'] ) ) : ?>
				buy:'<?php echo $track['buy'] ?>',
				<?php endif ?>
				duration:'<?php echo $track['duration'] ?>',
				artist:'<?php echo $track['artist'] ?>',
				cover:'<?php echo $track['cover'] ?>'
			},
			<?php endforeach ?>

		];

		jQuery( document ).ready( function() {
			jQuery( '#audioplayer-<?php the_ID() ?>' ).ttwMusicPlayer(playlist, options);
		})
		</script>
	</div>


	<div class='album-content'>
		<h1 class='layout-title'><?php the_title() ?></h1>
		<div class='content'>
			<?php the_content() ?>
		</div>
		<?php
			ob_start();
			wp_link_pages( array( 'before' => '<div class="single-pagination"> <span class="title">Pages:</span> ', 'after' => ' </div>' ) );
			$pagination = ob_get_clean();
			$pagination = preg_replace( '/ ([0-9]+) /', ' <span class="current">$1</span> ', $pagination );
			echo $pagination;
		?>

	</div>


</div></div></div>