<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file displays the contents of a single
	event. There are numerous things shown here
	like a map, event details, buy tickets link,
	and so on.
*/


$location = get_post_meta( $post->ID, '_mus_location', true );
$time = get_post_meta( $post->ID, '_mus_time', true );
$date_placeholder = get_post_meta( $post->ID, '_mus_date_placeholder', true );
$venue = get_post_meta( $post->ID, '_mus_venue', true );
$ticket_url = get_post_meta( $post->ID, '_mus_ticket_url', true );
$ticket_text = get_post_meta( $post->ID, '_mus_ticket_text', true );
$orchestra = get_post_meta( $post->ID, '_mus_orchestra', true );
$conductor = get_post_meta( $post->ID, '_mus_conductor', true );
$people = get_post_meta( $post->ID, '_mus_people', true );
$address = get_post_meta( $post->ID, '_mus_address', true );

$people = ( count( $people ) == 0 AND empty( $people[0]['name'] ) AND empty( $people[0]['instrument'] ) ) ? '' : $people;
$ticket_text = ( empty( $ticket_text ) ) ? __( 'Buy Tickets', THEMENAME ) : $ticket_text;
$date_placeholder = ( empty( $date_placeholder ) ) ? __( 'Date not set yet', THEMENAME ) : $date_placeholder;

$thumbnail_position = get_post_meta( $post->ID, '_mus_thumbnail_position', true );
$thumbnail_position = ( empty( $thumbnail_position ) ) ? 'outside' : $thumbnail_position;
?>
<div <?php post_class( 'layout-event' ) ?>>

	<div class='row'>
		<div class='twelve columns'>
			<header>
				<div class='metas'>
					<?php if( !empty( $location ) OR ( !empty( $venue ) ) ) : ?>
						<span class='meta location'><?php echo $location ?>
						<?php if( !empty( $venue ) ) : ?>
						- <?php echo $venue ?>
						<?php endif ?>
						</span>
					<?php endif ?>
					<span class='meta time'>
						<?php
							if( empty( $time ) ) {
								echo $date_placeholder;
							}
							else {
								echo date( 'F dS, Y H:i', strtotime( $time ) );
							}
						?>
					</span>
				</div>
				<h1 class='layout-title'><?php the_title() ?></h1>
			</header>
		</div>
	</div>

	<?php if( has_post_thumbnail() AND $thumbnail_position == 'outside' ) : ?>
		<?php the_post_thumbnail( 'mus_full' ) ?>
	<?php endif ?>


	<?php
		if( !empty( $address ) AND get_post_meta( $post->ID, '_mus_show_map', true ) != 'no' ) {
			echo do_shortcode( '[map zoom="14" height="260px" type="ROADMAP" location="' . get_post_meta( $post->ID, '_mus_address', true ) . '"]' );
		}
	?>



	<div class='row'>
		<div class='twelve columns'>
			<aside>

				<?php if( !empty( $ticket_url ) ) : ?>
					<div class='buy-tickets'>
						<a class='button large secondary' href='<?php echo $ticket_url ?>'><?php echo $ticket_text ?></a><br><br>
					</div>
				<?php endif ?>

				<div class='share' data-name='<?php the_title() ?> - <?php bloginfo() ?>' data-description='<?php the_excerpt() ?>' data-link='<?php the_permalink() ?>'>
					<a title='<?php _e('Click here to share via Facebook', THEMENAME ) ?>' href='#' class='facebook'></a>

					<a title='<?php _e('Click here to share via Twitter', THEMENAME ) ?>' href="javascript:void(window.open('https://twitter.com/share', 'Share to Twitter','width=600,height=260,menubar=no,location=no,status=no,top=' + ( (screen.height / 2 ) - 260 ) + ', left=' + ( (screen.width / 2 ) - 300 )  ))" target='_blank' class='twitter'></a>

					<a title='<?php _e( 'Click here to share via Google+', THEMENAME ) ?>' href="javascript:void(window.open('https://plus.google.com/share?ur\l='+encodeURIComponent('<?php the_permalink() ?>'), 'Share to Google+','width=600,height=460,menubar=no,location=no,status=no,top=' + ( (screen.height / 2 ) - 460 ) + ', left=' + ( (screen.width / 2 ) - 300 )  ))"  class='google'></a>

				</div>

				<?php if( !empty( $time ) ) : ?>
					<div class='add-to-googlecal'>
					<?php
						$event_name = urlencode( the_title( '', '', false ) . ' - ' . get_bloginfo() );
						$event_date = date( 'Ymd\THi00\Z', strtotime( $time ) );
						$details = urlencode( sprintf( __( 'Details of this event can be viewed on the following webpage: %s', THEMENAME ), get_permalink() ) );

					?>

						<a title='<?php _e('Click here to share add this event to your Google Calendar', THEMENAME ) ?>' href="http://www.google.com/calendar/event?action=TEMPLATE&text=<?php echo $event_name ?>&dates=<?php echo $event_date ?>/<?php echo $event_date ?>&details=<?php echo $details ?>&location=<?php echo urlencode( $address ) ?>&trp=true&sprop=&sprop=name:" target="_blank"><img src="//www.google.com/calendar/images/ext/gc_button6.gif" border=0></a>
					</div>
				<?php endif ?>

				<ul class='event-details'>
					<?php if( !empty( $time ) ) : ?>
					<li>
						<?php _e( 'Date:', THEMENAME ) ?>
						<span class='heading-text-color'><?php echo date( 'F dS, Y H:i', strtotime( $time ) ) ?></span>
					</li>
					<?php endif ?>
					<?php if( !empty( $venue ) ) : ?>
						<li>
							<?php _e( 'Venue:', THEMENAME ) ?>
							<span class='heading-text-color'><?php echo $venue ?></span>
						</li>
					<?php endif ?>
					<?php if( !empty( $address ) ) : ?>
						<li>
							<?php _e( 'Address: ', THEMENAME ) ?>
							<span class='heading-text-color'><?php echo $address ?></span>
						</li>
					<?php endif ?>
				</ul>
			</aside>

			<article>

				<?php if( has_post_thumbnail() AND $thumbnail_position == 'inside' ) : ?>
					<?php the_post_thumbnail( bsh_get_layout_size( 'mus_large' ) ) ?>
				<?php endif ?>

				<div class='content'>
					<?php the_content() ?>
				</div>

				<?php
					ob_start();
					wp_link_pages( array( 'before' => '<div class="single-pagination"> <span class="title">Pages:</span> ', 'after' => ' </div>' ) );
					$pagination = ob_get_clean();
					$pagination = preg_replace( '/ ([0-9]+) /', ' <span class="current">$1</span> ', $pagination );
					echo $pagination;
				?>
				<?php if( ( !empty( $people ) AND !empty( $people[1]['name'] ) ) OR !empty( $conductor ) OR !empty( $orchestra ) ) : ?>
				<div class='on-stage'>

					<?php
						$onstage = get_post_meta( $post->ID, '_mus_onstage_title', true );
						if( !empty( $onstage ) ) :
					?>
						<h1><?php echo $onstage ?></h1>
					<?php endif ?>

					<table class='noformat nofullwidth'>
						<?php if( !empty( $orchestra ) ) : ?>
							<tr>
								<td class='instrument'>Orchestra</td>
								<td class='name heading-text-color'><?php echo $orchestra ?></td>
							</tr>
						<?php endif ?>
						<?php if( !empty( $conductor ) ) : ?>
							<tr>
								<td class='instrument'>Conductor</td>
								<td class='name heading-text-color'><?php echo $conductor ?></td>
							</tr>
						<?php endif ?>
						<?php if( !empty( $people ) ) : foreach( $people as $person ) : ?>
							<tr>
								<td class='instrument'><?php echo $person['instrument'] ?></td>
								<td class='name heading-text-color'><?php echo $person['name'] ?></td>
							</tr>
						<?php endforeach; endif; ?>
					</table>
				</div>
				<?php endif ?>
			</article>
		</div>
	</div>
</div>