<?php
/*
Template Name: Event List Page
*/
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file displays the regular single post.
*/

get_header();
?>

<?php if( have_posts() ) { the_post() ?>

	<div class='row'>

		<div class='columns <?php echo bsh_content_classes() ?>'>

			<?php if( !empty( $post->post_content ) OR get_post_meta( $post->ID, '_mus_title', true ) != 'hide' ) : ?>

 			<div <?php post_class( 'layout-list-page single' ) ?>>

				<?php if( get_post_meta( $post->ID, '_mus_title', true ) != 'hide' ) : ?>
					<h1 class='layout-title'><?php the_title() ?></h1>
				<?php endif ?>

				<?php if( has_post_thumbnail() ) : ?>
					<?php the_post_thumbnail( bsh_get_layout_size( 'mus_large' ) ) ?>
				<?php endif ?>

				<div class='content'>
					<?php the_content() ?>
				</div>
			</div>

			<?php endif ?>

			<?php


				$posts_per_page = get_post_meta( $post->ID, '_mus_posts_per_page', true );
				$posts_per_page = ( empty( $posts_per_page ) ) ? get_option( 'posts_per_page' ) : $posts_per_page;

				$order = get_post_meta( $post->ID, '_mus_order', true );
				$order = ( empty( $order ) ) ? 'DESC' : $order;

				$orderby = get_post_meta( $post->ID, '_mus_orderby', true );
				$orderby = ( empty( $orderby ) ) ? 'date' : $orderby;

				$type = get_post_meta( $post->ID, '_mus_event_type', true );
				$type = ( empty( $type ) ) ? 'future' : $type;


				$temp_query = $wp_query;
				$wp_query = null;

				$paged = ( !empty( $temp_query->query['paged'] ) ) ? $temp_query->query['paged'] : 1;

				$args = array(
					'post_status'    => 'publish',
					'post_type'      => 'event',
					'posts_per_page' => $posts_per_page,
					'paged'          => $paged,
					'order'          => $order
				);

				if( $orderby == '_mus_time' ) {
					$args['orderby'] = 'meta_value';
					$args['meta_key'] = '_mus_time';
				}
				else {
					$args['orderby'] = $orderby;
				}

				if( $type == 'future' ) {
					$args['meta_query'][] = array(
						'meta_key' => '_mus_time',
						'value'    => date( 'Y-m-d H:i:s' ),
						'compare'  => '>=',
						'type'     => 'DATETIME'
					);
				}
				elseif( $type == 'past' ) {
					$args['meta_query'][] = array(
						'meta_key' => '_mus_time',
						'value'    => date( 'Y-m-d H:i:s' ),
						'compare'  => '<=',
						'type'     => 'DATETIME'
					);
				}

				$wp_query = new WP_Query( $args );

				while( have_posts() ) {
					the_post();
					get_template_part( 'layouts/layout', $post->post_type . '-item' );
				}

				echo '<div class="pagination m44">';
				bsh_pagination();
				echo '</div>';

				$wp_query = $temp_query;
				wp_reset_postdata();
			?>

		</div>

		<?php if( bsh_has_sidebar() ) : ?>
			<div id='siteSidebar' class='four columns <?php echo bsh_sidebar_classes() ?>'>
				<?php dynamic_sidebar( bsh_get_sidebar() ) ?>
			</div>
		<?php endif ?>
	</div>

<?php
}

else {
	bsh_no_posts();
}

get_footer()
?>