<?php
/*
Template Name: List Page
*/
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file displays the regular single post.
*/

get_header();
?>

<?php if( have_posts() ) { the_post() ?>

	<div class='row'>

		<div class='columns <?php echo bsh_content_classes() ?>'>

			<?php if( !empty( $post->post_content ) OR get_post_meta( $post->ID, '_mus_title', true ) != 'hide' ) : ?>

 			<div <?php post_class( 'layout-list-page single' ) ?>>

				<?php if( get_post_meta( $post->ID, '_mus_title', true ) != 'hide' ) : ?>
					<h1 class='layout-title'><?php the_title() ?></h1>
				<?php endif ?>

				<?php if( has_post_thumbnail() ) : ?>
					<?php the_post_thumbnail( bsh_get_layout_size( 'mus_large' ) ) ?>
				<?php endif ?>

				<div class='content'>
					<?php the_content() ?>
				</div>
			</div>

			<?php endif ?>

			<?php


				$posts_per_page = get_post_meta( $post->ID, '_mus_posts_per_page', true );
				$posts_per_page = ( empty( $posts_per_page ) ) ? get_option( 'posts_per_page' ) : $posts_per_page;

				$order = get_post_meta( $post->ID, '_mus_order', true );
				$order = ( empty( $order ) ) ? 'DESC' : $order;

				$orderby = get_post_meta( $post->ID, '_mus_orderby', true );
				$orderby = ( empty( $orderby ) ) ? 'date' : $orderby;

				$categories = get_post_meta( $post->ID, '_mus_categories', true );

				$post_types = get_post_meta( $post->ID, '_mus_post_types', true );
				$post_types = ( empty( $post_types ) ) ? 'any' : $post_types;

				$temp_query = $wp_query;
				$wp_query = null;

				$paged = ( !empty( $temp_query->query['paged'] ) ) ? $temp_query->query['paged'] : 1;

				if( $post_types != array( 'post' ) AND !empty( $categories ) ) {
					$term_ids = implode( ',', $categories );
					$term_taxonomy_ids = implode( ', ', $wpdb->get_col( "SELECT term_taxonomy_id FROM $wpdb->term_taxonomy WHERE term_id IN ( $term_ids ) AND taxonomy = 'category' " ));
					$post_ids = $wpdb->get_col( "SELECT object_ID FROM $wpdb->term_relationships WHERE term_taxonomy_id IN ( $term_taxonomy_ids ) AND object_ID IN (SELECT ID FROM $wpdb->posts WHERE post_status = 'publish' AND post_type='post' ) " );
					$post_type_where = '';
					if( !empty( $post_ids ) ) {
						$post_type_types = "'" . implode( "','", $post_types ) . "'";
						$post_type_where = ' post_type IN ( ' . $post_type_types . ' ) ';
					}
					$other_ids = $wpdb->get_col( "SELECT ID FROM $wpdb->posts WHERE 1=1 $post_type_where AND post_type != 'post' AND post_status = 'publish'" );
					$post__in = array_merge( $post_ids, $other_ids );

					$args = array(
						'post_status'    => 'publish',
						'post_type'      => $post_types,
						'posts_per_page' => $posts_per_page,
						'order'          => $order,
						'orderby'        => $orderby,
						'paged'          => $paged,
						'post__in'       => $post__in
					);
				}
				else {
					$args = array(
						'post_status'    => 'publish',
						'post_type'      => $post_types,
						'posts_per_page' => $posts_per_page,
						'order'          => $order,
						'orderby'        => $orderby,
						'paged'          => $paged
					);

					if( !empty( $categories ) ) {
						$categories = implode( ',', $categories );
						$args['cat'] = $categories;
					}
				}

				$wp_query = new WP_Query( $args );

				while( have_posts() ) {
					the_post();
					get_template_part( 'layouts/layout', $post->post_type . '-item' );
				}

				echo '<div class="pagination m44">';
				bsh_pagination();
				echo '</div>';

				$wp_query = $temp_query;
				wp_reset_postdata();
			?>

		</div>

		<?php if( bsh_has_sidebar() ) : ?>
			<div id='siteSidebar' class='four columns <?php echo bsh_sidebar_classes() ?>'>
				<?php dynamic_sidebar( bsh_get_sidebar() ) ?>
			</div>
		<?php endif ?>
	</div>

<?php
}

else {
	bsh_no_posts();
}

get_footer()
?>