<?php



#	Functions:

#	

#	ewf_message ($message)

#	ewf_debug_log ($debug, $message)

#





	if ( ! isset( $content_width ) ) $content_width = 940;





#

#	Add and ID column to pages & taxonomy

#	

#	add_theme_support('ewf-editor-columnID');

#



	if (current_theme_supports('ewf-editor-columnID')){

				

			add_action('admin_init'		, 'ewf_add_id_column');



			function ewf_add_id_column() {

				add_action('admin_head', 'ewf_add_id_column_css');



				add_filter('manage_posts_columns', 'ewf_add_id_column_source');

				add_action('manage_posts_custom_column', 'ewf_add_id_column_value', 10, 2);



				add_filter('manage_pages_columns', 'ewf_add_id_column_source');

				add_action('manage_pages_custom_column', 'ewf_add_id_column_value', 10, 2);



				foreach ( get_taxonomies() as $taxonomy ) {

					add_action("manage_edit-${taxonomy}_columns", 'ewf_add_id_column_source');			

					add_filter("manage_${taxonomy}_custom_column", 'ewf_add_id_column_value_return', 10, 3);

				}

			}

			

			function ewf_add_id_column_source($cols) {

				$cols['item-id'] = '<span>ID</span>'; 

				return $cols;

			} 



			function ewf_add_id_column_value($column_name, $id) { 

				if ($column_name == 'item-id') echo $id;

			}



			function ewf_add_id_column_value_return($value, $column_name, $id) {

				if ($column_name == 'item-id') $value = $id;

				return $value;

			}



			function ewf_add_id_column_css() {

				echo ' <style type="text/css"> #item-id { width: 50px; }</style>';

			}



	}



	



	

//	

//	Output messages in the theme

//

	function ewf_message($msg, $reference = null){

		return '<div class="alert error">'.$msg.'</div>';

	}

		

		



//

//	Get Attachment details

//

	function ewf_get_attachment( $attachment_id ) {



		$attachment = get_post( $attachment_id );

		return array(

			'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),

			'caption' => $attachment->post_excerpt,

			'description' => $attachment->post_content,

			'href' => get_permalink( $attachment->ID ),

			'src' => $attachment->guid,

			'title' => $attachment->post_title

		);

	}

	



//	

//	Check if composer is active on a page content

//	

	function ewf_isComposerActive($content){

		return (count(explode('[/vc_row]', $content))-1);

	}

	

	

#	

#	Used for debugging purpose	

#

	function ewf_debug_log($debug, $message){ 

		#

		# ewf_message($message);

		#

		apply_filters($debug, $message);

	}

	

	

	



	

	function ewf_load_socialProfiles(){

		$profiles = array();

		

		$profiles[] = array( 'class' => 'facebook'		, 'url' => get_option(EWF_SETUP_THNAME."_social_facebook"	, null ));

		$profiles[] = array( 'class' => 'twitter'		, 'url' => get_option(EWF_SETUP_THNAME."_social_twitter"	, null ));

		$profiles[] = array( 'class' => 'google-plus'	, 'url' => get_option(EWF_SETUP_THNAME."_social_plus"		, null ));

		$profiles[] = array( 'class' => 'pinterest'		, 'url' => get_option(EWF_SETUP_THNAME."_social_pinterest"	, null ));

		$profiles[] = array( 'class' => 'instagram'		, 'url' => get_option(EWF_SETUP_THNAME."_social_instagram"	, null ));	

		$profiles[] = array( 'class' => 'tumblr'		, 'url' => get_option(EWF_SETUP_THNAME."_social_tumblr"		, null ));	

		$profiles[] = array( 'class' => 'youtube'		, 'url' => get_option(EWF_SETUP_THNAME."_social_youtube"	, null ));	

		$profiles[] = array( 'class' => 'flickr'		, 'url' => get_option(EWF_SETUP_THNAME."_social_flickr"		, null ));	

		$profiles[] = array( 'class' => 'linkedin'		, 'url' => get_option(EWF_SETUP_THNAME."_social_linkedin"	, null ));	

		

		

		foreach($profiles as $key=>$value){

			if ($value['url'] == null){

				unset($profiles[$key]);

			}

		}

		

		

		#	if (count($profiles) > 1){

		#		$profiles[count($profiles)-1]['class'] = $profiles[count($profiles)-1]['class'].' last';

		#	}elseif(count($profiles) == 1){

		#		$profiles[count($profiles)-1]['class'] = $profiles[count($profiles)-1]['class'].' last';

		#	}

		

		

		return $profiles;

	}

		

		

	function ewf_excerpt_max_charlength($charlength) {

		$excerpt = get_the_excerpt();

		$charlength++;



		if ( mb_strlen( $excerpt ) > $charlength ) {

			$subex = mb_substr( $excerpt, 0, $charlength - 5 );

			$exwords = explode( ' ', $subex );

			$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );

			if ( $excut < 0 ) {

				echo mb_substr( $subex, 0, $excut );

			} else {

				echo $subex;

			}

			echo '...';

		} else {

			echo $excerpt;

		}

	}

	

	

	

	

	

	



	

	function ewf_debugging_mode_notices() {

		//

		// For resolving customer support on site without actually making changes to the theme enable ewf-debug and show some basic information about the setup itself

		

		if (array_key_exists('ewf-debug', $_REQUEST)){

			update_option(EWF_SETUP_THNAME."_debug_mode", 'true');

		}

		

		if (array_key_exists('ewf-debug-off', $_REQUEST)){

			update_option(EWF_SETUP_THNAME."_debug_mode", 'false');

		}





		if (get_option(EWF_SETUP_THNAME."_debug_mode", 'false') == 'true'){

			echo '<div class="updated">';

			

				echo '<p>EWF Debug mode active</p>';

				

			echo '</div>';

		}

		

		// echo '<pre>';

			// print_r($_REQUEST);

		// echo '</pre>';

	}

	

	add_action( 'admin_notices', 'ewf_debugging_mode_notices' );

	

	

	

	function ewf_load_JSVariables(){

		echo '

		<script type="text/javascript">

			var ajaxURL = "'.site_url().'/wp-admin/admin-ajax.php";

			var siteURL = "'.site_url().'";

			var themePath = "'.get_template_directory_uri().'";

		</script>';

	}

	



	/*

	if (!function_exists('is_post_type')){

	

		function is_post_type($type = null){

			global $post;

			

			if (get_post_type($post) == strtolower($type)){

				return true;

			}else{

				return false;

			}

		}

	}

	*/

	

	

	/*

	function efw_get_content_formatted ($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {

	

		$content = get_the_content($more_link_text, $stripteaser, $more_file);

		$content = apply_filters('the_content', $content);

		$content = str_replace(']]>', ']]&gt;', $content); 

		

		return $content;

	}

	*/



?>