<?php 







	class ewf_widget_social_media extends WP_Widget {



		function ewf_widget_social_media() {

			$widget_ops = array( 'classname' => 'ewf_widget_social_media', 'description' => __('A widget that displays social media icons designed for header top', EWF_SETUP_THEME_DOMAIN) );

			$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'ewf_widget_social_media' );

			$this->WP_Widget( 'ewf_widget_social_media', __('EWF - Social Media', EWF_SETUP_THEME_DOMAIN), $widget_ops, $control_ops );

		}

		





		function widget( $args, $instance ) {

			extract( $args );

			global $post;



			$title = apply_filters('widget_title', $instance['title'] );

			$profile_facebook 	=  $instance['profile_facebook'];

			$profile_twitter 	=  $instance['profile_twitter'];

			$profile_plus 		=  $instance['profile_plus'];

			$profile_pinterest	=  $instance['profile_pinterest'];

			$profile_youtube 	=  $instance['profile_youtube'];

			$profile_dribbble 	=  $instance['profile_dribbble'];

			$profile_tumblr 	=  $instance['profile_tumblr'];

			$profile_instagram 	=  $instance['profile_instagram'];

			$profile_rss 		=  $instance['profile_rss'];





			echo $before_widget;



			if ( $title ) 

				echo $before_title . $title . $after_title;

			

			

			echo '<div class="fixed">';



				if ($profile_facebook){

					echo '<a class="facebook-icon social-icon fa fa-facebook" href="'.$profile_facebook.'"></a>';

				}

				

				if ($profile_twitter){

					echo '<a class="twitter-icon social-icon fa fa-twitter" href="'.$profile_twitter.'"></a>';

				}

				

				if ($profile_plus){

					echo '<a class="googleplus-icon social-icon fa fa-google-plus" href="'.$profile_plus.'"></a>';

				}

				

				if ($profile_pinterest){

					echo '<a class="pinterest-icon social-icon fa fa-pinterest" href="'.$profile_pinterest.'"></a>';

				}

				

				if ($profile_youtube){

					echo '<a class="youtube-icon social-icon fa fa-youtube" href="'.$profile_youtube.'"></a>';

				}

				

				if ($profile_dribbble){

					echo '<a class="dribble-icon social-icon fa fa-dribbble" href="'.$profile_dribbble.'"></a>';

				}

				

				if ($profile_tumblr){

					echo '<a class="tumblr-icon social-icon fa fa-tumblr" href="'.$profile_tumblr.'"></a>';

				}	

				

				if ($profile_instagram){

					echo '<a class="instagram-icon social-icon fa fa-instagram" href="'.$profile_instagram.'"></a>';

				}



				if ($profile_rss){

					echo '<a class="rss-icon social-icon fa fa-rss" href="'.$profile_rss.'"></a>';

				}

			echo '</div>';

			



			

			echo $after_widget;

		}

	 

		

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

			

			$instance['title'] 				= $new_instance['title'] ;

			$instance['profile_facebook'] 	= $new_instance['profile_facebook'] ;

			$instance['profile_twitter'] 	= $new_instance['profile_twitter'] ;

			$instance['profile_plus'] 		= $new_instance['profile_plus'] ;

			$instance['profile_pinterest'] 	= $new_instance['profile_pinterest'] ;

			$instance['profile_youtube'] 	= $new_instance['profile_youtube'] ;

			$instance['profile_dribbble'] 	= $new_instance['profile_dribbble'] ;

			$instance['profile_tumblr'] 	= $new_instance['profile_tumblr'] ;

			$instance['profile_instagram'] 	= $new_instance['profile_instagram'] ;

			$instance['profile_rss'] 	= $new_instance['profile_rss'] ;





			return $instance;

		}

		 



		function form( $instance ) {

			$defaults = array( 

				'title' => null, 

				'profile_facebook' => null, 

				'profile_twitter' => null, 

				'profile_plus' => null, 

				'profile_pinterest' => null, 

				'profile_youtube' => null,

				'profile_dribbble' => null,

				'profile_tumblr' => null,

				'profile_instagram' => null,

				'profile_rss' => null

			);

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<div class="ewf-meta">

				<p>

					<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />

				</p>



				<p>

					<label for="<?php echo $this->get_field_id( 'profile_facebook' ); ?>"><?php _e('Facebook profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_facebook' ); ?>" name="<?php echo $this->get_field_name( 'profile_facebook' ); ?>" value="<?php echo $instance['profile_facebook']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_twitter' ); ?>"><?php _e('Twitter profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_twitter' ); ?>" name="<?php echo $this->get_field_name( 'profile_twitter' ); ?>" value="<?php echo $instance['profile_twitter']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_plus' ); ?>"><?php _e('Google Plus profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_plus' ); ?>" name="<?php echo $this->get_field_name( 'profile_plus' ); ?>" value="<?php echo $instance['profile_plus']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_pinterest' ); ?>"><?php _e('Pinterest profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_pinterest' ); ?>" name="<?php echo $this->get_field_name( 'profile_pinterest' ); ?>" value="<?php echo $instance['profile_pinterest']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_youtube' ); ?>"><?php _e('YouTube profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_youtube' ); ?>" name="<?php echo $this->get_field_name( 'profile_youtube' ); ?>" value="<?php echo $instance['profile_youtube']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_dribbble' ); ?>"><?php _e('Dribbble profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_dribbble' ); ?>" name="<?php echo $this->get_field_name( 'profile_dribbble' ); ?>" value="<?php echo $instance['profile_dribbble']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_tumblr' ); ?>"><?php _e('Tumblr profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_tumblr' ); ?>" name="<?php echo $this->get_field_name( 'profile_tumblr' ); ?>" value="<?php echo $instance['profile_tumblr']; ?>" style="width:100%;" />

				</p>			

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_instagram' ); ?>"><?php _e('Instagram profile URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_instagram' ); ?>" name="<?php echo $this->get_field_name( 'profile_instagram' ); ?>" value="<?php echo $instance['profile_instagram']; ?>" style="width:100%;" />

				</p>

				

				<p>

					<label for="<?php echo $this->get_field_id( 'profile_rss' ); ?>"><?php _e('RSS Feed URL:', EWF_SETUP_THEME_DOMAIN); ?></label>

					<input id="<?php echo $this->get_field_id( 'profile_rss' ); ?>" name="<?php echo $this->get_field_name( 'profile_rss' ); ?>" value="<?php echo $instance['profile_rss']; ?>" style="width:100%;" />

				</p>

			</div>

			

		<?php

		}

	}





?>