(function($) {

	

	"use strict";

	

/* ==========================================================================

   ieViewportFix - fixes viewport problem in IE 10 SnapMode and IE Mobile 10

   ========================================================================== */

   

	function ieViewportFix() {

	

		var msViewportStyle = document.createElement("style");

		

		msViewportStyle.appendChild(

			document.createTextNode(

				"@-ms-viewport { width: device-width; }"

			)

		);



		if (navigator.userAgent.match(/IEMobile\/10\.0/)) {

			

			msViewportStyle.appendChild(

				document.createTextNode(

					"@-ms-viewport { width: auto !important; }"

				)

			);

		}

		

		document.getElementsByTagName("head")[0].

				appendChild(msViewportStyle);



	}



/* ==========================================================================

   exists - Check if an element exists

   ========================================================================== */		

	

	function exists(e) {

		return $(e).length > 0;

	}



/* ==========================================================================

   isTouchDevice - return true if it is a touch device

   ========================================================================== */



	function isTouchDevice() {

		return !!('ontouchstart' in window) || ( !! ('onmsgesturechange' in window) && !! window.navigator.maxTouchPoints);

	}



/* ==========================================================================

   setDimensionsPieCharts

   ========================================================================== */

	

	function setDimensionsPieCharts() {



		$(".pie-chart").each(function() {



			var $t = $(this);

			var n = $t.parent().width();

			var r = $t.attr("data-barSize");

			

			if (n < r) {

				r = n;

			}

			

			$t.css("height", r);

			$t.css("width", r);

			$t.css("line-height", r + "px");

			

			$t.find("i").css({

				"line-height": r + "px",

				"font-size": r / 3

			});

			

		});



	}



/* ==========================================================================

   animatePieCharts

   ========================================================================== */



	function animatePieCharts() {



		if(typeof $.fn.easyPieChart != 'undefined'){



			$(".pie-chart:in-viewport").each(function() {

	

				var $t = $(this);

				var n = $t.parent().width();

				var r = $t.attr("data-barSize");

				

				if (n < r) {

					r = n;

				}

				

				$t.easyPieChart({

					animate: 1300,

					lineCap: "square",

					lineWidth: $t.attr("data-lineWidth"),

					size: r,

					barColor: $t.attr("data-barColor"),

					trackColor: $t.attr("data-trackColor"),

					scaleColor: "transparent",

					onStep: function(from, to, percent) {

						$(this.el).find('.pie-chart-percent span').text(Math.round(percent));

					}

	

				});

				

			});

			

		}



	}



/* ==========================================================================

   animateMilestones

   ========================================================================== */



	function animateMilestones() {



		$(".milestone:in-viewport").each(function() {

			

			var $t = $(this);

			var	n = $t.find(".milestone-value").attr("data-stop");

			var	r = parseInt($t.find(".milestone-value").attr("data-speed"));

				

			if (!$t.hasClass("already-animated")) {

				$t.addClass("already-animated");

				$({

					countNum: $t.find(".milestone-value").text()

				}).animate({

					countNum: n

				}, {

					duration: r,

					easing: "linear",

					step: function() {

						$t.find(".milestone-value").text(Math.floor(this.countNum));

					},

					complete: function() {

						$t.find(".milestone-value").text(this.countNum);

					}

				});

			}

			

		});



	}



/* ==========================================================================

   animateProgressBars

   ========================================================================== */



	function animateProgressBars() {



		$(".progress-bar .progress-bar-outer:in-viewport").each(function() {

			

			var $t = $(this);

			

			if (!$t.hasClass("already-animated")) {

				$t.addClass("already-animated");

				$t.animate({

					width: $t.attr("data-width") + "%"

				}, 2000);

			}

			

		});



	}



/* ==========================================================================

   enableParallax

   ========================================================================== */



	function enableParallax() {



		if(typeof $.fn.parallax != 'undefined'){

			

			$('.parallax').each(function() {

	

				var $t = $(this);

				$t.addClass("parallax-enabled");

				$t.parallax("49%", 0.3, false);

	

			});

			

		}



	}



/* ==========================================================================

   handleMobileMenu 

   ========================================================================== */		



	var MOBILEBREAKPOINT = 979;



	function handleMobileMenu() {



		if ($(window).width() > MOBILEBREAKPOINT) {

			

			$("#mobile-menu").hide();

			$("#mobile-menu-trigger").removeClass("mobile-menu-opened").addClass("mobile-menu-closed");

		

		} else {

			

			if (!exists("#mobile-menu")) {

				

				$("#menu").clone().attr({

					id: "mobile-menu",

					"class": "fixed"

				}).insertAfter("#header");

				

				$("#mobile-menu > li > a, #mobile-menu > li > ul > li > a").each(function() {

					var $t = $(this);

					if ($t.next().hasClass('sub-menu') || $t.next().is('ul') || $t.next().is('.sf-mega')) {

						$t.append('<span class="fa fa-angle-down mobile-menu-submenu-arrow mobile-menu-submenu-closed"></span>');

					}

				});

			

				$(".mobile-menu-submenu-arrow").click(function(event) {

					var $t = $(this);

					if ($t.hasClass("mobile-menu-submenu-closed")) {

						$t.parent().siblings("ul").slideDown(300);

						$t.parent().siblings(".sf-mega").slideDown(300);

						$t.removeClass("mobile-menu-submenu-closed fa-angle-down").addClass("mobile-menu-submenu-opened fa-angle-up");

					} else {

						$t.parent().siblings("ul").slideUp(300);

						$t.parent().siblings(".sf-mega").slideUp(300);

						$t.removeClass("mobile-menu-submenu-opened fa-angle-up").addClass("mobile-menu-submenu-closed fa-angle-down");

					}

					event.preventDefault();

				});

				

				$("#mobile-menu li, #mobile-menu li a, #mobile-menu ul").attr("style", "");

				

			}

			

		}



	}



/* ==========================================================================

   showHideMobileMenu

   ========================================================================== */



	function showHideMobileMenu() {

		

		$("#mobile-menu-trigger").click(function(event) {

			

			var $t = $(this);

			var $n = $("#mobile-menu");

			

			if ($t.hasClass("mobile-menu-opened")) {

				$t.removeClass("mobile-menu-opened").addClass("mobile-menu-closed");

				$n.slideUp(300);

			} else {

				$t.removeClass("mobile-menu-closed").addClass("mobile-menu-opened");

				$n.slideDown(300);

			}

			event.preventDefault();

			

		});

		

	}



/* ==========================================================================

   When document is ready, do

   ========================================================================== */

   

	$(document).ready(function() {			   

		

		ieViewportFix();

		

		setDimensionsPieCharts();

		

		animatePieCharts();

		animateMilestones();

		animateProgressBars();



		if (!isTouchDevice()) {

			enableParallax();

		}



		

		handleMobileMenu();

		showHideMobileMenu();

		

		//$(window).trigger('resize');

		

	});



/* ==========================================================================

   When the window is scrolled, do

   ========================================================================== */

   

	$(window).scroll(function() {				   

		

		animateMilestones();

		animatePieCharts();

		animateProgressBars();



	});



/* ==========================================================================

   When the window is resized, do

   ========================================================================== */

   

	$(window).resize(function() {

		

		handleMobileMenu();

		

	});

	



})(window.jQuery);



// non jQuery scripts below