<?php

//
//  Custom Child Theme Functions
//

// I've included a "commented out" sample function below that'll add a home link to your menu
// More ideas can be found on "A Guide To Customizing The Thematic Theme Framework" 
// http://themeshaper.com/thematic-for-wordpress/guide-customizing-thematic-theme-framework/

// Add favicon
function childtheme_favicon() { ?>
	<link rel="shortcut icon" href="<?php echo bloginfo('stylesheet_directory') ?>/images/favicon.png" />
<?php }
add_action('wp_head', 'childtheme_favicon');

/* //FOR IE SPECIFIC STYLE SHEET
function childtheme_ie_style() { ?>
	<!--[if IE]>
		<link rel="stylesheet" type="text/css" href="http://www.webdevcat.com/wp-content/themes/webdevcat/ie.css" />
	<![endif]-->
<?php }
add_action('wp_head', 'childtheme_ie_style');
*/




// Add Header Image // Add Header Image
function thematic_logo_image() {
 echo '<a href="'.get_bloginfo('url').'" title="'.get_bloginfo('name').'" ><span id="header-image"></span></a>';
}
add_action('thematic_header','thematic_logo_image',6);

//CHANGE READ MORE TEXT
function childtheme_more_text($content) {
	$content = 'Read More';
	return $content;
}
add_filter('more_text', 'childtheme_more_text');

//REMOVE AUTHOR FROM POSTS
function date_only() {
		global $id, $post, $authordata;

    $postmeta = '<div class="entry-meta">';
    $postmeta .= '<span class="entry-date"><abbr class="published" title="';
    $postmeta .= get_the_time(thematic_time_title()) . '">';
    $postmeta .= get_the_time(thematic_time_display());
    $postmeta .= '</abbr></span>';
    // Display edit link -- uncomment the following 6 lines if you need the edit link

//    if (current_user_can('edit_posts')) {
//    		$posteditlink .= '<a href="' . get_bloginfo('wpurl') . '/wp-admin/post.php?action=edit&amp;post=' . $id;
//    		$posteditlink .= '" title="' . __('Edit post', 'thematic') .'">';
//    		$posteditlink .= __('Edit', 'thematic') . '</a>';
//        $postmeta .= ' <span class="meta-sep">|</span> ' . $posteditlink;
//    }
    $postmeta .= "</div><!-- .entry-meta -->\n";
		return $postmeta;
}
add_filter('thematic_postheader_postmeta', 'date_only');

//GOOGLE ANALYTICS
function ga(){ ?>
	<script type="text/javascript">
	var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
	document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
	</script>
	<script type="text/javascript">
	try {
	var pageTracker = _gat._getTracker("UA-xxxxxxx-xx");
	pageTracker._trackPageview();
	} catch(err) {}</script>
<?php }
add_action('wp_footer', 'ga');


//STICKY FOOTER FOOTER
function sticky() {
?>
<script type="text/javascript">

    jQuery.noConflict();

    jQuery(document).ready(function($){
        matchHeight();
	function matchHeight() {
		var mainHeight = $("#wrapper").outerHeight() - $("#header").outerHeight() - $("#leader").outerHeight() - $("#footer").outerHeight() - parseInt($("#footer").css("margin-top")) - 1 - parseInt($("#main").css("padding-top"))- parseInt($("#main").css("padding-bottom"));
		var mainReal = $("#main").outerHeight(true);

		if ((mainHeight + 1 + parseInt($("#main").css("padding-top")) + parseInt($("#main").css("padding-bottom"))) > mainReal) {
			$('#main').height(mainHeight);
		}
	}
	$(window).resize(matchHeight);
});

</script>

<?php
}
add_action('wp_head', 'sticky');