<?php

/*
WPOnlineBackup_Backup_Email - Sends the backup via PHPMailer
Simply attaches the backup and sends it to the specified address
*/

class WPOnlineBackup_Backup_Email
{
	/*private*/ var $WPOnlineBackup;

	/*private*/ var $bootstrap;
	/*private*/ var $stream;
	/*private*/ var $progress;
	/*private*/ var $job;

	/*private*/ var $PHPMailer;
	/*private*/ var $attachment_path;
	/*private*/ var $attachment_filename;

	/*public*/ function WPOnlineBackup_Backup_Email( & $WPOnlineBackup )
	{
		$this->WPOnlineBackup = & $WPOnlineBackup;

// Need formatting functions here - for Memory_Limit
		require_once WPONLINEBACKUP_PATH . '/include/formatting.php';
	}

	/*public*/ function CleanUp( $ticking = false )
	{
	}

	/*public*/ function Backup( & $bootstrap, & $stream, & $progress, & $job )
	{
// Save variables and send email
		$this->bootstrap = & $bootstrap;
		$this->stream = & $stream;
		$this->progress = & $progress;
		$this->job = & $job;

		return $this->Send_Email();
	}

	/*public*/ function Action_PHPMailer_Init( & $PHPMailer )
	{
// Save the PHPMailer instance, and add the attachment with the filename
		$this->PHPMailer = & $PHPMailer;
		$PHPMailer->AddAttachment( $this->attachment_path, $this->attachment_filename );
	}

	/*private*/ function Send_Email()
	{
		global $wpdb;

// Change the progress message
		if ( $this->job['progress'] == 0 ) {

			$this->progress['message'] = __( 'Sending email...' , 'wponlinebackup');

			$this->job['progress'] = 1;

			$this->bootstrap->Tick();

		}

// Require pluggable.php to define wp_mail
		require_once ABSPATH . 'wp-includes/pluggable.php';

// Check we aren't too big to process. Add 50% to the filesize to allow for MIME encoding and headers etc, and take 5MB from Memory_Limit for processing
		if ( ( $new_size = $this->progress['file_set']['size'] * 2.5 ) > ( $memory_limit = WPOnlineBackup_Formatting::Memory_Limit() ) - 5*1024*1024 ) {

			$this->bootstrap->Log_Event(
				WPONLINEBACKUP_EVENT_ERROR,
				sprintf( __( 'The backup file is %s in size and the amount of memory required to encode this into email format (around %s) will consume most, if not all, of PHP\'s available memory of %s.' , 'wponlinebackup'), WPOnlineBackup_Formatting::Fix_B( $this->progress['file_set']['size'], true ), WPOnlineBackup_Formatting::Fix_B( $new_size, true ), WPOnlineBackup_Formatting::Fix_B( $memory_limit, true ) ) . PHP_EOL .
					'Failed at: ' . __FILE__ . ':' . __LINE__
			);

			return __( 'The backup file is too large to send as an email attachment.' , 'wponlinebackup');

		}

// Save the path to the file to be attached, and generate the filename
		$this->attachment_path = $this->progress['file_set']['file'];
		$this->attachment_filename = preg_replace( '#^(?:.*)backup([^/]*).php$#', 'WPOnlineBackup_Full\\1', $this->progress['file_set']['file'] );

// Hook into the PHPMailer initialisation so we can borrow a reference to PHPMailer and add the attachment to the email with our own filename
		add_action( 'phpmailer_init', array( & $this, 'Action_PHPMailer_Init' ) );

// Prepare the email body
		$body = 'WordPress backup successfully completed.';

// Send the email
		if ( @wp_mail( $this->progress['config']['email_to'], __( 'WordPress backup completed' , 'wponlinebackup'), $body, '' ) === false ) {

			$error = error_get_last();

// Report the error - more information is available in ErrorInfo - use the reference to phpMailer we stole in the hook function
			$this->bootstrap->Log_Event(
				WPONLINEBACKUP_EVENT_ERROR,
				__( 'Failed to send an email containing the backup file.' , 'wponlinebackup') . PHP_EOL .
					'Failed at: ' . __FILE__ . ':' . __LINE__ . PHP_EOL .
					'PHPMailer: ' . ( isset( $this->PHPMailer->ErrorInfo ) ? $this->PHPMailer->ErrorInfo : 'ErrorInfo unavailable' ) . PHP_EOL .
					'PHP: ' . $error['message']
			);

			return __( 'Failed to send an email containing the backup file.' , 'wponlinebackup');

		} else {

			$this->bootstrap->Log_Event(
				WPONLINEBACKUP_EVENT_INFORMATION,
				sprintf( __( 'Successfully emailed the backup to %s.' , 'wponlinebackup'), $this->progress['config']['email_to'] )
			);

		}

// Remove the hook
		remove_action('phpmailer_init', array(& $this, 'phpmailer_init'));

// Cleanup and exit
		$this->attachment_path = '';
		$this->attachment_filename = '';

		$this->job['progress'] = 100;

		return true;
	}
}

?>
