jQuery(function($) {

	WPOnlineBackup_Progress = {

		doInit: function ()
		{
			this.errorCount = 0;
			this.doRefreshNow();
			this.doRefreshNowKS();
		},

		doRefreshWait: function ()
		{
			var obj = this;
			window.setTimeout(
				function ()
				{
					obj.doRefreshNow();
				},
				WPOnlineBackup_Vars.Refresh_Interval * 1000
			);
		},

		doRefreshNow: function ()
		{
			$.ajax({
				cache:		false,
				url:		WPOnlineBackup_Vars.AJAX_URL,
				data:		'action=wponlinebackup_progress',
				dataType:	'json',
				error:		this.doAJAXError,
				success:	this.doAJAXSuccess,
				context:	this,
			});
		},

		doAJAXError: function (XMLHttpRequest, textStatus, errorThrown)
		{
			if ( ++this.errorCount == WPOnlineBackup_Vars.Error_Threshold ) location.reload( true );
			else this.doRefreshWait();
		},

		doAJAXSuccess: function (result, textStatus, XMLHttpRequest)
		{
			if ( !result || result.message === undefined || result.progress === undefined ) {
				this.doAJAXError();
				return;
			}
			this.errorCount = 0;
			if ( result.progress != 100 ) this.doRefreshWait();
			$('#wponlinebackup_message_image').attr( 'src', WPOnlineBackup_Vars.Plugin_URL + '/images/' + result.message[0] );
			$('#wponlinebackup_message_text').text( result.message[1] );
			// Fix jQuery bug - don't let width be 0% - brought about by WordPress 3.1
			if ( result.progress == 0 ) result.progress = 1;
			$('#wponlinebackup_progress_bar').animate( { width: result.progress.toString() + '%' }, WPOnlineBackup_Vars.Refresh_Interval * 250 );
			$('#wponlinebackup_progress_text').text( result.progress.toString() + '%' );
			$('#wponlinebackup_errors').text( result.errors.toString() );
			$('#wponlinebackup_warnings').text( result.warnings.toString() );
			if ( result.progress == 100 ) {
				$('#wponlinebackup_section_backup a')
					.attr( 'href', 'tools.php?page=' + WPOnlineBackup_Vars.Plugin_File + '&section=backup' )
					.text( WPOnlineBackup_Vars.String_Backup )
					.addClass( 'current' );
				$('#wponlinebackup_background_message').animate( { opacity: 0 }, 400 ).slideUp();
				if ( result.target == 'download' && result.message[0] != 'exclamation.png' ) {
					$('#wponlinebackup_completed_size').text( result.size );
					$('#wponlinebackup_completed_message').css( 'opacity', 0 ).slideDown().animate( { opacity: 1 }, 400 );
				}
			}
		},

		doRefreshWaitKS: function ()
		{
			var obj = this;
			window.setTimeout(
				function ()
				{
					obj.doRefreshNowKS();
				},
				WPOnlineBackup_Vars.Kick_Start_Interval * 1000
			);
		},

		doRefreshNowKS: function ()
		{
			$.ajax({
				cache:		false,
				url:		WPOnlineBackup_Vars.AJAX_URL,
				data:		'action=wponlinebackup_kick_start',
				dataType:	'json',
				error:		this.doAJAXErrorKS,
				success:	this.doAJAXSuccessKS,
				context:	this,
			});
		},

		doAJAXErrorKS: function (XMLHttpRequest, textStatus, errorThrown)
		{
			this.doRefreshWaitKS();
		},

		doAJAXSuccessKS: function (result, textStatus, XMLHttpRequest)
		{
			this.doRefreshWaitKS();
		}
	};

	WPOnlineBackup_Progress.doInit();
});
