<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Starkers
 * @since Starkers 3.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 * We filter the output of wp_title() a bit -- see
	 * twentyten_filter_wp_title() in functions.php.
	 */
	wp_title( '|', true, 'right' );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<!-- Style for site -->
<!--[if IE]>
<link rel="stylesheet" type="text/css" media="all" href="http://www.beermanbulldogs.com/wp-content/themes/beermanbulldogs/css/bbstyleIE.css" id="homecss" />
<![endif]-->
<![if !IE]>
<link rel="stylesheet" type="text/css" media="all" href="http://www.beermanbulldogs.com/wp-content/themes/beermanbulldogs/css/bbstyle.css" id="homecss" />
<![endif]>
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js" type="text/javascript"></script>
<script src="<?php bloginfo('template_url'); ?>/js/jquery.validate.pack.js" type="text/javascript"></script>
<script type="text/javascript">
$(document).ready(function(){
	$("#contactform").validate();
});
</script>

<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/swfobject/swfobject.js"></script> 
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
	
<div class="main">  
  <div class="header">    
    <div class="menu">
      <div class="logo"><a href="/"><img src="<?php bloginfo('template_directory'); ?>/images/bk_logo.png" width="197" height="79" border="0" alt="logo" /></a></div>
      <ul>
		 <li<?php if ( is_home() || is_single() || is_search() || is_archive() ) { echo ' id="currentpage"'; } ?>><a href="<?php echo get_option('home'); ?>"><span>Home</span></a></li>
		 <li<?php if ( is_page('41')) { echo ' id="currentpage"'; } ?>><a href="?page_id=41 ">For Sale</a></li>
		 <li<?php if ( is_page('152')) { echo ' id="currentpage"'; } ?>><a href="?page_id=152 ">Planned Breedings</a></li>         
		<!-- <li<?php if ( is_page('10')) { echo ' id="currentpage"'; } ?>><a href="?page_id=10 ">Males</a></li>
		 <li<?php if ( is_page('12')) { echo ' id="currentpage"'; } ?>><a href="?page_id=12 ">Females</a></li>-->
		 <li<?php if ( is_page('86'))  { echo ' id="currentpage"'; } ?>><a href="?page_id=86 ">Gallery</a></li>
		 <li<?php if ( is_page('88'))  { echo ' id="currentpage"'; } ?>><a href="?page_id=201 ">Contact Us</a></li>
      </ul>
      
    </div>
  </div>