<?php
defined( 'ABSPATH' ) || exit();

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * @Class Wpopal_Core_Template_Loader
 * 
 * load overriding template in plugin or theme
 */
class Wpopal_Core_Template_Loader {
 
    /**
     * Gets template path
     *
     * @access public
     * @param $name
     * @param $plugin_dir
     * @return string
     * @throws Exception
     */
    public static function locate( $name, $plugin_dir = WPOPAL_PLUGIN_TEMPLATE_DIR ) {
        $template = '';

        // Current theme base dir
        if ( ! empty( $name ) ) {
            $template = locate_template( "{$name}.php" );
        }

        // Plugin
        if ( ! $template && ! empty( $name ) && file_exists( $plugin_dir . "{$name}.php" ) ) {
            $template = $plugin_dir . "{$name}.php";
        }

        // Nothing found
        if ( empty( $template ) ) {
            throw new Exception( "Template /templates/{$name}.php in plugin dir {$plugin_dir} not found." );
        }


        return $template;
    }


    /**
     * Loads template content
     *
     * @param string $name
     * @param array  $args
     * @param string $plugin_dir
     * @return string
     * @throws Exception
     */
    public static function get_template_part( $name, $args = array(), $plugin_dir = WPOPAL_PLUGIN_TEMPLATE_DIR ) {
        if ( is_array( $args ) && count( $args ) > 0 ) {
            extract( $args, EXTR_SKIP );
        }

        $path = self::locate( $name, $plugin_dir );


        ob_start();
        include $path;
        $result = ob_get_contents();
        ob_end_clean();
        return $result;
    }
}