<?php
/**
 * foodo functions and definitions
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/// admin ///
if( is_admin() ) {
	require get_template_directory() . '/inc/admin/class-menu.php';
	/**
	 * Load include plugins using for this project
	 */
	require get_template_directory() . '/inc/tgm/class-tgm-plugin-activation.php';
	require get_template_directory() . '/inc/tgm.php';
}

/**
 * Initialize theme default settings
 */
require get_template_directory() . '/inc/classes/class-wp-bootstrap-navwalker.php';

/**
 * Initialize theme default settings
 */
require get_template_directory() . '/inc/classes/class-offcanvas.php';


/**
 * Initialize theme default settings
 */
require get_template_directory() . '/inc/customizer.php';


/**
 * Initialize theme default settings
 */
require get_template_directory() . '/inc/functions.php';

/**
 * Initialize theme default settings
 */
require get_template_directory() . '/inc/markup.php';


/**
 * Theme setup and custom theme supports.
 */
require get_template_directory() . '/inc/setup.php';

/**
 * Register widget area.
 */
require get_template_directory() . '/inc/widgets.php';

/**
 * Enqueue scripts and styles.
 */
require get_template_directory() . '/inc/enqueue.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom pagination for this theme.
 */
require get_template_directory() . '/inc/pagination.php';

/**
 * Custom hooks.
 */
require get_template_directory() . '/inc/template-hooks.php';


/**
 * Custom hooks.
 */
require get_template_directory() . '/inc/post-format-functions.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

// load vendors plugin singleton
if( class_exists('WooCommerce')  ){

	/**
	 * If the core feature plugin is not installed and active then load default functions
	 */
	if( !class_exists("Wpopal_Core") ){
		require get_template_directory() . '/inc/vendor/woocommerce/template-functions.php';
	}

	require get_template_directory() . '/inc/vendor/woocommerce/product/class-single-layout.php';
	require get_template_directory() . '/inc/vendor/woocommerce/product/class-loop-layout.php';
	require get_template_directory() . '/inc/vendor/woocommerce-functions.php';
}

function wc_empty_cart_redirect_url() {
	return 'http://buypizzachef.com/shop';
}
add_filter( 'woocommerce_return_to_shop_redirect', 'wc_empty_cart_redirect_url' );

add_filter('add_to_cart_redirect', 'cw_redirect_add_to_cart');
function cw_redirect_add_to_cart() {
    global $woocommerce;
    $cw_redirect_url_checkout = $woocommerce->cart->get_checkout_url();
    return $cw_redirect_url_checkout;
}

add_filter( 'woocommerce_product_single_add_to_cart_text', 'cw_btntext_cart' );
add_filter( 'woocommerce_product_add_to_cart_text', 'cw_btntext_cart' );
function cw_btntext_cart() {
    return __( 'Go To Checkout', 'woocommerce' );
}

function move_tabs(){
  // remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

	// product single page long description *sss*
  // add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 20 );
}
add_action('wp', 'move_tabs');



require get_template_directory() . '/inc/vendor/elementor-functions.php';



remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );



add_action( 'woocommerce_before_shop_loop_item_title', 'custom_function', 10 );


function custom_function(){
    ?>

    <a class="read_more" href="<?php the_permalink();?>">Learn more</a>


<?php
    the_post_thumbnail();
}



add_action('woocommerce_before_main_content','custom_image');
function custom_image(){
   ?>
    <div class="custom_image">
        <div class="shop_text">
            <p>SHOP NOW</p>
        </div>

    </div>


   <?php
}