<?php
/**
 * Left sidebar check.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$left_sidebar  = apply_filters( "foodo_left_sidebar"     , 'left-sidebar' );
$right_sidebar = apply_filters( "foodo_right_sidebar"    , 'right-sidebar' ); 
$sidebar_pos   = apply_filters( "foodo_sidebar_position" , get_theme_mod( 'foodo_sidebar_position' ) ); 

$mcol = 9;
?>
<?php if ( 'left' === $sidebar_pos || 'both' === $sidebar_pos ) :  ?>
	<?php get_template_part( 'partials/sidebar/sidebar', 'left' ); ?>
<?php endif; ?>

<?php
	$html = '';
	if ( 'right' === $sidebar_pos || 'left' === $sidebar_pos ) {
		$html = '<div class="';
		if ( ( is_active_sidebar( $right_sidebar ) && 'right' === $sidebar_pos ) || ( is_active_sidebar( $left_sidebar ) && 'left' === $sidebar_pos ) ) {
			$html .= 'wp-col-xl-'.esc_attr($mcol).' wp-col-md-8 content-area" id="primary">';
		} else {
			$html .= 'wp-col-xl-12 content-area" id="primary">';
		}
		echo trim( $html ); // WPCS: XSS OK.
	} elseif ( 'both' === $sidebar_pos ) {
		$html = '<div class="';
		if ( is_active_sidebar( $right_sidebar ) && is_active_sidebar( $left_sidebar ) ) {
			$html .= 'wp-col-xl-6 wp-col-md-6 content-area" id="primary">';
		} elseif ( is_active_sidebar( $right_sidebar ) || is_active_sidebar( $left_sidebar ) ) {
			$html .= 'wp-col-xl-'.esc_attr($mcol).' wp-col-md-8 content-area" id="primary">';
		} else {
			$html .= 'wp-col-xl-12 content-area" id="primary">';
		}

		echo trim( $html ); // WPCS: XSS OK.
 
	} else {
	    echo '<div class="wp-col-xl-12 content-area" id="primary">';
	}
