<?php
 
/**
 * Generate the CSS for the current primary color.
 */
function foodo_custom_colors_css() {

	$primary_color = "";
	
	if ( 'default' !== get_theme_mod( 'primary_color', 'default' ) ) {
	  	$primary_color = get_theme_mod( 'primary_color_hue', "" );
	}

	$secondary_color = get_theme_mod( 'secondary_color_hue', "" );
  	


	$theme_css = '
		/*
		 * Set background for:
		 * - featured image :before
		 * - featured image :before
		 * - post thumbmail :before
		 * - post thumbmail :before
		 * - Submenu
		 * - Sticky Post
		 * - buttons
		 * - WP Block Button
		 * - Blocks
		 */
		.meta-post-categories .inner, .page-item.active .page-link ,
		.btn-primary, button[type="submit"], a.button, .wpcf7 .wpcf7-form input[type="submit"],
		.elementor-widget-opal-contactform7 .wpcf7 .wpcf7-form input[type="submit"], 
		.elementor-widget-opal-contactform7 button,button.disabled[type=submit],
		.widget_price_filter .ui-slider .ui-slider-range,
		.widget_price_filter .ui-slider .ui-slider-handle,
		button:disabled[type=submit],.page-item .page-link:hover,
		.elementor-opal-slick-slider.elementor-slick-slider .slick-prev,
		.elementor-opal-slick-slider.elementor-slick-slider .slick-next,
		.elementor-widget-opal-button-contact7 a.elementor-button,
		#back-to-top
		{
			background-color: ' . $primary_color . '; /* base: #0073a8; */
		}
		table.compare-list .add-to-cart td a{
			background-color: ' . $primary_color . ' !important;
		}
		.btn-primary, button[type="submit"], a.button, .wpcf7 .wpcf7-form input[type="submit"],button.disabled[type=submit],
		button:disabled[type=submit],.page-item.active .page-link,select:focus{
			border-color:'.$primary_color.';
		}
		/*
		 * Set Color for:
		 * - all links
		 * - main navigation links
		 * - Post navigation links
		 * - Post entry meta hover
		 * - Post entry header more-link hover
		 * - main navigation svg
		 * - comment navigation
		 * - Comment edit link hover
		 * - Site Footer Link hover
		 * - Widget links
		 */
		.breadcrumbs span.current-item,
		swiper-container [class*="swiper-button-"]:hover::before, .swiper-container-horizontal [class*="swiper-button-"]:hover::before,
		.breadcrumbs span.current-item,.post-navigation .nav-links .nav-links-inner a:hover:before,
		.opalelementor-nav-menu > li > .opalelementor-item:focus,
		.hentry .entry-content .foodo-read-more-link,
		.column-sidebar .widget .widget-title,
		.entry-footer .social-share-block a,
		.entry-footer .cat-links, .entry-footer .tags-links, .entry-footer .edit-link,
		h1, h2, h3, h4, h5, h6 ,
		.elementor-widget-counter .elementor-counter-title,
		.widget-service .service-title a, .widget-service .service-readmore a,
		.elementor-widget-opal-team-box .elementor-team-name, .elementor-widget-opal-team-box .elementor-team-name a,
		.work-details h4, .work-details h4 a,
		.portfolio-details-list li label
		{
			color: ' . $primary_color . '; /* base: #0073a8; */
		}
		
		.wpopal-sorting .woo-display-mode a.active svg {
			fill: ' . $primary_color . ' !important;
		}
		/*
		 * Set left border color for:
		 * wp block quote
		 */
		blockquote,
		.woocommerce-tabs blockquote,
		.entry .entry-content blockquote,
		.entry .entry-content .wp-block-quote:not(.is-large),
		.entry .entry-content .wp-block-quote:not(.is-style-large) {
			border-left-color: ' . $primary_color . '; /* base: #0073a8; */
		}';
	if( $secondary_color  )  {


		$theme_css .= '	
			.load-more-wrap a:hover,
			.btn-primary:hover, button:hover[type="submit"], a.button:hover, .wpcf7 .wpcf7-form input:hover[type="submit"],
			.single-product div.product form.cart .quantity-box .minus:hover,.single-product div.product form.cart .quantity-box .plus:hover,
			button:not(:disabled):not(.disabled):active,
			.btn-secondary:not(:disabled):not(.disabled):active,
			primary:not(:disabled):not(.disabled):active,
			.btn-primary:not(:disabled):not(.disabled):active,.single-product div.product form.cart .quantity-box .plus:focus,
			.single-product div.product form.cart .quantity-box .minus:focus,.yith-woocompare-widget a.compare:hover,
			.elementor-opal-slick-slider.elementor-slick-slider .slick-prev:hover,.elementor-opal-slick-slider.elementor-slick-slider .slick-next:hover,
			.elementor-widget-opal-button-contact7 .elementor-button:hover,
			#back-to-top:hover
			{
				background-color:'.$secondary_color.'
			}	
			/*
			 * Set border color for:
			 * :focus
			 */
			table.compare-list .add-to-cart td a:hover{
				background-color: ' .$secondary_color. ' !important;
			}
			.btn-primary:hover, 
			button:hover[type="submit"], a.button:hover, .wpcf7 .wpcf7-form input:hover[type="submit"] ,.load-more-wrap a:hover,
			.single-product div.product .woocommerce-product-gallery .flex-control-thumbs li img.flex-active,
			input[type="text"]:focus,
			input[type="email"]:focus,
			input[type="url"]:focus,
			input[type="password"]:focus,
			input[type="search"]:focus,
			input[type="number"]:focus,
			input[type="tel"]:focus,
			input[type="range"]:focus,
			input[type="date"]:focus,
			input[type="month"]:focus,
			input[type="week"]:focus,
			input[type="time"]:focus,
			input[type="datetime"]:focus,
			input[type="datetime-local"]:focus,
			input[type="color"]:focus,
			a.button:not(:disabled):not(.disabled):active,
			button:not(:disabled):not(.disabled):active[type=submit],
			swiper-container [class*="swiper-button-"]:hover::before, .swiper-container-horizontal [class*="swiper-button-"]:hover::before,
			.btn-secondary:not(:disabled):not(.disabled):active,
			.btn-primary:not(:disabled):not(.disabled):active,.post-navigation .nav-links .nav-links-inner a:hover:before,
			.entry-footer .social-share-block a:hover{
				border-color: ' . $secondary_color . '; /* base: #0073a8; */
			}
			textarea:focus{
				border-color: ' . $secondary_color . ' !important;
			}
			.gallery-item > div > a:focus{
				box-shadow:' . $secondary_color . '; /* base: #0073a8; */
			}

			/* Hover colors */
			.entry-meta-list li a:hover,.breadcrumbs a:hover,
			a:hover, a:active,
			.widget-area .widget a:not(.button):hover,
			.main-navigation .main-menu > li > a:hover,
			.main-navigation .main-menu > li > a:hover + svg,
			.post-navigation .nav-links a:hover,
			.post-navigation .nav-links a:hover .post-title,
			.author-bio .author-description .author-link:hover,
			.comment .comment-author .fn a:hover,
			.comment-reply-link:hover,
			.comment-navigation .nav-previous a:hover,
			.comment-navigation .nav-next a:hover,
			#cancel-comment-reply-link:hover,
			.wpopal-button-actions .yith-wcqv-button:hover::before, .wpopal-button-actions .show a:hover::before, .wpopal-button-actions .compare:hover::before,
			.widget a:hover,a.button:not(:disabled):not(.disabled):active,
			.entry-footer .tags-links a:hover, .entry-footer .edit-link a:hover
			 {
				color:' . $secondary_color . '; /* base: #005177; */
			}
			.widget_shopping_cart .buttons a:hover{
				color:#FFF;
			}

		';
	}	
	/**
	 * Filters foodo custom colors CSS.
	 *
	 * @since Twenty Nineteen 1.0
	 *
	 * @param string $css           Base theme colors CSS.
	 * @param int    $primary_color The user's selected color hue.
	 * @param string $saturation    Filtered theme color saturation level.
	 */
	return apply_filters( 'foodo_custom_colors_css', $theme_css, $primary_color );
}