<?php
/**
 * foodo Theme Customizer
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Bind JS handlers to instantly live-preview changes.
 */
function foodo_customize_preview_js() {  
	wp_enqueue_script( 'foodo-customize-preview', get_theme_file_uri( '/assets/js/customize-preview.js' ), array( 'customize-preview' ), '20181108', true );
}
add_action( 'customize_preview_init', 'foodo_customize_preview_js' , 99);

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
if ( ! function_exists( 'foodo_customize_register' ) ) {
	/**
	 * Register basic customizer support.
	 *
	 * @param object $wp_customize Customizer reference.
	 */
	function foodo_customize_register( $wp_customize ) {
		$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
		$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
		$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';


		$wp_customize->remove_section( 'fl-presets' );  //Modify this line as needed  
		

		/**
		 * Primary color.
		 */
		$wp_customize->add_setting(
			'primary_color',
			array(
				'default'           => 'default',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'primary_color',
			array(
				'type'     => 'radio',
				'label'    => esc_html__( 'Primary Color', 'foodo' ),
				'choices'  => array(
					'default'  => esc_html_x( 'Default', 'primary color', 'foodo' ),
					'custom' => esc_html_x( 'Custom', 'primary color', 'foodo' ),
				),
				'section'  => 'color_style_theme',
				'priority' => 5,
			)
		);

		
		// Add primary color hue setting and control.
		$wp_customize->add_setting(
			'primary_color_hue',
			array(
				'default'           => "",
				'transport'         => 'postMessage',
				'sanitize_callback' => 'maybe_hash_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'primary_color_hue',
				array(
					'label'       => esc_html__( 'Primary Color', 'foodo' ),
					'description' => esc_html__( 'Apply a custom color for buttons, links, featured images, etc.', 'foodo' ),
					'section'     => 'color_style_theme',
					
				)
			)
		);

		// Add primary color hue setting and control.
		$wp_customize->add_setting(
			'secondary_color_hue',
			array(
				'default'           => "",
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'secondary_color_hue',
				array(
					'label'       => esc_html__( 'Secondary Color', 'foodo' ),
					'description' => esc_html__( 'Apply a custom color for buttons, links, featured images, etc.', 'foodo' ),
					'section'     => 'color_style_theme',
					
				)
			)
		);

		// Add primary color hue setting and control.
		$wp_customize->add_setting(
			'body_color_hue',
			array(
				'default'           => "",
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'body_color_hue',
				array(
					'label'       => esc_html__( 'Body Color', 'foodo' ),
					'section'     => 'color_style_theme',
					
				)
			)
		);
		
	}
}
add_action( 'customize_register', 'foodo_customize_register' );

/**
 * Select sanitization function
 *
 * @param string               $input   Slug to sanitize.
 * @param WP_Customize_Setting $setting Setting instance.
 * @return string Sanitized slug if it is a valid choice; otherwise, the setting default.
 */
function foodo_theme_slug_sanitize_select( $input, $setting ){

		// Ensure input is a slug (lowercase alphanumeric characters, dashes and underscores are allowed only).
		$input = sanitize_key( $input );

		// Get the list of possible select options.
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it; otherwise, return the default.
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );                

}

/**
 * Register individual settings through customizer's API.
 *
 * @param WP_Customize_Manager $wp_customize Customizer reference.
 */
if ( ! function_exists( 'foodo_theme_layout_customizer' ) ) {

	function foodo_theme_layout_customizer( $wp_customize ){  

		$wp_customize->add_panel( 'layout', array(
            'title'          => esc_html__( 'Layout', 'foodo' ),
            'capability'     => 'edit_theme_options',
            'priority'       => 1,
        ));

        // Theme layout settings.
		$wp_customize->add_section( 'layout_theme', array(
			'title'       => esc_html__( 'Theme', 'foodo' ),
			'capability'  => 'edit_theme_options',
			'description' => esc_html__( 'Set layout global theme layout style', 'foodo' ),
			'priority'    => 3,
			'panel'		  => 'layout'
		) );

		///

		$wp_customize->add_setting( 'foodo_layout_style', array(
			'default'           => 'default',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
		) );

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'foodo_layout_style', array(
					'label'       => esc_html__( 'Global Layout Style', 'foodo' ),
					'description' => esc_html__( 'Set global layout style boxed or fullwidth having custom background image, custom width.',
					'foodo' ),
					'section'     => 'layout_theme',
					'settings'    => 'foodo_layout_style',
					'type'        => 'select',
					'choices'     => array(
						'default' 	  =>  esc_html__( 'Default', 'foodo' ),
						'boxed'   	=>  esc_html__( 'Boxed', 'foodo' ),
 
					),
					'priority'    => '2',
				)
		) );

	}	
}
add_action( 'customize_register', 'foodo_theme_layout_customizer' );
    	
/**
 * Register individual settings through customizer's API.
 *
 * @param WP_Customize_Manager $wp_customize Customizer reference.
 */    	
if ( ! function_exists( 'foodo_post_layout_customize_register' ) ) {
	
	function foodo_post_layout_customize_register( $wp_customize ) {

		 
		// Theme layout settings.
		$wp_customize->add_section( 'foodo_blog_options', array(
			'title'       => esc_html__( 'Post Settings', 'foodo' ),
			'capability'  => 'edit_theme_options',
			'description' => esc_html__( 'Set blog layout display in varials style and design', 'foodo' ),
			'priority'    => 3,
		) );

		

		$wp_customize->add_setting( 'foodo_sidebar_position', array(
			'default'           => 'right',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
		) );

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'foodo_sidebar_position', array(
					'label'       => esc_html__( 'Archive Sidebar Positioning', 'foodo' ),
					'description' => esc_html__( 'Set sidebar\'s default position. Can either be: right, left, both or none. Note: this can be overridden on individual pages.',
					'foodo' ),
					'section'     => 'foodo_blog_options',
					'settings'    => 'foodo_sidebar_position',
					'type'        => 'select',
					'sanitize_callback' => 'foodo_theme_slug_sanitize_select',
					'choices'     => array(
						'right' => esc_html__( 'Right sidebar', 'foodo' ),
						'left'  => esc_html__( 'Left sidebar', 'foodo' ),
						'both'  => esc_html__( 'Left & Right sidebars', 'foodo' ),
						'none'  => esc_html__( 'No sidebar', 'foodo' ),
					),
					'priority'    => '2',
				)
		) );

		// single blog post

		/// // 
		$wp_customize->add_setting( 'foodo_blog_archive_layout', array(
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
		) );

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'foodo_blog_archive_layout', array(
					'label'       => esc_html__( 'Blog Archive layout', 'foodo' ),
					'description' => esc_html__( 'Set sidebar\'s default position. Can either be: right, left, both or none. Note: this can be overridden on individual pages.',
					'foodo' ),
					'section'     => 'foodo_blog_options',
					'settings'    => 'foodo_blog_archive_layout',
					'type'        => 'select',
					'sanitize_callback' => 'foodo_theme_slug_sanitize_select',
					'choices'     => foodo_get_blog_item_layouts(),
					'priority'    => '3',
				)
		) );
		/////// ///

		$wp_customize->add_setting( 'foodo_sidebar_single_position', array(
			'default'           => 'right',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
		) );

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'foodo_sidebar_single_position', array(
					'label'       => esc_html__( 'Single Sidebar Position', 'foodo' ),
					'description' => esc_html__( 'Set sidebar\'s default position. Can either be: right, left, both or none. Note: this can be overridden on individual pages.',
					'foodo' ),
					'section'     => 'foodo_blog_options',
					'settings'    => 'foodo_sidebar_single_position',
					'type'        => 'select',
					'sanitize_callback' => 'foodo_theme_slug_sanitize_select',
					'choices'     => array(
						'right' => esc_html__( 'Right sidebar', 'foodo' ),
						'left'  => esc_html__( 'Left sidebar', 'foodo' ),
						'both'  => esc_html__( 'Left & Right sidebars', 'foodo' ),
						'none'  => esc_html__( 'No sidebar', 'foodo' ),
					),
					'priority'    => '20',
				)
		) );
		// sidebar 
		$wp_customize->add_setting( 'foodo_blog_single_layout', array(
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
		) );

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'foodo_blog_single_layout', array(
					'label'       => esc_html__( 'Single Layout', 'foodo' ),
					'description' => esc_html__( 'Set single layout in view single post.',
					'foodo' ),
					'section'     => 'foodo_blog_options',
					'settings'    => 'foodo_blog_single_layout',
					'type'        => 'select',
					'sanitize_callback' => '',
					'choices'     => array(
						'' 			=> esc_html__( 'Basic Style', 'foodo' ),
						'blog'  	=> esc_html__( 'Style 1', 'foodo' )
					),
					'priority'    => '22',
				)
		) );

		// enable product category 
		$wp_customize->add_setting(
			'foodo_post_related', array(
				'default'               => false,
				'sanitize_callback'     => 'wp_validate_boolean',
			)
		);

		$wp_customize->add_control(
			'foodo_post_related', array(
				'type'                  => 'checkbox',
				'section'               => 'foodo_blog_options',
				'label'                 => esc_html__( 'Enale Post Related', 'foodo' ),
				'description'           => esc_html__( 'Show post related by category.', 'foodo' ),
				'priority'              => 2,
			)
		);

		/// / / /
		$wp_customize->add_setting(
			'foodo_blog_columns',
			array(
				'default'              => 1,
				'type'              => 'theme_mod',
				'sanitize_callback'    => 'absint',
				'sanitize_js_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			'foodo_blog_columns',
			array(
				'label'       => esc_html__( 'Blog per row', 'foodo' ),
				'description' => esc_html__( 'How many products should be shown per row?', 'foodo' ),
				'section'     => 'foodo_blog_options',
				'settings'    => 'foodo_blog_columns',
				'type'        => 'number',
				'input_attrs' => array(
					'min'  => 1,
					'max'  => 5,
					'step' => 1,
				),
			)
		);


		/// enable or disable preloader 
	}
} // endif function_exists( 'foodo_theme_customize_register' ).
add_action( 'customize_register', 'foodo_post_layout_customize_register' );

/**
 * Add customizer configuration for page preloader
 */
if ( ! function_exists ( 'foodo_customize_preloader' ) ) {
	function foodo_customize_preloader( $wp_customize ){
		
		// Theme layout settings.
		$wp_customize->add_panel( 'layout_options', array(
			'title'       => esc_html__( 'Preloader', 'foodo' ),
			'capability'  => 'edit_theme_options',
			'description' => esc_html__( 'Set blog layout display in varials style and design', 'foodo' ),
			'priority'    => 2
		) );


		// Theme layout settings.
		$wp_customize->add_section( 'container_options', array(
			'title'       => esc_html__( 'Page Container', 'foodo' ),
			'capability'  => 'edit_theme_options',
			'description' => esc_html__( 'Set blog layout display in varials style and design', 'foodo' ),
			'priority'    => 2,
			'panel'		  => 'layout_options'
		) );

		$wp_customize->add_setting( 'foodo_container_type', array(
				'default'           => 'container',
				'type'              => 'theme_mod',
				'sanitize_callback' => 'foodo_theme_slug_sanitize_select',
				'capability'        => 'edit_theme_options',
			) );

		$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'foodo_container_type', array(
				'label'       => esc_html__( 'Container Width', 'foodo' ),
				'description' => esc_html__( 'Choose between Bootstrap\'s container and container-fluid', 'foodo' ),
				'section'     => 'container_options',
				'settings'    => 'foodo_container_type',
				'type'        => 'select',
				'choices'     => array(
					'container'       => esc_html__( 'Fixed width container', 'foodo' ),
					'container-fluid' => esc_html__( 'Full width container', 'foodo' ),
				),
				'priority'    => '1',
			)
		) );

		// Theme layout settings.
		$wp_customize->add_section( 'preload_layout_options', array(
			'title'       => esc_html__( 'Page Preloader', 'foodo' ),
			'capability'  => 'edit_theme_options',
			'description' => esc_html__( 'Set blog layout display in varials style and design', 'foodo' ),
			'priority'    => 2,
			'panel'		  => 'layout_options'
		) );

		////

		$wp_customize->add_setting( 'foodo_preload_logo', array(
				'default'           => '',
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'capability'        => 'edit_theme_options',
		) );
		
		$wp_customize->add_control(
	       new WP_Customize_Image_Control(
	           $wp_customize,
	           'foodo_preload_logo',
	           array(
	               'label'      => esc_html__( 'Upload a logo', 'foodo' ),
	               'section'    => 'preload_layout_options',
	               'settings'   => 'foodo_preload_logo'
	           )
	       )
	   );

		///
		$wp_customize->add_setting( 'foodo_preload_svg', array(
				'default'           => '',
				'type'              => 'theme_mod',
				'sanitize_callback' => 'sanitize_text_field',
				'capability'        => 'edit_theme_options',
		) );

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'foodo_preload_svg', array(
					'label'       => esc_html__( 'Svg Icon', 'foodo' ),
					'description' => esc_html__( 'Select preloading icon showing on center of the panel',
					'foodo' ),
					'section'     => 'preload_layout_options',
					'settings'    => 'foodo_preload_svg',
					'type'        => 'select',
					'sanitize_callback' => 'foodo_theme_slug_sanitize_select',
					'choices'     => foodo_svg_in_folders( 'loaders' ),
					'priority'    => '3',
				)
		) );
		
		// Add page background color setting and control.
		$wp_customize->add_setting( 'foodo_preload_bg', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'foodo_preload_bg', array(
			'label'       => esc_html__( 'Page Background Color', 'foodo' ),
			'section'     => 'preload_layout_options',
		) ) );
		//


		// Add page background color setting and control.
		$wp_customize->add_setting( 'foodo_preload_svgcolor', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'foodo_preload_svgcolor', array(
			'label'       => esc_html__( 'Svg Icon Color', 'foodo' ),
			'section'     => 'preload_layout_options',
		) ) );
	}
}
add_action( 'customize_register', 'foodo_customize_preloader' );

/**
 * Automatic set default values for postion and style, containner width after active the theme.
 */
if ( ! function_exists ( 'foodo_setup_theme_default_settings' ) ) {
	function foodo_setup_theme_default_settings() {

		// check if settings are set, if not set defaults.
		// Caution: DO NOT check existence using === always check with == .
		// Latest blog posts style.
		$foodo_posts_index_style = get_theme_mod( 'foodo_posts_index_style' );
		if ( '' == $foodo_posts_index_style ) {
			set_theme_mod( 'foodo_posts_index_style', 'default' );
		}

		// Sidebar position.
		$foodo_sidebar_position = get_theme_mod( 'foodo_sidebar_position' );
		if ( '' == $foodo_sidebar_position ) {
			set_theme_mod( 'foodo_sidebar_position', 'right' );
		}

		// Sidebar position.
		$foodo_sidebar_single_position = get_theme_mod( 'foodo_sidebar_single_position' );
		if ( '' == $foodo_sidebar_single_position ) {
			set_theme_mod( 'foodo_sidebar_single_position', 'right' );
		}
		
		// Container width.
		$foodo_container_type = get_theme_mod( 'foodo_container_type' );
		if ( '' == $foodo_container_type ) {
			set_theme_mod( 'foodo_container_type', 'container' );
		}

		
	}
}
?>
