<?php
/**
 * Theme basic setup.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

add_action( 'after_setup_theme', 'foodo_setup' );

if ( ! function_exists ( 'foodo_setup' ) ) {
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function foodo_setup() {
		
		add_theme_support( 'custom-header', array(
		    'wp-head-callback' => '',
		    'admin-head-callback' => '',
		    'admin-preview-callback' => '',
		) );

		add_theme_support( 'woocommerce' );
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on foodo, use a find and replace
		 * to change 'foodo' to the name of your theme in all the template files
		 */
		load_theme_textdomain( 'foodo', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary Menu', 'foodo' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		/*
		 * Adding Thumbnail basic support
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Adding support for Widget edit icons in customizer
		 */
		add_theme_support( 'customize-selective-refresh-widgets' );


		add_editor_style( 'style-editor.css' );

		/*
         * Enable support for Post Formats.
         * See https://codex.wordpress.org/Post_Formats
         */  
        add_theme_support( 'post-formats', array(
            'aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery',
        ) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'foodo_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Set up the WordPress Theme logo feature.
		add_theme_support( 'custom-logo' );

		/**
		 * Define image size thumbs
		 */
		add_image_size( 'foodo-post-grid', 500, 338, true );
		add_image_size( 'foodo-post-list', 1024, 692, true );

		// Check and setup theme default settings.
		foodo_setup_theme_default_settings();

	}
}
if ( ! function_exists( 'foodo_import_attachment_image_size' ) ) {
	/**
	 * Matching and resizing images with url.
	 *
	 *  $ouput = array(
	 *        'allowed' => 1, // allow resize images via using GD Lib php to generate image
	 *        'height'  => 900,
	 *        'width'   => 800,
	 *        'file_name' => 'blog_demo.jpg'
	 *   ); 
	 */
	function foodo_import_attachment_image_size( $url ){  

	   $name = basename( $url );   

	   $output = array(
	         'allowed' => 0
	   );     

 
	   if( preg_match("#team-#", $name) ) {
			$output = array(
				'allowed' => 1,
				'height'  => 500,
				'width'   => 630,
				'file_name' => $name
			); 
	   }

	   if( preg_match("#gallery-#", $name) ) {
			$output = array(
				'allowed' => 1,
				'height'  => 560,
				'width'   => 390,
				'file_name' => $name
			); 
	   }

	   return $output;
	}
}
add_action( 'wpopal_import_attachment_image_size', 'foodo_import_attachment_image_size', 1, 2 );

////////

add_filter( 'excerpt_more', 'foodo_custom_excerpt_more' );

if ( ! function_exists( 'foodo_custom_excerpt_more' ) ) {
	/**
	 * Removes the ... from the excerpt read more link
	 *
	 * @param string $more The excerpt.
	 *
	 * @return string
	 */
	function foodo_custom_excerpt_more( $more ) {
		return '';
	}
}

add_filter( 'wp_trim_excerpt', 'foodo_all_excerpts_get_more_link' );

if ( ! function_exists( 'foodo_all_excerpts_get_more_link' ) ) {
	/**
	 * Adds a custom read more link to all excerpts, manually or automatically generated
	 *
	 * @param string $post_excerpt Posts's excerpt.
	 *
	 * @return string
	 */
	function foodo_all_excerpts_get_more_link( $post_excerpt ) {

		return $post_excerpt . ' <p><a class="btn btn-primary foodo-read-more-link" href="' . esc_url( get_permalink( get_the_ID() )) . '">' . esc_html__( 'Read More...',
		'foodo' ) . '</a></p>';
	}
}
