<?php
/**
 * Custom hooks.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function foodo_add_layout_style_option_body_class( $classes ){
    if( get_theme_mod('foodo_layout_style') == 'boxed' ) {
        $classes[] = 'layout-boxed';
    }
    return $classes;
}

add_filter( 'body_class' , 'foodo_add_layout_style_option_body_class' );


if( function_exists("wpopal_social_share_post") ){
    add_action( "foodo_single_entry_footer_after", "wpopal_social_share_post" );
}

/**
 * Display related posts in single post page
 */
add_action( 'foodo_content_single_after', 'foodo_post_related', 2 );

function foodo_post_related () {

    if( get_theme_mod('foodo_post_related') ){
        echo foodo_post_related_html( 6, 'post', 'category' );
    }
}


// Comments form.
add_filter( 'comment_form_default_fields', 'foodo_bootstrap_comment_form_fields' );

/**
 * Creates the comments form.
 *
 * @param string $fields Form fields.
 *
 * @return array
 */
if ( ! function_exists( 'foodo_bootstrap_comment_form_fields' ) ) {

  function foodo_bootstrap_comment_form_fields( $fields ) {
    $commenter = wp_get_current_commenter();
    $req       = get_option( 'require_name_email' );
    $aria_req  = ( $req ? " aria-required='true'" : '' );
    $html5     = current_theme_supports( 'html5', 'comment-form' ) ? 1 : 0;
    $consent  = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';
    $fields    = array(
      'author'  => '<div class="row">'. '<div class="wp-col-xl-4"><div class="form-group comment-form-author"><label for="author">' . esc_html__( 'Name',
          'foodo' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                  '<input class="form-control" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . esc_attr($aria_req) . '></div></div>',
      'email'   => '<div class="wp-col-xl-4"><div class="form-group comment-form-email"><label for="email">' . esc_html__( 'Email',
          'foodo' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                  '<input class="form-control" id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30"' . esc_attr($aria_req) . '></div></div>',
      'url'     => '<div class="wp-col-xl-4"><div class="form-group comment-form-url"><label for="url">' . esc_html__( 'Website',
          'foodo' ) . '</label> ' .
                  '<input class="form-control" id="url" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30"></div></div>'.'</div>',

      'cookies' => '<div class="form-group form-check comment-form-cookies-consent"><input class="form-check-input" id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . esc_attr($consent) . ' /> ' .
               '<label class="form-check-label" for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment', 'foodo' ) . '</label></div>',
    );

    return $fields;
  }
} // endif function_exists( 'foodo_bootstrap_comment_form_fields' )

add_filter( 'comment_form_defaults', 'foodo_bootstrap_comment_form' );

/**
 * Builds the form.
 *
 * @param string $args Arguments for form's fields.
 *
 * @return mixed
 */

if ( ! function_exists( 'foodo_bootstrap_comment_form' ) ) {

  function foodo_bootstrap_comment_form( $args ) {
    $args['comment_field'] = '<div class="form-group comment-form-comment">
      <label for="comment">' . esc_html_x( 'Comment', 'noun', 'foodo' ) . ( ' <span class="required">*</span>' ) . '</label>
      <textarea class="form-control" id="comment" name="comment" aria-required="true" cols="45" rows="8"></textarea>
      </div>';
    $args['class_submit']  = 'btn btn-primary'; // since WP 4.1.
    return $args;
  }
} // endif function_exists( 'foodo_bootstrap_comment_form' )

function foodo_blog_columns_class( $colclss ) {

    $col = get_theme_mod( 'foodo_blog_columns' );

    if( $col ) {
        $col = floor(12/$col);

        return "wp-col-md-".$col.' wp-col-sm-6 ';
    }

    return $colclss;
}
add_filter( 'foodo_blog_columns_class', 'foodo_blog_columns_class' );


/**
 * Add Preloader Page animation
 */

add_action( 'foodo_before_header', 'foodo_page_preloader' );
function foodo_page_preloader(){

  $bg    = get_theme_mod( 'foodo_preload_bg' );
  $svg   = get_theme_mod( 'foodo_preload_svg' );
  $color = get_theme_mod( 'foodo_preload_svgcolor' );
  $img   = get_theme_mod(  'foodo_preload_logo' );
  $style = array() ;
  $classes = array();

  if( $bg ){
      $style[] = 'background-color:'.$bg;
  }
  $classes[] = 'page-loading clearfix';

  if( is_customize_preview() ){
      $classes[] = 'is-preview';
  }
  $svg =  $svg ?  'loaders/'.$svg : 'loaders/'.'audio';
  $color = $color ? $color : '#000';
?>
    <div id="page-preloader" <?php if( $style ): ?> style="<?php echo implode( " ;", $style ); ?>" <?php endif; ?> class="<?php echo implode( " ", $classes ); ?>">
      <div class="page-load-inner">

          <div class="preloader-content">
              <?php if(  $img ): ?>
              <div class="preloader-img"><img alt="image-text" src="<?php echo esc_attr($img); ?>"></div>
             <?php endif; ?>
              <div class="preloader-icon"><img alt="icon" src="<?php echo foodo_get_svg(  $svg, $color ); ?>"></div>
          </div>
      </div>
    </div>
<?php }
/**
  * Display header block layout
  */
  add_action( 'foodo_header', 'foodo_header' );
  function foodo_header (){
      get_template_part( 'partials/header/default' );
  }

/**
* Display footer block layout
*/
add_action( 'foodo_footer', 'foodo_footer' );
function foodo_footer(){
    get_template_part( 'partials/footer/default' );
}

/// back to top
add_action( 'wp_footer', 'foodo_back_to_top' );
function foodo_back_to_top(){
    echo '<a href="#" id="back-to-top"><i class="fa fa-hand-o-up"></i>'. esc_html__('To top', 'foodo').'</a>';
}

/**
 * Breadcrumb NavXT Compatibility.
 */


add_action( 'foodo_before_site_content' , 'foodo_breadcrumb' );
function foodo_breadcrumb( $post_id = null ) {
    $cssBreadcrumbs            = '';
    $breadcrumbs_bg_color      = ( $breadcrumbs_bg_color = get_post_meta( get_the_ID(), 'layout_options_bcn_bgc', 1 ) ) ? $breadcrumbs_bg_color : get_theme_mod( 'layout_options_bcn_bgc' );
    $breadcrumbs_bg_image      = ( $breadcrumbs_bg_image = get_post_meta( get_the_ID(), 'layout_options_bcn_bg', 1 ) ) ? $breadcrumbs_bg_image : get_theme_mod( 'layout_options_bcn_bg' );
    $breadcrumb_padding_top    = ( $breadcrumb_padding_top = get_post_meta( get_the_ID(), 'layout_options_bcn_pt', 1 ) ) ? $breadcrumb_padding_top : get_theme_mod( 'layout_options_bcn_pt');
    $breadcrumb_padding_bottom = ( $breadcrumb_padding_bottom = get_post_meta( get_the_ID(), 'layout_options_bcn_pb', 1 ) ) ? $breadcrumb_padding_bottom : get_theme_mod( 'layout_options_bcn_pb');
    if (!empty( $breadcrumbs_bg_color )){
        $cssBreadcrumbs .= "background-color: {$breadcrumbs_bg_color};";
    }

    if (!empty( $breadcrumbs_bg_image )){
        $cssBreadcrumbs .= "background-image: url({$breadcrumbs_bg_image});";
    }

    if (!empty( $breadcrumb_padding_top )){
        $cssBreadcrumbs .= "padding-top: {$breadcrumb_padding_top}px;";
    }

    if (!empty( $breadcrumb_padding_bottom )){
        $cssBreadcrumbs .= "padding-bottom: {$breadcrumb_padding_bottom}px;";
    }
    if ( ! $post_id ) {
        if ( is_page() ) {
            $post_id = get_the_ID();
        }
    }
    if ( $post_id ) {
        $hb = get_post_meta( $post_id, 'osf_hide_breadcrumb', true);

        if (  $hb != "" &&   $hb  == 0 ) {
            return;
        }
        $slug = get_post_field( 'post_name', $post_id );

        if( preg_match( "#home#", $slug) ){
            return true;
        }
    } else if( is_404() ) {
        return true;
    }

    if ( function_exists('bcn_display') ) {
        ?>
        <div class="breadcrumbs a" typeof="BreadcrumbList" vocab="http://schema.org/">
            <div class="container">
                <div class="breadcrumbs_title">
                    <?php foodo_breadcrumb_title(); ?>
                </div>
                <?php bcn_display(); ?>
            </div>
        </div>
        <?php
    } else { ?>
      <div class="breadcrumbs b" typeof="BreadcrumbList" vocab="http://schema.org/">
            <div class="container">
                <div class="breadcrumbs_title">
                    <?php foodo_breadcrumb_title(); ?>
                </div>
                <?php  get_template_part('partials/common/breadcrumb');  ?>
            </div>
      </div>
    <?php }
}

if ( ! function_exists( 'foodo_breadcrumb_title' ) ) {
    function foodo_breadcrumb_title() {
        global $post;
        $shop_title = esc_html__('Shop', 'foodo');
        $wbt_title  = esc_html__( 'Blog', 'foodo' );
        $otf_args = '';

        if (!is_front_page()){
            if (function_exists('is_shop') && is_shop()) {
                $wbt_title = $shop_title;
            }
            if (is_home()){

            }else{
                if (is_single()){
                    $wbt_title = get_the_title();
                }else{
                    if (is_archive() && is_tax() && !is_category() && !is_tag()){
                        $tax_object = get_queried_object();
                        if (!empty( $tax_object )){
                            $wbt_title  = esc_html( $tax_object->name );
                        }
                    }else{
                        if(is_category()){
                            $wbt_title  = single_cat_title( '', false );
                        }else{
                            if (is_page()){
                                $wbt_title  = get_the_title();
                            }
                            if (is_tag()){

                                // Get tag information
                                $wbt_term_id  = get_query_var( 'tag_id' );
                                $wbt_taxonomy = 'post_tag';
                                $wbt_args     = 'include=' . $wbt_term_id;
                                $wbt_terms    = get_terms( $wbt_taxonomy, $otf_args );

                                // Display the tag name
                                if (isset( $wbt_terms[0]->name )){
                                    $wbt_title  = $wbt_terms[0]->name;
                                }
                            }
                            if (is_day()){
                                $wbt_title = esc_html__( 'Day', 'foodo' );
                            }else{
                                if (is_month()){
                                    $wbt_title = esc_html__( 'Month', 'foodo' );
                                }else{
                                    if (is_year()){
                                        $wbt_title = esc_html__( 'Year', 'foodo' );
                                    }else{
                                        if (is_author()){
                                            global $author;
                                            if(!empty($author->ID)){
                                                $wbt_title  = esc_html__( 'Author', 'foodo' );
                                            }
                                        }else{
                                            if (is_search()){
                                                $wbt_title = esc_html__( 'Search', 'foodo' );
                                            }elseif (is_404()){
                                                $wbt_title = esc_html__( 'Error 404', 'foodo' );
                                            }
                                        }
                                    }
                                }
                            }

                        }
                    }
                }
            } ?>

            <?php
        }

        ?>
        <h1 class="title"><?php  if(!empty($wbt_title) && $wbt_title) { echo esc_html($wbt_title);} ?></h1>
        <?php

    }
}
/***  Remover title page shop   ***/

if(apply_filters('woocommerce_show_page_title' , true)){
    add_filter( 'woocommerce_show_page_title' , 'woo_hide_page_title' );
    function woo_hide_page_title() {
      return false;
    }
}


if ( ! function_exists( 'foodo_site_info' ) ) {
  /**
   * Add site info hook to WP hook library.
   */
  function foodo_site_info() {
      do_action( 'foodo_site_info' );
  }
}

if ( ! function_exists( 'foodo_add_site_info' ) ) {
  add_action( 'foodo_site_info', 'foodo_add_site_info' );

  /**
   * Add site info content.
   */
  function foodo_add_site_info() {
    $the_theme = wp_get_theme();

    $site_info = sprintf(
      '<a href="%1$s">%2$s</a><span class="sep"> | </span>%3$s(%4$s)',
      esc_url( esc_html__( 'http://wordpress.org/', 'foodo' ) ),
      sprintf(
        /* translators:*/
         esc_html__( 'Proudly powered by %s', 'foodo' ), 'WordPress'
      ),
      sprintf( // WPCS: XSS ok.
        /* translators:*/
         esc_html__( 'Theme: %1$s by %2$s.', 'foodo' ), $the_theme->get( 'Name' ), '<a href="' . esc_url( esc_html__( 'http://wpopal.com', 'foodo' ) ) . '">wpopal.com</a>'
      ),
      sprintf( // WPCS: XSS ok.
        /* translators:*/
         esc_html__( 'Version: %1$s', 'foodo' ), $the_theme->get( 'Version' )
      )
    );

    echo apply_filters( 'foodo_site_info_content', $site_info ); // WPCS: XSS ok.
  }
}


if( !function_exists("foodo_blog_single_layout") ){
    function foodo_blog_single_layout( $value ){
        if( empty($value) ){
            return 'single';
        }
    }
}

/**
 * Set sidebar position
 */
function foodo_sidebar_position( $pos ){
    if( is_single() && get_post_type() == 'post' ){
        return get_theme_mod( 'foodo_sidebar_single_position' );
    }
    return $pos;
}
add_filter( 'foodo_sidebar_position', 'foodo_sidebar_position' );

/**
 * remove quick_view_button
 */
if( function_exists( 'YITH_WCQV_Frontend' ) && defined('YITH_WCQV_FREE_INIT') ) {
    remove_action( 'yith_wcwl_table_after_product_name', array( YITH_WCQV_Frontend(), 'yith_add_quick_view_button' ), 15 );
}
/**
 * Re-render all buttons: wishlist, compare, add favious and without add to cart
 */
function foodo_render_buttons_actions(){
    global $yith_woocompare;
?>
    <div class="wpopal-button-actions">
        <?php if( class_exists("YITH_WCQV_Frontend") ): ?>
        <div class="button-quickview-action">
            <?php echo YITH_WCQV_Frontend()->yith_add_quick_view_button(); ?>
        </div>
        <?php endif; ?>
        <?php if( class_exists("YITH_WCWL") ): ?>
            <div class="button-wishlist-action">
            <?php echo do_shortcode( "[yith_wcwl_add_to_wishlist]"); ?>
            </div>
        <?php endif; ?>
        <?php if( is_object($yith_woocompare) && method_exists( $yith_woocompare->obj, "add_compare_link")  ) :  ?>
        <div class="button-compare-action">
            <?php echo trim( $yith_woocompare->obj->add_compare_link() ); ?>
        </div>
        <?php endif; ?>
    </div>
<?php }
add_action( 'woocommerce_loop_content_split_product_bottom', 'foodo_render_buttons_actions', 10 );

/**
 * Custom mobile logo
 */
add_filter( 'get_custom_logo', 'foodo_custom_logo' );

if ( ! function_exists( 'foodo_custom_logo' ) ) {
  function foodo_custom_logo() {
      $custom_logo_id = get_theme_mod( 'custom_logo' );
      $html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home">%2$s</a>',
              esc_url( home_url( '/' ) ),
              wp_get_attachment_image( $custom_logo_id, 'full', false, array(
                  'class'    => 'custom-logo',
              ) )
          );
      return $html;
  }
}