<?php 
/**
 * Adding custom icon to icon control in Elementor
 */
function foodo_modify_controls( $controls_registry ) {
	// Get existing icons
	$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
	// Append new icons
	$new_icons = array_merge(
		array(
			'new-icon-1-css-class' => 'icon 1',
			'new-icon-2-css-class' => 'icon 2',
			'new-icon-3-css-class' => 'icon 3',
		),
		$icons
	);
	// Then we set a new list of icons as the options of the icon control
	$controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );
}
add_action( 'elementor/controls/controls_registered', 'foodo_modify_controls', 10, 1 );
?>