<?php 
	/**
	 * Adds hooks function to make greate feature for woocommerce
	 *
	 * @package GeneratePress
	 */

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}

	function foodo_woocommerce_get_loop_columns (){
		if( !get_theme_mod("woocommerce_disable_addition_nav") ) {
			if( class_exists('WC_Session_Handler')) {
				$session = WC()->session;
				$col =  $session->get('view_cols'); 
				if( $col ) {
    		 		return $col; 
    		 	}
			} 
		} else {
			return wc_get_loop_prop( 'columns' );
		}
	}

	/**
	 * Set single layout to show how arrange preview images, summery box, content tabs.
	 */
	function foodo_set_custom_single_layout (){

		if( is_product() ){ 
			// set global layout /// 
			$layout =  isset($_GET['opt']) && $_GET['opt'] ?  $_GET['opt'] : get_theme_mod( 'wpopal_product_layout');
			$single_layout = new foodo_WooCommerce_Single_Layout( $layout );
		
			$style = apply_filters( "wpopal_product_layout_style", get_theme_mod( 'wpopal_product_layout_style') );
 
			switch ( $style ) {
				
				case 'default':
					
					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default' );
					break;
				case 'center':
					
					$single_layout->set_default_hooks()->set_layout( 'center' );	
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default' );

					break;

				case 'fullwidth':
					
					$single_layout->set_default_hooks()->set_layout( 'fullwidth' );	

					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default' );

					break;	

				case 'split':
					
					$single_layout->set_default_hooks()->set_layout( 'split' , false );
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default' );

					add_filter("wpopal_product_comment_template", 'foodo_set_default_comments_layout' , 8, 999 );

					break;	

				case 'split_accordion':
					
					$single_layout->set_default_hooks()->set_layout( 'split' , false  );
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'accordion' );

					add_filter("wpopal_product_comment_template", 'foodo_set_default_comments_layout' , 8, 999 );

					break;	

				case 'small':
 
					$single_layout->set_default_hooks()->set_layout( 'small' );
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default' );

					break;	
				case 'big':
 
					$single_layout->set_default_hooks()->set_layout( 'big' );
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default' );

					break;		
				case 'sidebar':
					
					// set layout theme
					$single_layout->set_default_hooks()->set_layout( 'sidebar' );
					$single_layout->set_content_tabs( 'default' );
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );

					break;		

				case 'one_columns' : 

					$single_layout->set_default_hooks()->set_layout( 'small', true );	
					$single_layout->set_product_images_hooks( 'one_columns' );
					$single_layout->set_content_tabs( 'default' );

					break;

				case 'two_columns' : 

					$single_layout->set_default_hooks()->set_layout( 'small', true );	
					$single_layout->set_product_images_hooks( 'two_columns' );
					$single_layout->set_content_tabs( 'default' );

					break;	

				case 'slider' : 

					$single_layout->set_default_hooks()->set_layout( 'default', true );	
					$single_layout->set_product_images_hooks( 'slider' );
					$single_layout->set_content_tabs( 'default' );

					break;	

				case 'thumb_left_slider' : 

					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$single_layout->set_product_images_hooks( 'thumb_left_slider' );
					$single_layout->set_content_tabs( 'default' );

					break;		

				case 'thumb_right_slider' : 
					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$single_layout->set_product_images_hooks( 'thumb_right_slider' );
					$single_layout->set_content_tabs( 'default' );

					break;			
				
				case 'default_tabs' : 
					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'default_tabs' );

					break;	

				case 'vertical_tabs' : 
					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$single_layout->set_product_images_hooks( 'thumb_right_slider' );
					$single_layout->set_content_tabs( 'vertical_tabs' );

					break;		

				case 'accordion' : 
					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$single_layout->set_product_images_hooks( 'thumb_bot_slider' );
					$single_layout->set_content_tabs( 'accordion' );
					break;		
				default:

					$single_layout->set_default_hooks()->set_layout( 'small' );	
					$layout = apply_filters("wpopal_product_images", get_theme_mod( 'wpopal_product_images') ); 
					$single_layout->set_product_images_hooks( trim($layout) );
					

					/// set content tabs blocks
					$layout = apply_filters("wpopal_product_images", get_theme_mod( 'wpopal_product_tabs') );  
					$single_layout->set_content_tabs( trim($layout) );
					break;
			}
		}
	}
	add_action( 'template_redirect', "foodo_set_custom_single_layout" ); 


	/**
	 * Remove using advanded comment form
	 */
	function foodo_set_default_comments_layout( $option ){
	 
		if( $option == 'advanced' ){
			return 'default';
		}
		return $option; 
	}

	/**
	 * Set multiple layout loop as global
	 */
	function foodo_set_product_loop_layout (){

		$layout =  isset($_GET['product_layout']) && $_GET['product_layout'] ?  $_GET['product_layout'] : get_theme_mod( 'woocommerce_product_catalog_layout');
		
		$object = foodo_WooCommerce_Loop_Layout::instance(); 

	  				  	
	  	$col = foodo_woocommerce_get_loop_columns();
	  	if( $col == 1 && ( is_shop() || is_product_category() || is_product_tag() || is_tax() ) ){
	  		$layout = 'list';
	  	}

	  	$object->set_default_hook( $layout ); 

		if( $layout ){
			$loop_layout = $object->set_layout( $layout );
		} else {
			$object->set_default();
		}
	 
	}
	add_action( 'template_redirect', "foodo_set_product_loop_layout", 1 );

	if ( ! empty( $_REQUEST['action'] ) && 'elementor_ajax' === $_REQUEST['action'] && is_admin() ) { 
    	add_action( 'init', "foodo_set_product_loop_layout", 100 );
	}

	/**
	 * Sets up theme load javascript and style css to display colorful + typo for all page and elementor
	 */
	if( !function_exists("foodo_woocommerce_enqueue_scripts") ) {
		function foodo_woocommerce_enqueue_scripts() {
			$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

			wp_enqueue_style( 'wpopal-woocommerce-style', get_template_directory_uri() . '/woocommerce.css', 'wpopal-woocommerce-style' );
			wp_style_add_data( 'wpopal-woocommerce-style', 'rtl', 'replace' );
		 
		}
	}
	add_action( 'wp_enqueue_scripts', "foodo_woocommerce_enqueue_scripts", 99 );

	// if the theme did not active wpopal core pluign	
 
	function foodo_loop_product_layout(){ 
		add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
	}
	add_action( 'init', 'foodo_loop_product_layout', 99 );	

	/**
	 * Sets up theme defaults and registers support for various WooCommerce features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 *
	 * @since 2.4.0
	 * @return void
	 */ 
	function foodo_woocommerce_setup() { 
		add_theme_support(
			'wpopal-core', apply_filters(
				'foodo_woocommerce_args', array(
					'single_image_width'    => 416,
					'thumbnail_image_width' => 324,
					'product_grid'          => array(
						'default_columns' => 3,
						'default_rows'    => 4,
						'min_columns'     => 1,
						'max_columns'     => 6,
						'min_rows'        => 1,
					),
				)
			)
		);

		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );	
	}
	add_action( 'after_setup_theme', 'foodo_woocommerce_setup', 999 );

 

	/**
	 * Then hook in your own functions to display the wrappers your theme requires
	 */
	
	if ( ! function_exists( 'foodo_woocommerce_wrapper_start' ) ) {
		function foodo_woocommerce_wrapper_start() {
			$domain =  wp_get_theme();
			$container   = apply_filters( 'foodo_woocommerce_container_width', get_theme_mod( $domain.'_container_type' ) );
			echo '<div class="wrapper" id="woocommerce-wrapper">';
		  	echo '<div class="' . esc_attr( $container ) . '" id="content" tabindex="-1">';
			echo '<div class="row">';
			get_template_part( 'global-templates/left-sidebar-check' );
			echo '<main class="site-main" id="main">';
		}
	}
	add_action('woocommerce_before_main_content', 'foodo_woocommerce_wrapper_start', 10);

	if ( ! function_exists( 'foodo__woocommerce_wrapper_end' ) ) {
	function foodo_woocommerce_wrapper_end() {
		echo '</main><!-- #main -->';
		get_template_part( 'global-templates/right-sidebar-check' );
	  echo '</div><!-- .row -->';
		echo '</div><!-- Container end -->';
		echo '</div><!-- Wrapper end -->';
		}
	}
	add_action('woocommerce_after_main_content', 'foodo_woocommerce_wrapper_end', 10);

	/**
	 * Filter hook function monkey patching form classes
	 * Author: Adriano Monecchi http://stackoverflow.com/a/36724593/307826
	 *
	 * @param string $args Form attributes.
	 * @param string $key Not in use.
	 * @param null   $value Not in use.
	 *
	 * @return mixed
	 */
	if ( ! function_exists ( 'foodo_wc_form_field_args' ) ) {
		function foodo_wc_form_field_args( $args, $key, $value = null ) {
			// Start field type switch case.
			switch ( $args['type'] ) {
				/* Targets all select input type elements, except the country and state select input types */
				case 'select' :
					// Add a class to the field's html element wrapper - woocommerce
					// input types (fields) are often wrapped within a <p></p> tag.
					$args['class'][] = 'form-group';
					// Add a class to the form input itself.
					$args['input_class']       = array( 'form-control', 'input-lg' );
					$args['label_class']       = array( 'control-label' );
					$args['custom_attributes'] = array(
						'data-plugin'      => 'select2',
						'data-allow-clear' => 'true',
						'aria-hidden'      => 'true',
						// Add custom data attributes to the form input itself.
					);
					break;
				// By default WooCommerce will populate a select with the country names - $args
				// defined for this specific input type targets only the country select element.
				case 'country' :
					$args['class'][]     = 'form-group single-country';
					$args['label_class'] = array( 'control-label' );
					break;
				// By default WooCommerce will populate a select with state names - $args defined
				// for this specific input type targets only the country select element.
				case 'state' :
					// Add class to the field's html element wrapper.
					$args['class'][] = 'form-group';
					// add class to the form input itself.
					$args['input_class']       = array( '', 'input-lg' );
					$args['label_class']       = array( 'control-label' );
					$args['custom_attributes'] = array(
						'data-plugin'      => 'select2',
						'data-allow-clear' => 'true',
						'aria-hidden'      => 'true',
					);
					break;
				case 'password' :
				case 'text' :
				case 'email' :
				case 'tel' :
				case 'number' :
					$args['class'][]     = 'form-group';
					$args['input_class'] = array( 'form-control', 'input-lg' );
					$args['label_class'] = array( 'control-label' );
					break;
				case 'textarea' :
					$args['input_class'] = array( 'form-control', 'input-lg' );
					$args['label_class'] = array( 'control-label' );
					break;
				case 'checkbox' :
					$args['label_class'] = array( 'custom-control custom-checkbox' );
					$args['input_class'] = array( 'custom-control-input', 'input-lg' );
					break;
				case 'radio' :
					$args['label_class'] = array( 'custom-control custom-radio' );
					$args['input_class'] = array( 'custom-control-input', 'input-lg' );
					break;
				default :
					$args['class'][]     = 'form-group';
					$args['input_class'] = array( 'form-control', 'input-lg' );
					$args['label_class'] = array( 'control-label' );
					break;
			} // end switch ($args).
			return $args;
		}
	}

	add_filter( 'woocommerce_form_field_args', 'foodo_wc_form_field_args', 10, 3 );

	/**
	 * Display category image on category archive
	 */
	add_action( 'woocommerce_archive_description', 'foodo_category_image', 2 );
	function foodo_category_image() {
	    if ( is_product_category() ){
		    global $wp_query;
		    $cat = $wp_query->get_queried_object();
		    $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
		    $image = wp_get_attachment_url( $thumbnail_id );
		    if ( $image ) {
			    echo '<img src="' . $image . '" alt="' . esc_attr($cat->name) . '" />';
			}
		}
	}

	/**
	 * @snippet       Change No. of Thumbnails per Row @ Product Gallery | WooCommerce
	 */
	add_filter( 'woocommerce_single_product_image_gallery_classes', 'foodo_columns_product_gallery' );
 
	function foodo_columns_product_gallery( $wrapper_classes ) {
		$columns = 4;
		$wrapper_classes[2] = 'woocommerce-product-gallery--columns-' . absint( $columns );
		return $wrapper_classes;
	}

?>