<?php
/**
 * Declaring widgets
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
 
add_action( 'widgets_init', 'foodo_widgets_init' );

if ( ! function_exists( 'foodo_widgets_init' ) ) {
	/**
	 * Initializes themes widgets.
	 */
	function foodo_widgets_init() {
		register_sidebar( array(
			'name'          => esc_html__( 'Right Sidebar', 'foodo' ),
			'id'            =>  'right-sidebar',
			'description'   => esc_html__( 'Right sidebar widget area', 'foodo' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Left Sidebar', 'foodo' ),
			'id'            => 'left-sidebar',
			'description'   => esc_html__( 'Left sidebar widget area', 'foodo' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}
} 
