<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package foodo
 */

$the_theme = wp_get_theme();
$container = get_theme_mod( 'foodo_container_type' );
?>
<?php get_template_part( 'sidebar-templates/sidebar', 'footerfull' ); ?>
<div class="wrapper" id="wrapper-footer">
	<div class="<?php echo esc_attr( $container ); ?>">
		<div class="row">
			<div class="wp-col-md-12">
				<footer class="site-footer" id="colophon">
					
					<div class="site-info text-left">
							<?php printf( esc_html__( 'Copyright by %s', 'foodo' ),  date('Y') ); ?>
							<sep> - </sep>
							<?php printf( // WPCS: XSS ok.
							/* translators:*/
								 esc_html__( 'by %1$s.', 'foodo' ), '<a href="'.esc_url( $the_theme->get( 'AuthorURI' ) ).'">'.$the_theme->get( 'Name' ).'</a>' ); ?> 

							<?php echo  esc_html__( 'All rights reserved.', 'foodo' ); ?>	 <br> 

							<?php echo esc_html__( 'Powered by', 'foodo' ) ?>
							<a href="<?php  echo esc_url( esc_html__( 'http://wordpress.org/','foodo' ) ); ?>">WordPress</a>
							 
					</div><!-- .site-info -->
					
				</footer><!-- #colophon -->
			</div><!--col end -->
		</div><!-- row end -->
	</div><!-- container end -->
</div><!-- wrapper end -->