<?php
/**
 * Post rendering content according to caller of get_template_part.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<article <?php post_class( 'blog-list-item' ); ?> id="post-<?php the_ID(); ?>">

			<header class="entry-header">  
                <?php echo get_the_post_thumbnail( $post->ID, 'full' ); ?>
			</header><!-- .entry-header -->

			<div class="entry-content">
				<div class="entry-block">
					<?php if(get_the_category_list( ', ' )): ?>
						<div class="meta-post-categories">
							<?php echo get_the_category_list( ', ' ); ?>
						</div>
					<?php endif; ?>
				
					<?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ),
					'</a></h3>' ); ?>
					<?php foodo_get_post_meta( array('labels' => 1, 'short' => true, 'comments' => 0) ); ?>
				
				</div>
				<div class="entry-excerpt">
				<?php
				the_excerpt();
				?>
				</div>
				
			</div><!-- .entry-content -->


</article><!-- #post-## -->
