<?php
/**
 * Post rendering content according to caller of get_template_part.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$url = get_the_post_thumbnail_url( $post->ID, 'metro' );
?>

<article <?php post_class( 'blog-mark-hover-item' ); ?> id="post-<?php the_ID(); ?>">

    <header class="entry-header">
        <?php do_action( 'foodo_loop_post_preview'); ?>
    </header><!-- .entry-header -->
	
    <div class="mark-hover-content">

        <div class="entry-content">
            <div class="entry-block">
                <?php if(get_the_category_list( ', ' )): ?>
                    <div class="meta-post-categories">
                        <?php echo get_the_category_list( ', ' ); ?>
                    </div>
                <?php endif; ?>
            
                <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ),
                '</a></h3>' ); ?>
                <?php foodo_get_post_meta( array('labels' => 1, 'short' => true, 'comments' => 0) ); ?>
            
            </div>
            
        </div><!-- .entry-content -->
	</div><!-- .entry-mark-hover-content -->

</article><!-- #post-## -->
