<?php
/**
 * Post rendering content according to caller of get_template_part.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$url = get_the_post_thumbnail_url( $post->ID, 'metro' );
?>

<article <?php post_class( 'blog-minimal-item' ); ?> id="post-<?php the_ID(); ?>">

    
    <header class="entry-header">
    	<?php foodo_get_post_meta( array('date' => 0 ) ); ?>
        <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ),
		'</a></h3>' ); ?>
    </header><!-- .entry-header -->
	
 
	<div class="entry-content">
		
		<div class="entry-excerpt">
	        <?php
	        	the_excerpt();
	        ?>
	    </div>
	</div><!-- .entry-header -->

 
	<footer class="entry-footer">

	    <div class="meta-author">
          
            <span class="posted-by"><?php esc_html_e('By', 'foodo'); ?></span>
          
            <?php echo get_avatar( get_the_author_meta( 'ID' ), 32 ); ?>
      
	        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
	            <span class="vcard author author_name ">
	              <span class="fn"><?php echo get_the_author(); ?></span>
	            </span>
	        </a>

        </div>

	</footer>
</article><!-- #post-## -->
