<?php
/**
 * Post rendering content according to caller of get_template_part.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$url = get_the_post_thumbnail_url( $post->ID, 'metro' );
?>

<article <?php post_class( 'blog-overlay-item' ); ?> id="post-<?php the_ID(); ?>">
	<?php if( $url ) : ?>
	<div class="overlay-img-bg" style="background-image:url('<?php echo esc_url( $url ); ?>');"></div>
	<?php endif; ?>

    <div class="overlay-content">
        <div class="entry-content">
            <div class="entry-block">
                <div class="entry-block1">
                    <?php foodo_blog_posted_date(); ?>
                </div>
                <div class="entry-block2">
                    <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ),
                    '</a></h3>' ); ?>
                    <?php foodo_get_post_meta( array('date' => 0, 'cats' => 1) ); ?>
                </div>
            </div>
            <div class="entry-excerpt">
                <?php
                the_excerpt();
                ?>
            </div>
        </div><!-- .entry-header -->
    </div><!-- .entry-content -->

</article><!-- #post-## -->
