<?php
/**
 * Post rendering content according to caller of get_template_part.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<article <?php post_class(); ?> id="post-<?php the_ID(); ?>">
   
    <header class="entry-header">
        <?php if(get_the_post_thumbnail()): ?>
            <div class="post-thumbnail">
                <a href="<?php the_permalink(); ?>">
                    <?php echo get_the_post_thumbnail( $post->ID, 'full'); ?>
                </a>
            </div>
        <?php endif; ?>
    </header>
    <!-- .entry-header -->

	<div class="entry-content">

        <div class="meta-post-categories">
            <div class="inner">
            <?php echo get_the_category_list( ', ' ); ?>
            </div>
        </div>

        <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ),
            '</a></h3>' ); ?>

        <?php if ( 'post' == get_post_type() ) : ?>
         <div class="entry-meta">
          <?php foodo_posted_on(); ?>
        </div><!-- .entry-meta -->    
		<?php
		the_content();
		?>

		<?php
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'foodo' ),
			'after'  => '</div>',
		) );
		?>
       
        <?php endif; ?>
 
	</div>
    <!-- .entry-content -->
</article><!-- #post-## -->
