<?php
/**
 * Single post partial template.
 *
 * @package foodo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<?php do_action( 'foodo_content_single_before' ); ?>
<article <?php post_class(); ?> id="post-<?php the_ID(); ?>">

	<?php do_action( 'foodo_single_post_preview'); ?>

	<div class="entry-content">
		<div class="entry-meta">
			<?php foodo_get_post_meta( array('labels' => 1, 'short' => true, 'comments' => 0) ); ?>
		</div><!-- .entry-meta -->
		<?php the_content(); ?>

		<?php
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'foodo' ),
			'after'  => '</div>',
		) );
		?>

	</div><!-- .entry-content -->

	<footer class="entry-footer">

		<div class="single_tags"><?php the_tags('', ' '); ?></div>
		<?php do_action( 'foodo_single_entry_footer_after' ); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-## -->

<?php do_action( 'foodo_content_single_after' ); ?>
