(function ($) {
	if (!window.The7Options) {
		window.The7Options = {};
	}

	if (window.The7Options.slider) {
		return;
	}

	window.The7Options.slider = function (element) {
		var $sliderContainer = $(element);
		var $sliderInput = $sliderContainer.next('input.of-slider-value');

		if (!$sliderInput.length) {
			return;
		}

		$sliderContainer.slider({
			value: parseInt($sliderInput.attr('data-value')),
			min: parseInt($sliderInput.attr('data-min')),
			max: parseInt($sliderInput.attr('data-max')),
			step: parseInt($sliderInput.attr('data-step')),
			range: 'min',
			slide: function (event, ui) {
				$sliderInput.val(ui.value).trigger('change.of-slider-slide');
			}
		});
		$sliderInput.val($sliderContainer.slider('value'));
		$sliderInput.on('change', function (event) {
			var value = parseInt($sliderInput.val());
			if (isNaN(value)) {
				value = $sliderContainer.slider('option', 'min');
			}

			$sliderContainer.slider('value', value);
			$sliderInput.val($sliderContainer.slider('value'));
		});
	}
})(jQuery);