<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the <div class="wf-container"> and all content after
 *
 * @since 1.0.0
 *
 * @package The7\Templates
 */

defined( 'ABSPATH' ) || exit;

if ( presscore_is_content_visible() ) : ?>

			</div><!-- .wf-container -->
		</div><!-- .wf-wrap -->

	<?php
	/**
	 * Do something after content container close tag.
	 *
	 * @since 6.8.1
	 */
	do_action( 'the7_after_content_container' );
	?>

	</div><!-- #main -->

	<?php
	if ( presscore_config()->get( 'template.footer.background.slideout_mode' ) ) {
		echo '</div>';
	}
	?>

<?php endif; ?>

	<?php do_action( 'presscore_after_main_container' ); ?>

	<a href="#" class="scroll-top"><span class="screen-reader-text"><?php esc_html_e( 'Go to Top', 'the7mk2' ); ?></span></a>

</div><!-- #page -->

<?php wp_footer(); ?>

<div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="pswp__bg"></div>
	<div class="pswp__scroll-wrap">
		<div class="pswp__container">
			<div class="pswp__item"></div>
			<div class="pswp__item"></div>
			<div class="pswp__item"></div>
		</div>
		<div class="pswp__ui pswp__ui--hidden">
			<div class="pswp__top-bar">
				<div class="pswp__counter"></div>
				<button class="pswp__button pswp__button--close" title="<?php esc_html_e( 'Close (Esc)', 'the7mk2' ) ?>" aria-label="<?php esc_html_e( 'Close (Esc)', 'the7mk2' ) ?>"></button>
				<button class="pswp__button pswp__button--share" title="<?php esc_html_e( 'Share', 'the7mk2' ) ?>" aria-label="<?php esc_html_e( 'Share', 'the7mk2' ) ?>"></button>
				<button class="pswp__button pswp__button--fs" title="<?php esc_html_e( 'Toggle fullscreen', 'the7mk2' ) ?>" aria-label="<?php esc_html_e( 'Toggle fullscreen', 'the7mk2' ) ?>"></button>
				<button class="pswp__button pswp__button--zoom" title="<?php esc_html_e( 'Zoom in/out', 'the7mk2' ) ?>" aria-label="<?php esc_html_e( 'Zoom in/out', 'the7mk2' ) ?>"></button>
				<div class="pswp__preloader">
					<div class="pswp__preloader__icn">
						<div class="pswp__preloader__cut">
							<div class="pswp__preloader__donut"></div>
						</div>
					</div>
				</div>
			</div>
			<div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
				<div class="pswp__share-tooltip"></div> 
			</div>
			<button class="pswp__button pswp__button--arrow--left" title="<?php esc_html_e( 'Previous (arrow left)', 'the7mk2' ) ?>" aria-label="<?php esc_html_e( 'Previous (arrow left)', 'the7mk2' ) ?>">
			</button>
			<button class="pswp__button pswp__button--arrow--right" title="<?php esc_html_e( 'Next (arrow right)', 'the7mk2' ) ?>" aria-label="<?php esc_html_e( 'Next (arrow right)', 'the7mk2' ) ?>">
			</button>
			<div class="pswp__caption">
				<div class="pswp__caption__center"></div>
			</div>
		</div>
	</div>
</div>
</body>
</html>
