<?php
/**
 * Template Name: Logged In
 *
 * A template that only allows logged in users to view the content.
 *
 * @uses is_user_logged_in() Checks if user is logged in.
 * @link http://codex.wordpress.org/Function_Reference/is_user_logged_in
 */
?>

<?php get_header() ?>

	<div id="container">
		<div id="content">

<?php get_sidebar('page-top') ?>

<?php if(is_user_logged_in()){ ?>

<?php the_post() ?>
			<div id="post-<?php the_ID(); ?>" class="<?php thematic_post_class() ?>">
    			<?php thematic_postheader(); ?>
				<div class="entry-content">
<?php the_content() ?>

<?php wp_link_pages("\t\t\t\t\t<div class='page-link'>".__('Pages: ', 'thematic'), "</div>\n", 'number'); ?>

<?php edit_post_link(__('Edit', 'thematic'),'<span class="edit-link">','</span>') ?>

				</div>
			</div><!-- .post -->

<?php if ( get_post_custom_values('comments') ) comments_template('', true) // Add a key+value of "comments" to enable comments on this page ?>

<?php }else{ ?>

	<p class="alert">
		<?php
			echo 'You must be logged in to view the content of this page. ';
			if ( get_option( 'users_can_register' ) ) echo 'If you\'re not currently a member, please take a moment to register.';
		?>
	</p><!-- .alert -->

<?php } ?>

<?php get_sidebar('page-bottom') ?>

		</div><!-- #content -->
	</div><!-- #container -->

<?php thematic_sidebar() ?>
<?php get_footer() ?>