<?php

function remove_thematic_branding() {
	remove_action('thematic_header','thematic_blogdescription',5);
	remove_action('thematic_header','thematic_access',9);
}
add_action('init','remove_thematic_branding');

function my_fallback_menu(){?>
	<ul class="sf-menu">
		<?php wp_list_pages('title_li=&sort_column=menu_order'); ?>
    </ul>			
	<?php 
}

// Add the Logo and Search Box next to the menu
function childtheme_access(){ ?>
	<div id="access">
		<div class="skip-link"><a href="#content" title="<?php _e('Skip navigation to the content', 'thematic'); ?>"><?php _e('Skip to content', 'thematic'); ?></a></div>
		<div id="menu">
			<?php 			
			wp_nav_menu(  array( 'theme_location' => 'primary-menu', 'menu_class' => 'sf-menu', 'fallback_cb' => 'my_fallback_menu' )); ?>
		</div>
    </div><!-- #access -->
<?php
}
add_action('thematic_header', 'childtheme_access', 4);

/* ********************************************** */
/* Add an options pannel for your Thematic Child Theme
/* ********************************************** */

// ---------- "Child Theme Options" menu STARTS HERE

add_action('admin_menu' , 'childtheme_add_admin');
function childtheme_add_admin() {
	add_submenu_page('themes.php', 'Early Morning Theme Options', 'Early Morning Theme Options', 'edit_themes', basename(__FILE__), 'childtheme_admin');
}

function childtheme_admin() {
	
	
	
	
	if (get_option('varcol') == '') update_option('varcol', 'varcol1');
	$varcol = get_option('varcol');
	
	if ($_POST['options-submit']){	

		$varcol = $_POST['varcol'];
		update_option('varcol', $varcol);	
	
		
		?>
			<div class="updated"><p>Your new options have been successfully saved.</p></div>
		<?php

	}
	
	if($enabled) $checked='checked="checked"';

	?>
		<div class="cozmos-wrap">
			<div id="icon-themes" class="icon32"></div>
			<h2>Child Theme Options</h2>
			<form name="theform" method="post" enctype="multipart/form-data" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']);?>">
				<table class="form-table">					
					<tr>
						<td>Current Logo Image:</td>
						<td><?php if(get_header_image() != '') echo '<img src="'.get_header_image().'" />'; else echo 'No logo Image'; ?></td>
					</tr>
					<tr>
						<td>Change Current Logo Image:</td>
						<td><a href="<?php echo get_admin_url(); ?>themes.php?page=custom-header">Here</a></td>
					</tr>					
					<tr>
						<td>Color Variation:</td>
						<td>
							<select name="varcol">
								<option value="varcol1"<?php if(get_option('varcol')=='varcol1') echo ' selected="selected"';?>>Green</option>
								<option value="varcol2"<?php if(get_option('varcol')=='varcol2') echo ' selected="selected"';?>>Turquoise</option>
								<option value="varcol3"<?php if(get_option('varcol')=='varcol3') echo ' selected="selected"';?>>Brick Red</option>
								<option value="varcol4"<?php if(get_option('varcol')=='varcol4') echo ' selected="selected"';?>>Gray</option>
								<option value="varcol5"<?php if(get_option('varcol')=='varcol5') echo ' selected="selected"';?>>Black</option>
							</select>
						</td>
					</tr>
				</table>
				<input type="hidden" name="options-submit" value="1" />
				<p class="submit"><input type="submit" name="submit" value="Save Options" /></p>
			</form>
		</div>
	<?php
}

// ---------- "Child Theme Options" menu ENDS HERE

// ---------- Adding the logo image to the header STARTS HERE



function remove_thematic_blogtitle() {
	if(get_header_image() != '')
		remove_action('thematic_header','thematic_blogtitle',3);	 
}
add_action('init','remove_thematic_blogtitle');

function remove_thematic_blogdescription() {
	if(get_header_image() != '')
		remove_action('thematic_header','thematic_blogdescription',5);
}
add_action('init','remove_thematic_blogdescription');

function thematic_logo_image() {
	if(get_header_image() != '')
		echo '<div id="logo-image"><a href="'.get_option('home').'"><img src="'.get_header_image().'" width="'. HEADER_IMAGE_WIDTH.'" height="'.HEADER_IMAGE_HEIGHT.'" alt="" /></a></div>';
}
add_action('thematic_header','thematic_logo_image',6);

// ---------- Adding the logo image to the header ENDS HERE


function childtheme_theme_link($themelink) {
    return $themelink . ' &amp; <a class="child-theme-link" href="http://www.cozmoslabs.com" title="Early Morning Theme" rel="designer">Early Morning</a>. Inspired by: <a href="http://www.adrianpelletier.com/">Adrian Pelletier</a>';
}
add_filter('thematic_theme_link', 'childtheme_theme_link');


// ---------- Add Home Page in the menu
function childtheme_menu_args($args) {
    $args = array(
        'show_home' => 'Home',
        'sort_column' => 'menu_order',
        'menu_class' => 'menu',
        'echo' => true
    );
    return $args;
}
add_filter('wp_page_menu_args','childtheme_menu_args');


// ---------- Add The Top and Bottom parts of the main div 
function main_top(){
	echo '<div id="main_top"></div>';	
}
add_action('thematic_belowheader', 'main_top');

function main_bottom(){
	echo '<div id="main_bottom"></div>';	
}
add_action('thematic_abovefooter', 'main_bottom');


// ---------- Post Header
function child_postheader(){
    global $id, $post, $authordata;
    
    // Create $posteditlink    
    $posteditlink .= '<a href="' . get_bloginfo('wpurl') . '/wp-admin/post.php?action=edit&amp;post=' . $id;
    $posteditlink .= '" title="' . __('Edit post', 'thematic') .'">';
    $posteditlink .= __('Edit', 'thematic') . '</a>';
    $posteditlink = apply_filters('thematic_postheader_posteditlink',$posteditlink); 

    
    if (is_single() || is_page()) {
        $posttitle = '<h1 class="entry-title">' . get_the_title() . "</h1>\n";
    } elseif (is_404()) {    
        $posttitle = '<h1 class="entry-title">' . __('Not Found', 'thematic') . "</h1>\n";
    } else {
        $posttitle = '<h2 class="entry-title"><a href="';
        $posttitle .= get_permalink();
        $posttitle .= '" title="';
        $posttitle .= __('Permalink to ', 'thematic') . the_title_attribute('echo=0');
        $posttitle .= '" rel="bookmark">';
        $posttitle .= get_the_title();   
        $posttitle .= "</a></h2>\n";
    }
    //$posttitle = apply_filters('thematic_postheader_posttitle',$posttitle); 
    
    $postmeta = '<div class="entry-meta">';
    $postmeta .= '<span class="meta-prep meta-prep-author">' . __('By ', 'thematic') . '</span>';
    $postmeta .= '<span class="author vcard">'. '<a class="url fn n" href="';
    $postmeta .= get_author_link(false, $authordata->ID, $authordata->user_nicename);
    $postmeta .= '" title="' . __('View all posts by ', 'thematic') . get_the_author() . '">';
    $postmeta .= get_the_author();
    $postmeta .= '</a></span>';
    
    // Display edit link
    if (current_user_can('edit_posts')) {
        $postmeta .= ' <span class="meta-sep meta-sep-edit">|</span> ' . '<span class="edit">' . $posteditlink . '</span>';
    }               
    $postmeta .= "</div><!-- .entry-meta -->\n";
    $postmeta = apply_filters('thematic_postheader_postmeta',$postmeta); 

	$postdate = '<div class="entry-date">';
    $postdate .= '<abbr class="published" title="';
    $postdate .= get_the_time(thematic_time_title()) . '">';
    $postdate .= get_the_time(thematic_time_display());
    $postdate .= '</abbr></div>';
	    
    if ($post->post_type == 'page' || is_404()) {
        $postheader = $posttitle;        
    } else {
        $postheader = $postdate . $posttitle . $postmeta;    
    }
	return $postheader;
} 
add_filter('thematic_postheader', 'child_postheader' );

// Color variations:

function early_body_class($classes){
	$classes[]=get_option('varcol');
	return $classes;
} 
add_filter('body_class', 'early_body_class' );

function admin_head() { 
    echo '<link rel="stylesheet" type="text/css" href="'.get_bloginfo('stylesheet_directory').'/admin-style.css" media="screen" />';
}
add_action('admin_head', 'admin_head');

// Category changes
function remove_category_loop(){
	remove_action('thematic_categoryloop','thematic_category_loop');
}
add_action('init','remove_category_loop');

// The Category Loop
function early_category_loop() {
		while (have_posts()) : the_post(); ?>

			<div id="post-<?php the_ID(); ?>" class="<?php thematic_post_class(); ?>">
    			<?php thematic_postheader(); ?>
				<div class="entry-content">
<?php //thematic_content(); ?>

				</div>
				<?php //thematic_postfooter(); ?>
			</div><!-- .post -->

		<?php endwhile;
}
add_action('thematic_categoryloop', 'early_category_loop');


// Archives changes
function remove_archive_loop(){
	remove_action('thematic_archiveloop','thematic_archive_loop');
}
add_action('init','remove_archive_loop');
add_action('thematic_archiveloop', 'early_category_loop');

// Tags changes
function remove_tag_loop(){
	remove_action('thematic_tagloop','thematic_tag_loop');
}
add_action('init','remove_tag_loop');
add_action('thematic_tagloop', 'early_category_loop');

// Search Loop changes
function remove_search_loop(){
	remove_action('thematic_searchloop', 'thematic_search_loop');
}
add_action('init','remove_search_loop');

function early_search_loop() {
		while ( have_posts() ) : the_post(); ?>

			<div id="post-<?php the_ID() ?>" class="<?php thematic_post_class() ?>">
    			<?php thematic_postheader(); ?>
				<div class="entry-content">
<?php the_excerpt(); ?>

				</div>
				<?php //thematic_postfooter(); ?>
			</div><!-- .post -->

		<?php endwhile;
}
add_action('thematic_searchloop', 'early_search_loop');

function new_excerpt_length($length) {
	return 20;
}
add_filter('excerpt_length', 'new_excerpt_length');


//Filter the content to add Drop Caps. 

function the_content_filter() {
	$more = ''.__('Read More <span class="meta-nav">&raquo;</span>', 'thematic').'';
	$post = get_the_content($more);
	$post = apply_filters('the_content', $post);
	$post = str_replace(']]>', ']]&gt;', $post);
	
	//We're look for the first paragraph tag followed by a capital letter
	$pattern = '/<p( .*)?( class="(.*)")??( .*)?>((<[^>]*>|\s)*)((&quot;|&#8220;|&#8216;|&lsquo;|&ldquo;|\')?[A-Z])/U';
	$replacement = '<p$1 class="first-child $3"$4>$5<span title="$7" class="cap"><span>$7</span></span>';

	$content = preg_replace($pattern, $replacement, $post, 1 );
	return $content;
}
add_filter('thematic_post', 'the_content_filter');

//Remove alt tags for the menu using javascript
function remove_alt(){
	wp_enqueue_script('jquery');
?>
<script type="text/javascript">

        jQuery(document).ready(function(){

                jQuery("li.cat-item a").each(function(){
                    jQuery(this).removeAttr('title');
                })                
                
                jQuery("li.page_item a").each(function(){
                    jQuery(this).removeAttr('title');
                })

        });
 
</script>
<?php
}
add_filter('wp_head','remove_alt', 90);

function early_content(){
	if (is_home() || is_front_page()) {
		$content = 'excerpt';
	} elseif (is_single()) {
		$content = 'full';
	} elseif (is_tag()) {
		$content = 'excerpt';
	} elseif (is_search()) {
		$content = 'excerpt';
	} elseif (is_category()) {
		$content = 'excerpt';
	} elseif (is_author()) {
		$content = 'excerpt';
	} elseif (is_archive()) {
		$content = 'excerpt';
	}
	return $content;
}
//add_filter('thematic_content', 'early_content');

function extra_header_css(){
	echo '<link rel="stylesheet" href="'.get_bloginfo('stylesheet_directory').'print.css" type="text/css" />';
}
//add_action('wp_head', 'extra_header_css');

/** Tell WordPress to run yourtheme_setup() when the 'after_setup_theme' hook is run. */
add_action( 'after_setup_theme', 'yourtheme_setup' );

if ( ! function_exists('yourtheme_setup') ):
/**
* @uses add_custom_image_header() To add support for a custom header.
* @uses register_default_headers() To register the default custom header images provided with the theme.
*
* @since 3.0.0
*/
function yourtheme_setup() {



// Your changeable header business starts here
define( 'HEADER_TEXTCOLOR', '' );
// No CSS, just IMG call. The %s is a placeholder for the theme template directory URI.
define( 'HEADER_IMAGE', get_bloginfo('stylesheet_directory').'/images/logo.png' );

// The height and width of your custom header. You can hook into the theme's own filters to change these values.
// Add a filter to yourtheme_header_image_width and yourtheme_header_image_height to change these values.
define( 'HEADER_IMAGE_WIDTH', apply_filters( 'yourtheme_header_image_width', 335 ) );
define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'yourtheme_header_image_height', 95 ) );


// Don't support text inside the header image.
define( 'NO_HEADER_TEXT', true );

// Add a way for the custom header to be styled in the admin panel that controls
// custom headers. See yourtheme_admin_header_style(), below.
add_custom_image_header( '', 'yourtheme_admin_header_style' );

// and thus ends the changeable header business.


}
endif;

if ( ! function_exists( 'yourtheme_admin_header_style' ) ) :
/**
* Styles the header image displayed on the Appearance > Header admin panel.
*
* Referenced via add_custom_image_header() in yourtheme_setup().
*
* @since 3.0.0
*/
function yourtheme_admin_header_style() {
?>
<style type="text/css">
#headimg {
height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
min-height: 0 !important;
}
#headimg h1, #headimg #desc {
display: none;
}
</style>
<?php
}
endif;

function earlyMorning_hidden_theme( $r, $url ) {
	if ( 0 !== strpos( $url, 'http://api.wordpress.org/themes/update-check' ) )
		return $r; // Not a theme update request. Bail immediately.
	$themes = unserialize( $r['body']['themes'] );
	unset( $themes[ get_option( 'template' ) ] );
	unset( $themes[ get_option( 'stylesheet' ) ] );
	$r['body']['themes'] = serialize( $themes );
	return $r;
}

add_filter( 'http_request_args', 'earlyMorning_hidden_theme', 5, 2 );
