<?php
/*
Plugin Name: Twitter RSS
Description: Adds a sidebar widget to show Twitter RSS feeds
Author: Reflection Media
Version: 1.0
Author URI: http://www.reflectionmedia.ro
*/

function hyperlink_it($text) {
    // match protocol://address/path/file.extension?some=variable&another=asf%
    $text = preg_replace("/\s([a-zA-Z]+:\/\/[a-z][a-z0-9\_\.\-]*[a-z]{2,6}[a-zA-Z0-9\/\*\-\?\&\%]*)([\s|\.|\,])/i"," <a href=\"$1\" class=\"twitter-link\">$1</a>$2", $text);
    // match www.something.domain/path/file.extension?some=variable&another=asf%
    $text = preg_replace("/\s(www\.[a-z][a-z0-9\_\.\-]*[a-z]{2,6}[a-zA-Z0-9\/\*\-\?\&\%]*)([\s|\.|\,])/i"," <a href=\"http://$1\" class=\"twitter-link\">$1</a>$2", $text);      
    // match name@address
    $text = preg_replace("/\s([a-zA-Z][a-zA-Z0-9\_\.\-]*[a-zA-Z]*\@[a-zA-Z][a-zA-Z0-9\_\.\-]*[a-zA-Z]{2,6})([\s|\.|\,])/i"," <a href=\"mailto://$1\" class=\"twitter-link\">$1</a>$2", $text);    
    //mach #trendingtopics. Props to Michael Voigt
    $text = preg_replace('/([\.|\,|\:|\¡|\¿|\>|\{|\(]?)#{1}(\w*)([\.|\,|\:|\!|\?|\>|\}|\)]?)\s/i', "$1<a href=\"http://twitter.com/#search?q=$2\" class=\"twitter-link\">#$2</a>$3 ", $text);
	// mach @twitter_user
    $text = preg_replace('/([\.|\,|\:|\�|\�|\>|\{|\(]?)@{1}(\w*)([\.|\,|\:|\!|\?|\>|\}|\)]?)\s/i', "$1<a href=\"http://twitter.com/$2\" class=\"twitter-user\">@$2</a>$3 ", $text);

    return $text;
}

function early_twitter($args) {
	extract($args);
	$options = get_option('early_twitter');
	echo $before_widget;
	echo $before_title . $options['title'] . $after_title;
	
	include_once(ABSPATH . WPINC . '/rss.php');
	$messages = fetch_rss('http://twitter.com/statuses/user_timeline/'.$options['username'].'.rss');
	
	echo '<ul class="twitter">';
	
	foreach ( $messages->items as $message ) {
		$msg = " ".substr(strstr($message['description'],': '), 2, strlen($message['description']))." ";
		$msg = hyperlink_it($msg);
		
		echo '<li class="twitter-item">';;
		echo $msg;
		echo '</li>';
		
		$i++;
		if ( $i >= $options['tweets_nr'] ) break;
	}
	
	echo '</ul>';
	
	echo '<p class="more-tweets"><a href="http://twitter.com/'.$options['username'].'">More tweets from '.$options['username'].'</a></p>';
	
	echo $after_widget;
}

// Admin section
function widget_control_early_twitter() {
	global $wpdb;
	$options = get_option('early_twitter');

	if ( $_POST['form-submit'] ) {
		$options['title'] = strip_tags(stripslashes($_POST['twitter_title']));
		$options['username'] = strip_tags(stripslashes($_POST['twitter_username']));
		$options['tweets_nr'] = strip_tags(stripslashes($_POST['tweets_nr']));
		update_option('early_twitter', $options);
	}

	$title = htmlspecialchars($options['title'], ENT_QUOTES);
	$username = htmlspecialchars($options['username'], ENT_QUOTES);
	$tweets_nr = htmlspecialchars($options['tweets_nr'], ENT_QUOTES);

	// The Box content
	echo '<p style="text-align:right;">' . 'Widget title:' . ' <input style="width: 150px;" name="twitter_title" type="text" value="'.$title.'" /></p>';
	echo '<p style="text-align:right;">' . 'Twitter username:' . ' <input style="width: 150px;" name="twitter_username" type="text" value="'.$username.'" /></p>';
	echo '<p style="text-align:right;">' . 'Number of tweets:' . ' <input style="width: 150px;" name="tweets_nr" type="text" value="'.$tweets_nr.'" /></p>';	
	echo '<input type="hidden" name="form-submit" value="1" />';
}

$options = get_option('early_twitter');
if ( !is_array($options) )
$options = array('title'=>''. __('Twitter RSS', 'thematic') .'',
	'username'=>''. __('username', 'thematic') .'',
	'tweets_nr'=>''. __('5', 'thematic') .'',);
update_option('early_twitter', $options);

register_sidebar_widget(__('Twitter RSS','thematic'), 'early_twitter');
register_widget_control(__('Twitter RSS','thematic'), 'widget_control_early_twitter', 300, 200);
?>