<?php

/**
 * Load javascripts sitewide
 */

//  Load blog slider widget js
function slider_blog_js() {
       wp_enqueue_script('slider-blog-js', PARENT_URL.'/js/slider-blog.js'); 
}   

//  Load product slider widget js 
function slider_product_js() {
       wp_enqueue_script('slider-product-js', PARENT_URL.'/js/slider-product.js'); 
}

function seneca_js() {

	// load jquery sitewide
	wp_enqueue_script('jquery');

	// only load slides.js on home, team and product posts
	if (is_home() || get_post_type() == 'team' || get_post_type() == 'product') {
		wp_enqueue_script('flex-slider', PARENT_URL.'/js/flexSlider/jquery.flexslider-min.js');
		wp_enqueue_script('flex-slider-custom', PARENT_URL.'/js/flexSlider/jquery.flexslider-custom.js'); 
	}
	
	// only load on single product posts
	if (get_post_type() == 'product' || 'team' == get_post_type()) {
		wp_enqueue_script('prettyphoto', PARENT_URL.'/js/prettyPhoto/jquery.prettyPhoto.js');
		wp_enqueue_script('prettyphoto-js', PARENT_URL.'/js/prettyPhoto/prettyphoto-js.js');
	}
	
	// only load woocommerce js if woocommerce is installed
	if (class_exists('woocommerce')) {
		wp_enqueue_script('woocommerce-ext', PARENT_URL.'/lib/woocommerce/woocommerce-extensions.js',  array('jquery'));
	}
	
	// load sitewide
	wp_enqueue_script('senecajs', PARENT_URL.'/js/seneca.jquery.js', array('jquery'));
	wp_enqueue_script('twitter', 'http://platform.twitter.com/widgets.js', '');
	wp_enqueue_script('facebook', 'http://connect.facebook.net/en_US/all.js#xfbml=1', '');

}

add_action( 'wp_head', 'seneca_js' );


/**
 * Load Conditional DOM JS
 */
 
function seneca_dom_js() {

	$doc_ready_script = "";
	
	if ( 'team' == get_post_type()) {
	
		$doc_ready_script .= "
	
<script type=\"text/javascript\">
/* <![CDATA[ */
	jQuery(function($){
	    
	    
	    $('#ss_wrap .flexslider').flexslider({
                 manualControls: '.pagination li a',
                 controlNav: true

		});
	});
/* ]]> */	
</script>";

	} // if is single team post type
	
	echo $doc_ready_script;
	echo "\n";

}

add_action('wp_head', 'seneca_dom_js');


/**
 * Load Color Coded Widgets & Sidebars
 */
function gpp_admin_js() {    
    global $pagenow;
    if ( is_admin() && $pagenow == 'widgets.php' ) { 
        wp_enqueue_script('wp-admin', get_template_directory_uri(). '/js/wp-admin.js');
    }
}
add_action( "admin_print_scripts", 'gpp_admin_js'); 