<?php class GPPBlogSliderWidget extends WP_Widget
{
    function GPPBlogSliderWidget(){
		$widget_ops = array('description' => 'Displays a blog slider consisting of the featured image and title of the post. Only use this in the Homepage widget position.');
		$control_ops = array('width' => 200, 'height' => 200);
		parent::WP_Widget(false,$name='GPP Blog Slider',$widget_ops,$control_ops, $id='');
		if ( is_active_widget(false, false, $this->id_base, true) ){
                       add_action( 'wp_head', 'slider_blog_js' );
                    }
    }

/* Displays the Widget in the front-end */
    function widget($args, $instance){
		extract($args);
		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title']);
		$categoryNumber = empty($instance['categoryNumber']) ? '' : $instance['categoryNumber'];
		$recentPostsNumber = empty($instance['recentPostsNumber']) ? '' : $instance['recentPostsNumber'];
		$slideEffect = empty($instance['slideEffect']) ? '' : $instance['slideEffect'];       
		
	    extract($args);
	   

         echo $before_widget;

    		if ( $title )
    		echo $before_title . $title . $after_title;	      
?>
<div class="loader"></div>
<div class="slide-effect-blog"><?php echo $slideEffect; ?></div>
<div class="hs_wrap blog-slider">
	<div class="flexslider">
        <ul class="slides">
 				
					    <?php
                            $wpq = array( 'cat' => $categoryNumber, 'orderby' => '', 'posts_per_page' => $recentPostsNumber );
                            
                            $type_posts = new WP_Query ($wpq); ?> 

                          <?php while ( $type_posts->have_posts() ) : $type_posts->the_post(); global $post; ?> 
                              
                                  <li>
                                  <div class="slide">
                                      <div class="slider-overlay">
                                        	<div class="slider-overlay-inner">
                                        <h2 class="slider-title"><?php gpp_truncate_title(16); ?></h2>
                                        		<div class="entry-meta">
																						<?php
																							printf( __( '<span class="sep"> by </span> <span class="author vcard">%8$s</span> <span class="sep">on</span> <time class="entry-date" datetime="%2$s" pubdate> <span class="month">%3$s</span> <span class="day">%4$s</span> <span class="year">%5$s</span></time>', 'gpp_lang' ),
																								get_permalink(),
																								get_the_date( 'c' ),
																								get_the_date('M'), // Jan, Feb, etc
																								get_the_date('d'), // 01-31
																								get_the_date('Y'), // 1979, etc
																								get_author_posts_url( get_the_author_meta( 'ID' ) ),
																								sprintf( esc_attr__( 'View all posts by %s', 'gpp_lang' ), get_the_author() ),
																								get_the_author()
																							);
																						?>
																					</div><!-- .entry-meta -->
                                        </div> <!--  .slider-overlay-inner  -->                                            
                                      </div>  <!--  .slider-overlay  -->
                                      
                                  <?php if ( has_post_thumbnail() ) { ?>
                                      <a href="<?php the_permalink(); ?>">
                                      <?php the_post_thumbnail( 'home-slider-thumb', 'title=' ); ?>
                                      </a>                                       
                                  <?php } ?> 
                                 </div> <!--  .slide  --> 
                                 </li>
                          <?php endwhile; wp_reset_postdata(); ?>					   
					   
					</ul><!-- .slides -->
  			</div><!-- .flexslider -->
  			</div><!-- #hs_wrap -->
          			
            <?php

                echo $after_widget; 

            }
              /*Saves the settings. */
                function update($new_instance, $old_instance){
            		$instance = $old_instance;  		
            		$instance['title'] = stripslashes($new_instance['title']);
            		$instance['categoryNumber'] = stripslashes($new_instance['categoryNumber']);
            		$instance['recentPostsNumber'] = stripslashes($new_instance['recentPostsNumber']);
            		$instance['slideEffect'] = stripslashes($new_instance['slideEffect']);   


            		return $instance;
            	}

              /*Creates the form for the widget in the back-end. */
                function form($instance){
            		//Defaults
            		$instance = wp_parse_args( (array) $instance, array('title'=>'Recent Posts', 'categoryNumber'=>'','recentPostsNumber'=>'3', 'slideEffect'=>'fade') ); 
                    $title = htmlspecialchars($instance['title']);
                    $recentPostsNumber = htmlspecialchars($instance['recentPostsNumber']);
            		$categoryNumber = htmlspecialchars($instance['categoryNumber']);
            		$slideEffect = htmlspecialchars($instance['slideEffect']);

            		 # Title
                		echo '<p><label for="' . $this->get_field_id('title') . '">' . 'Title:' . '</label><input class="widefat" id="' . $this->get_field_id('title') . '" name="' . $this->get_field_name('title') . '" type="text" value="' . $title . '" /></p>'; 
                		
            		 # Blog Category 
            		 $categories = get_categories();   ?>
            		 <p><label for="<?php echo $this->get_field_id('categoryNumber') ?>"> Select Category : </label>
            		     <select id="<?php echo $this->get_field_id('categoryNumber'); ?>" name="<?php echo $this->get_field_name('categoryNumber'); ?>" value="<?php echo $categoryNumber; ?>"> 
                		 
                		 <option value="" <?php if($categoryNumber == '') echo 'selected="selected"'; ?>>All Categories</option>
                	     <?php foreach ($categories as $category) {  ?>
                             <option value="<?php echo $category->cat_ID; ?>" <?php if($categoryNumber == $category->cat_ID) echo 'selected="selected"'; ?>><?php echo $category->name; ?></option>  
                         <?php } ?>                	  
                	  </select>
                    </p>  
                   
                    <!--  Number of Products in Slider  -->
            	   <?php echo '<p><label for="' . $this->get_field_id('recentPostsNumber') . '">' . 'Number of Recent Posts:' . '</label><input class="widefat" id="' . $this->get_field_id('recentPostsNumber') . '" name="' . $this->get_field_name('recentPostsNumber') . '" type="text" value="' . $recentPostsNumber . '" /></p>'; ?>
            		
            		<!--  Slider Effect  -->
            		<p><label for="<?php echo $this->get_field_id('slideEffect');?>">Slider Transition Effect: </label>
            		    <select id="<?php echo $this->get_field_id('slideEffect'); ?>" name="<?php echo $this->get_field_name('slideEffect'); ?>">
                          <option value="fade" <?php if($slideEffect == 'fade') echo 'selected="selected"'; ?>>Fade</option>
                          <option value="slide" <?php if($slideEffect == 'slide') echo 'selected="selected"'; ?>>Slide</option>
                        </select>
                    </p> 
                   <?php
            	}

            }
           
      			
            function GPPBlogSliderWidgetInit() {
            	register_widget('GPPBlogSliderWidget');
            }

            add_action('widgets_init', 'GPPBlogSliderWidgetInit');
?>