<?php class GPPSliderWidget extends WP_Widget
{
    function GPPSliderWidget(){
		$widget_ops = array('description' => 'Displays a product slider. Only use this in the Homepage widget position. Make sure you set a featured image for each product shown in this slider.');
		$control_ops = array('width' => 200, 'height' => 200);
		parent::WP_Widget(false,$name='GPP Product Slider',$widget_ops,$control_ops);
		if ( is_active_widget(false, false, $this->id_base, true) ){
                       add_action( 'wp_head', 'slider_product_js' );
                    }
    }

/* Displays the Widget in the front-end */
    function widget($args, $instance){
		extract($args);
		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title']);
		$categoryNumber = empty($instance['categoryNumber']) ? '' : $instance['categoryNumber'];
		$recentPostsNumber = empty($instance['recentPostsNumber']) ? '' : $instance['recentPostsNumber'];
		$slideEffect = empty($instance['slideEffect']) ? '' : $instance['slideEffect'];       
		
	    extract($args);
	   

         echo $before_widget;

    		if ( $title )
    		echo $before_title . $title . $after_title;	      
?>
<div class="loader"></div>
<div class="slide-effect-product"><?php echo $slideEffect; ?></div>
<div class="hs_wrap product-slider">
	<div class="flexslider">
        <ul class="slides">
                        <?php $wpq = array( 'post_type' => 'product', 'taxonomy' => 'product_cat', 'field'=>'slug', 'term' => $categoryNumber, 'orderby' => '', 'posts_per_page' => $recentPostsNumber );
                            
                        $type_posts = new WP_Query ($wpq); 
                        while ( $type_posts->have_posts() ) : $type_posts->the_post(); 
                          
                        global $post;                       
                        $_product = &new WC_Product( $post->ID ); ?> 
                          <li>
                          <div class="slide">
                              <?php if ($_product->is_on_sale()) : ?>

                              	<?php echo apply_filters('woocommerce_sale_flash', '<span class="onsale">'.__('Sale!', 'woocommerce').'</span>', $post, $_product); ?>
                              <?php endif; ?>
                                                                    
                              <div class="slider-overlay">
                              	<div class="slider-overlay-inner">
                                 <h2 class="slider-title"><?php gpp_truncate_title(16); ?></h2>
                        
                                	<!--  Display Product Price -->
                                  <span class="slider-product-price fancy">
                                      <?php woocommerce_template_loop_price($post, $_product); ?>
                                  </span> <!--  .slider-product-price  -->   
                              	</div> <!--  .slider-overlay-inner  -->                                                                                 
                              </div> <!--  .slider-overlay  -->   
                                     
                                  <?php if ( has_post_thumbnail() ) { ?>
                                     <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'home-slider-thumb', 'title=' ); ?></a>                                       
                                  <?php } ?> 
                                 </div> <!--  .slide  --> 
                                 </li>
                                 <?php endwhile; wp_reset_postdata(); ?>
					   
					</ul><!-- .slides -->
  			</div><!-- .flexslider -->
  			</div><!-- .hs_wrap --> 
  			  			
            <?php

                echo $after_widget; 

            }
              /*Saves the settings. */
                function update($new_instance, $old_instance){
            		$instance = $old_instance;  		
            		$instance['title'] = stripslashes($new_instance['title']);
            		$instance['categoryNumber'] = stripslashes($new_instance['categoryNumber']);
            		$instance['recentPostsNumber'] = stripslashes($new_instance['recentPostsNumber']);
            		$instance['slideEffect'] = stripslashes($new_instance['slideEffect']);   


            		return $instance;
            	}

              /*Creates the form for the widget in the back-end. */
                function form($instance){
            		//Defaults
            		$instance = wp_parse_args( (array) $instance, array('title'=>'Our Products', 'categoryNumber'=>'','recentPostsNumber'=>'3', 'slideEffect'=>'fade') ); 
                    $title = htmlspecialchars($instance['title']);
                    $recentPostsNumber = htmlspecialchars($instance['recentPostsNumber']);
            		$categoryNumber = htmlspecialchars($instance['categoryNumber']);
            		$slideEffect = htmlspecialchars($instance['slideEffect']);

            		 # Title
                		echo '<p><label for="' . $this->get_field_id('title') . '">' . 'Title:' . '</label><input class="widefat" id="' . $this->get_field_id('title') . '" name="' . $this->get_field_name('title') . '" type="text" value="' . $title . '" /></p>'; 
                		
            		 # Product Category 
            		 $productTerms = get_terms( 'product_cat');   ?>
            		 <p><label for="<?php echo $this->get_field_id('categoryNumber') ?>"> Select Category : </label>
            		     <select id="<?php echo $this->get_field_id('categoryNumber'); ?>" name="<?php echo $this->get_field_name('categoryNumber'); ?>" value="<?php echo $categoryNumber; ?>"> 
                		 <option value="" <?php if($categoryNumber == '') echo 'selected="selected"'; ?>>All Categories</option>
                	     <?php foreach ($productTerms as $term) {  ?>
                             <option value="<?php echo $term->slug; ?>" <?php if($categoryNumber == $term->slug) echo 'selected="selected"'; ?>><?php echo $term->name; ?></option>  
                         <?php } ?>                	  
                	  </select>
                    </p>  
                   
                    <!--  Number of Products in Slider  -->
            	   <?php echo '<p><label for="' . $this->get_field_id('recentPostsNumber') . '">' . 'Number of Recent Posts:' . '</label><input class="widefat" id="' . $this->get_field_id('recentPostsNumber') . '" name="' . $this->get_field_name('recentPostsNumber') . '" type="text" value="' . $recentPostsNumber . '" /></p>'; ?>
            		
            		<!--  Slider Effect  -->
            		<p><label for="<?php echo $this->get_field_id('slideEffect');?>">Slider Transition Effect: </label>
            		    <select id="<?php echo $this->get_field_id('slideEffect'); ?>" name="<?php echo $this->get_field_name('slideEffect'); ?>">
                          <option value="fade" <?php if($slideEffect == 'fade') echo 'selected="selected"'; ?>>Fade</option>
                          <option value="slide" <?php if($slideEffect == 'slide') echo 'selected="selected"'; ?>>Slide</option>
                        </select>
                    </p> 
                   <?php
            	}

            }

            function GPPSliderWidgetInit() {
            	register_widget('GPPSliderWidget');
            }

            add_action('widgets_init', 'GPPSliderWidgetInit');
            ?>