<?php

if (!function_exists("vcwccr_country_is_valid")) {

	//check if a country is valid or restricted depending of the operator
	function vcwccr_country_is_valid($countries, $my_country, $available_in_selected_countries) {

		$valid = true;

		if (empty($countries) || empty($my_country)) {
			$valid = true;
		} else {

			if (in_array($my_country, $countries)) {
				$valid = ( (bool) $available_in_selected_countries ) ? true : false;
			} else {
				$valid = ( (bool) $available_in_selected_countries ) ? false : true;
			}
		}

		return $valid;
	}

}


if (!function_exists("vcwccr_get_country_availability_operators")) {

	//get the country availability operators to display them in a select
	function vcwccr_get_country_availability_operators() {

		return array(
			"1" => __("Yes", VCWCCR_TEXT_DOMAIN),
			"0" => __("No", VCWCCR_TEXT_DOMAIN)
		);
	}

}

if (!function_exists("vcwccr_category_apply_restrictions_operators")) {

	//get the country availability operators to display them in a select
	function vcwccr_category_apply_restrictions_operators() {

		return array(
			"category" => __("Category only", VCWCCR_TEXT_DOMAIN),
			"products_only" => __("Products only", VCWCCR_TEXT_DOMAIN),
			"both" => __("Category and products", VCWCCR_TEXT_DOMAIN)
		);
	}

}

if (!function_exists("wcacr_save_disallowed_countries")) {

	function wcacr_save_disallowed_countries($post_id, $selected_countries, $operator = '1') {
		global $wpdb;
		$countries = new WC_Countries();
		$countries_list = $countries->get_countries();

		// WC caches the products list from the shortcode in a transient. We clear the cache when a post's country restrictions are updated
		$wpdb->query("DELETE FROM $wpdb->options WHERE option_name LIKE '%_transient_wc_product_loop%' OR option_name LIKE '%_transient_timeout_wc_product_loop%' ");
		
		
		if (empty($selected_countries)) {
			delete_post_meta($post_id, "wcacr_disallowed_countries");
			return;
		}

		if ($operator == "1") {

			foreach ($selected_countries as $selected_country) {

				unset($countries_list[$selected_country]);
			}

			update_post_meta($post_id, "wcacr_disallowed_countries", implode(',', vcwccr_sanitize_array(array_keys($countries_list))));
		} else {

			update_post_meta($post_id, "wcacr_disallowed_countries", implode(',', vcwccr_sanitize_array($selected_countries)));
		}
	}

}

if (!function_exists("wcacr_get_user_country")) {

	function wcacr_get_user_country() {

		$my_country = isset($_COOKIE[WCACR_USER_COUNTRY_COOKIE]) ? $_COOKIE[WCACR_USER_COUNTRY_COOKIE] : '';

		return sanitize_text_field($my_country);
	}

}

if (!function_exists("wcacr_set_user_country")) {

	function wcacr_set_user_country($my_country = null) {
		if (get_option('wccr_geolocation_method', 'ip') === 'ip' && class_exists('WC_Geolocation')) {
			if (empty($_COOKIE[WCACR_USER_COUNTRY_COOKIE])) {
				$location = WC_Geolocation::geolocate_ip();
				$my_country = $location['country'];
			}
		}

		$my_country = apply_filters('vcwccr_set_user_country', $my_country);

		if ($my_country) {
			setcookie(WCACR_USER_COUNTRY_COOKIE, $my_country, time() + WEEK_IN_SECONDS, "/");
			$_COOKIE[WCACR_USER_COUNTRY_COOKIE] = $my_country;
		}
		
	}

}

if (!function_exists("vcwccr_sanitize_array")) {

	function vcwccr_sanitize_array($array) {

		if (!empty($array)) {
			$array = array_filter(array_map("sanitize_text_field", $array));
		}

		return $array;
	}

}

if (!function_exists("vcwccr_is_restricted")) {

	function vcwccr_is_restricted($id, $type = "product_or_variation") {

		//getting current country	
		$my_country = wcacr_get_user_country();
		if (empty($my_country)) {
			return false;
		}

		//getting restrictions if there are
		if ($type == "category") {

			$selected_countries = vcwccr_get_selected_countries($id, "category");

			$available = get_term_meta($id, "vcwccr_availability_operator", true);

			return !vcwccr_country_is_valid($selected_countries, $my_country, $available);
		} else {
			$selected_countries = vcwccr_get_selected_countries($id);
			$available = intval(get_post_meta($id, "vcwccr_availability_operator", true));
		}

		return !vcwccr_country_is_valid($selected_countries, $my_country, $available);
	}

}

if (!function_exists("vcwccr_shop_is_available")) {

	function vcwccr_shop_is_available() {

		$my_country = wcacr_get_user_country();
		if (empty($my_country)) {
			return true;
		}

		$products_selected_countries_setting = get_option("vcwccr_selected_countries");
		$products_selected_operator_setting = get_option("vcwccr_availability_operator");

		$products_selected_countries = apply_filters("vcwccr_selected_countries_before_shop_availability_check", $products_selected_countries_setting);

		$products_selected_operator = apply_filters("vcwccr_availability_operator_before_shop_availability_check", $products_selected_operator_setting);

		return vcwccr_country_is_valid($products_selected_countries, $my_country, intval($products_selected_operator));
	}

}

if (!function_exists("vcwccr_get_disallowed_products")) {

	function vcwccr_get_disallowed_products() {

		global $wpdb;

		$my_country = esc_sql(wcacr_get_user_country());

		if (empty($my_country)) {
			return;
		}


		$cache_key = 'wcr_disallowed_posts_' . $my_country;
		$disallowed_products = wp_cache_get($cache_key);

		if (!is_array($disallowed_products)) {
			$disallowed_products = array_map('intval', $wpdb->get_col("SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'wcacr_disallowed_countries' AND meta_value LIKE '%$my_country%' "));
			wp_cache_set($cache_key, $disallowed_products);
		}

		return $disallowed_products;
	}

}

if (!function_exists("vcwccr_get_attributes")) {

	//gets the list of attributes
	function vcwccr_get_attributes() {

		global $wpdb;

		$table = $wpdb->postmeta;

		$sql = $wpdb->prepare("SELECT meta_value FROM $table WHERE meta_key = %s", array("_product_attributes"));

		$custom_attributes_raw = $wpdb->get_results($sql);

		$custom_attributes = vcwccr_parse_attributes($custom_attributes_raw);

		$global_attributes_raw = $wpdb->get_col("SELECT CONCAT(tax.taxonomy, ':', term.slug, ':', term.name) FROM $wpdb->term_taxonomy as tax LEFT JOIN $wpdb->terms as term ON term.term_id = tax.term_id WHERE tax.taxonomy LIKE 'pa_%'");

		$global_attributes = array();

		foreach ($global_attributes_raw as $global_attribute) {

			$global_attribute_exploded = explode(":", $global_attribute);

			$global_attribute_key = $global_attribute_exploded[0] . ':' . $global_attribute_exploded[1];  //1 term slug

			$global_attribute_text = $global_attribute_exploded[0] . ':' . $global_attribute_exploded[2];  //2 term name

			$global_attributes[$global_attribute_key] = $global_attribute_text;
		}

		$results = array_filter(array_unique(array_merge($custom_attributes, $global_attributes)));

		return apply_filters('wcacr_attribute_options', $results);
	}

}

if (!function_exists("vcwccr_parse_attributes")) {

	//auxiliar function that return the options to show them in the select multiple
	function vcwccr_parse_attributes($results) {

		$options = array();

		foreach ($results as $result) {

			$current_attributes = unserialize($result->meta_value);

			$attributesKeys = array_keys($current_attributes);

			foreach ($attributesKeys as $attributeKey) {

				if ($current_attributes[$attributeKey]["is_taxonomy"]) {
					continue;
				}
				$current_parsed_attribute_values = vcwccr_parse_attribute_values($attributeKey, explode("|", $current_attributes[$attributeKey]["value"]));
				$options = array_merge($options, $current_parsed_attribute_values);
			}
		}

		$options = array_unique($options);

		asort($options);

		return $options;
	}

}

if (!function_exists("vcwccr_parse_attribute_values")) {

	//second auxiliar function that prepares and get the attributes 
	function vcwccr_parse_attribute_values($attribute_key, $attribute_values) {

		$attribute_values_parsed = array();

		foreach ($attribute_values as $attribute_value) {
			$option = $attribute_key . ":" . trim($attribute_value);
			$attribute_values_parsed[$option] = $option;
		}

		return $attribute_values_parsed;
	}

}

if (!function_exists('vcwccr_get_selected_countries')) {

	function vcwccr_get_selected_countries($product_id, $type = "product_or_variation") {

		if ($type == "category") {
			$selected_countries = get_term_meta($product_id, 'vcwccr_selected_countries', true);
		} else {
			$selected_countries = get_post_meta($product_id, 'vcwccr_selected_countries', true);
		}

		if (is_string($selected_countries)) {
			$selected_countries = array_map('trim', explode(',', $selected_countries));
		}

		return $selected_countries;
	}

}


