<?php
/**
 * @package OneSocial Child Theme
 * The parent theme functions are located at /onesocial/buddyboss-inc/theme-functions.php
 * Add your own functions in this file.
 */

/**
 * Sets up theme defaults
 *
 * @since OneSocial Child Theme 1.0.0
 */
function onesocial_child_theme_setup()
{
  /**
   * Makes child theme available for translation.
   * Translations can be added into the /languages/ directory.
   * Read more at: http://www.buddyboss.com/tutorials/language-translations/
   */

  // Translate text from the PARENT theme.
  load_theme_textdomain( 'onesocial', get_stylesheet_directory() . '/languages' );

  // Translate text from the CHILD theme only.
  // Change 'onesocial' instances in all child theme files to 'onesocial_child_theme'.
  // load_theme_textdomain( 'onesocial_child_theme', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'onesocial_child_theme_setup' );

/**
 * Enqueues scripts and styles for child theme front-end.
 *
 * @since OneSocial Child Theme  1.0.0
 */
function onesocial_child_theme_scripts_styles()
{
  /**
   * Scripts and Styles loaded by the parent theme can be unloaded if needed
   * using wp_deregister_script or wp_deregister_style.
   *
   * See the WordPress Codex for more information about those functions:
   * http://codex.wordpress.org/Function_Reference/wp_deregister_script
   * http://codex.wordpress.org/Function_Reference/wp_deregister_style
   **/

  /*
   * Styles
   */
  wp_enqueue_style( 'onesocial-child-custom', get_stylesheet_directory_uri().'/css/custom.css' );
}
add_action( 'wp_enqueue_scripts', 'onesocial_child_theme_scripts_styles', 9999 );


/****************************** CUSTOM FUNCTIONS ******************************/

// Add your own custom functions here
//Add styling to Admin area
add_action( 'admin_enqueue_scripts', 'load_admin_style' );

function load_admin_style() {
	wp_register_style( 'admin_css', get_stylesheet_directory_uri() . '/admin-style.css', false, '1.0.0' );
	//OR
	wp_enqueue_style( 'admin_css', get_stylesheet_directory_uri() . '/admin-style.css', false, '1.0.0' );
}

/* Allow hide lable in gravity forms */
add_filter( 'gform_enable_field_label_visibility_settings', '__return_true' );

/* stop visual composer nag */
setcookie('vchideactivationmsg', '1', strtotime('+3 years'), '/');
setcookie('vchideactivationmsg_vc11', (defined('WPB_VC_VERSION') ? WPB_VC_VERSION : '1'), strtotime('+3 years'), '/');

/* stop visual composer ultimate addons nag */
define('BSF_PRODUCTS_NOTICES', false);



/*** Remove Query String from Static Resources 
function remove_cssjs_ver( $src ) {
 if( strpos( $src, '?ver=' ) )
 $src = remove_query_arg( 'ver', $src );
 return $src;
}
add_filter( 'style_loader_src', 'remove_cssjs_ver', 10, 2 );
add_filter( 'script_loader_src', 'remove_cssjs_ver', 10, 2 );***/

/* Remove Seller Info Tab */
remove_filter( 'woocommerce_product_tabs', array( 'WCV_Vendor_Shop', 'seller_info_tab' ) );

/** 
 *Reduce the strength requirement on the woocommerce password.
 * 
 * Strength Settings
 * 3 = Strong (default)
 * 2 = Medium
 * 1 = Weak
 * 0 = Very Weak / Anything
 */
function reduce_woocommerce_min_strength_requirement( $strength ) {
    return 1;
}
add_filter( 'woocommerce_min_password_strength', 'reduce_woocommerce_min_strength_requirement' );

// The email function hooked that display the text
add_action( 'woocommerce_email_order_details', 'display_applied_coupons', 10, 4 );
function display_applied_coupons( $order, $sent_to_admin, $plain_text, $email ) {

    // Only for admins and when there at least 1 coupon in the order
    if ( ! $sent_to_admin && count($order->get_items('coupon') ) == 0 ) return;

    foreach( $order->get_items('coupon') as $coupon ){
        $coupon_codes[] = $coupon->get_code();
    }
    // For one coupon
    if( count($coupon_codes) == 1 ){
        $coupon_code = reset($coupon_codes);
        echo '<p>'.__( 'Coupon Used: ').$coupon_code.'<p>';
    } 
    // For multiple coupons
    else {
        $coupon_codes = implode( ', ', $coupon_codes);
        echo '<p>'.__( 'Coupons Used: ').$coupon_codes.'<p>';
    }
}

// Add role class to body
if ( is_user_logged_in() ) {
    add_filter('body_class','add_role_to_body');
    add_filter('admin_body_class','add_role_to_body');
}
function add_role_to_body($classes) {
    $current_user = new WP_User(get_current_user_id());
    $user_role = array_shift($current_user->roles);
    if (is_admin()) {
        $classes .= 'role-'. $user_role;
    } else {
        $classes[] = 'role-'. $user_role;
    }
    return $classes;
}

/*
	Plugin Name: Add URL Slugs as Body Classes
	Plugin URI: http://aarontgrogg.com/2012/02/24/wordpress-plugin-add-url-slugs-as-body-classes/
	Description: Add page name and/or category slugs as additional `&lt;body&gt;` classes.
	Version: 1.3
	Author: Aaron T. Grogg
	Author URI: http://aarontgrogg.com/
	License: GPLv2 or later
*/

	// this only applies for non-admin pages
	if ( !is_admin() && !function_exists( 'USBC_add_body_class' ) ) :


		//	Add deconstructed URI as <body> classes
		//	$classes = array of classes WP is already planning to add
		function USBC_add_body_class( $classes )  {

			// get the global post variable
			global $post;

			// make sure we're on a post page
			if ($post && $post->ID) :

				// loop through any categories
				foreach( get_the_category($post->ID) as $category ) {
					// and push the trimmed version to the $classes array
					$classes[] = trim( $category->category_nicename );
				}

				// get the current page's URI (the part _after_ your domain name)
				$uri = $_SERVER["REQUEST_URI"];
				// explode that string into an array of "pieces"
				$bodyclass = explode('/',$uri);
				// loop through those pieces and push each into the $classes array
				foreach($bodyclass as $category) {
					$classes[] = trim($category);
				}

			endif; // $post...

			// return a unique-onlye version of the array to WP
			return array_unique($classes);
		
		}

		add_filter('post_class', 'USBC_add_body_class');
		add_filter('body_class', 'USBC_add_body_class');

	endif; // !is_admin...
	
/**
* @snippet Product Category > Body CSS Class | WooCommerce
* @how-to Watch tutorial @ https://businessbloomer.com/?p=19055
* @sourcecode https://businessbloomer.com/?p=21507
* @author Rodolfo Melogli
* @testedwith WooCommerce 2.6.12, WordPress 4.7.1
*/
 
add_filter( 'body_class', 'bbloomer_wc_product_cats_css_body_class' );
 
function bbloomer_wc_product_cats_css_body_class( $classes ){
  if( is_singular( 'product' ) )
  {
    $custom_terms = get_the_terms(0, 'product_tag');
    if ($custom_terms) {
      foreach ($custom_terms as $custom_term) {
        $classes[] = 'product_cat_' . $custom_term->slug;
      }
    }
  }
  return $classes;
}	

// Remove WooCommerce Updater
remove_action('admin_notices', 'woothemes_updater_notice');

// Allow shop managers to access wordpress admin
// WILL ONLY WORK FOR v1.3.8 and below. THIS WILL BREAK in v1.4.0. 
/*add_filter( 'wcv_admin_lockout_capability', 'allow_shop_managers'); 
function allow_shop_managers( ){ 
	return 'manage_woocommerce'; 
}*/

/* Had to disable due to Stripe's poicy on non-fda supplements 10/24/17 */
// Add this to your themes functions.php this will not work with free - only the pro dashboard. 
/*add_action( 'wcv_pro_before_dashboard', 'add_stripe_notice' ); 
function add_stripe_notice( ){ 
	$stripe_token = get_user_meta( get_current_user_id(), '_stripe_connect_access_key' , true ); 
	if ( ! $stripe_token ){  
		echo '<div class="woocommerce-error"><p>Connect your Stripe account to accept payments! <a href="/athlete-pro-dashboard/settings/#payment">Click here</a>.</p></div>';
	}
}*/ // add_stripe_notice() 

add_action( 'wcv_pro_before_dashboard', 'add_paypal_notice' ); 
function add_paypal_notice( ){ 	
		echo '<div class="woocommerce-error"><p>In order to get paid commissions, please provide your PayPal email address to <a href="mailto:stephaney@nuethix.com">Stephaney Theobald</a>. If you need to sign up for a PayPal account, please <a href="https://www.paypal.com/" target="_blank">go here.</p></div>';
} // add_paypal_notice() 

/* store link product page - title area */
/*add_action('wcv_before_vendor_store_header', 'store_link_product_page',6);
function store_link_product_page() {
  $vendor_shop 		= urldecode( get_query_var( 'vendor_shop' ) );
  $vendor_id   		= get_the_author_meta('ID');
  $store_url      = WCVendors_Pro_Vendor_Controller::get_vendor_store_url( $vendor_id  );
  $shop_name      = get_user_meta( $vendor_id, 'pv_shop_name', true );
  $store_link     = '<a href="'.$store_url.'">'.$shop_name.'</a>';
  echo '<p>Athlete Store: '.$store_link.'</p>';
}*/

?>