<?php
$rules = WCVendors_Pro_Commission_Controller::commission_rules();
?>
<div class="options_group commission-tier-wrapper">
	<?php if ( isset( $field_details['title'] ) && $field_details['title']) : ?>
        <h3><?php echo esc_attr( $field_details['title'] ); ?></h3>
	<?php endif; ?>
    <p><?php echo esc_attr( $field_details['desc'] ); ?></p>
    <table class="commission-tiers-table widefat" id="<?php echo esc_attr( $field_details['id'] ); ?>_table">
        <thead>
        <tr>
            <th><?php _e( 'Name', 'wcvendors-pro' ); ?></th>
            <th><?php _e( 'Rule', 'wcvendors-pro' ); ?></th>
            <th><?php echo esc_attr( $field_details['value_label'] ); ?></th>
            <th><?php _e( 'Type', 'wcvendors-pro' ); ?></th>
            <th><?php _e( 'Amount', 'wcvendors-pro' ); ?></th>
            <th><?php _e( 'Percent', 'wcvendors-pro' ); ?></th>
            <th><?php _e( 'Fee', 'wcvendors-pro' ); ?></th>
            <th class="actions"></th>
        </tr>
        </thead>
        <tbody class="commission-tiers">
		<?php if ( $commission_tiers ) : ?>
			<?php foreach ( $commission_tiers as $index => $tier ) : ?>
				<?php
				$tier = wp_parse_args( $tier, array(
					'amount'  => '',
					'fee'     => '',
					'percent' => '',
				) );
				?>
                <tr class="tier-row">
                    <td class="input-text commission-field">
                        <input type="text"
                               value="<?php echo esc_attr( $tier['name'] ); ?>"
                               name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][name]"
                               placeholder="<?php _e( 'Name/Description', 'wcvendors-pro' ); ?>"
                               class="name"
                        />
                    </td>
                    <td class="input-text wc_input_decimal commission-field">
                        <select name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][rule]" class="rule" required>
							<?php
							foreach ( $rules as $rule => $label ) {
								$selected = selected( $rule, $tier['rule'], false );
								?>
                                <option value="<?php echo esc_attr( $rule ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_attr( $label ); ?></option>
								<?php
							}
							?>
                        </select>
                    </td>
                    <td class="input-text commission-field">
                        <input type="number"
                               value="<?php echo esc_attr( $tier['value'] ); ?>"
                               name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][value]"
                               placeholder="<?php _e( 'Value', 'wcvendors-pro' ); ?>"
                               class="value"
                               min="0"
                               required/>
                    </td>
                    <td class="form-field commission-field">
                        <select name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][type]" class="commission-types" required>
                            <option></option>
							<?php
							foreach ( WCVendors_Pro_Commission_Controller::commission_types() as $option => $option_name ) {
								$selected = selected( $option, $tier['type'], false );
								echo '<option value="' . esc_attr( $option ) . '" ' . $selected . '>' . esc_attr( $option_name ) . '</option>';
							}
							?>
                        </select>
                    </td>
                    <td class="input-text wc_input_decimal commission-field">
                        <input type="number"
                               value="<?php echo $tier['amount']; ?>"
                               name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][amount]"
                               placeholder="<?php _e( 'Amount', 'wcvendors-pro' ); ?>"
                               class="amount"
                               required/>
                    </td>
                    <td class="input-text wc_input_decimal commission-field">
                        <input type="number"
                               value="<?php echo esc_attr( $tier['percent'] ); ?>"
                               name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][percent]"
                               placeholder="<?php _e( 'Percent', 'wcvendors-pro' ); ?>"
                               class="percent"
                               min="0"
                               max="100"
                               step="0.01"
                               required/>
                    </td>
                    <td class="input-text wc_input_decimal commission-field">
                        <input type="number"
                               value="<?php echo esc_attr( $tier['fee'] ); ?>"
                               name="commission_tiers[<?php echo esc_attr( $field_details['key'] ); ?>][<?php echo $index; ?>][fee]"
                               placeholder="<?php _e( 'Fee', 'wcvendors-pro' ); ?>"
                               class="fee"
                               required/>
                    </td>
                    <td class="actions form-field">
                        <a href="#" class="remove-row" data-key="<?php echo esc_attr( $field_details['key'] ); ?>">
                            <svg class="wcv-icon wcv-icon-sm">
                                <use xlink:href="<?php echo WCV_PRO_PUBLIC_ASSETS_URL; ?>svg/wcv-icons.svg#wcv-icon-times"></use>
                            </svg>
                        </a>
                    </td>
                </tr>
			<?php
			endforeach;
		endif;
		?>
        </tbody>
        <tfoot>
        <tr>
            <td>
                <a href="#" class="add-vendor-sales-commission button" data-key="<?php echo esc_attr( $field_details['key'] ); ?>">
		            <?php echo esc_attr( __( 'Add row', 'wc-vendor-pro' ) ); ?>
                </a>
            </td>
            <td colspan="7"></td>
        </tr>
        </tfoot>
    </table>
</div>
